/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import io.prestosql.hive.$internal.org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringLTrim;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBaseTrim;

@Description(name="ltrim", value="_FUNC_(str) - Removes the leading space characters from str ", extended="Example:\n  > SELECT _FUNC_('   facebook') FROM src LIMIT 1;\n  'facebook'")
@VectorizedExpressions(value={StringLTrim.class})
public class GenericUDFLTrim
extends GenericUDFBaseTrim {
    public GenericUDFLTrim() {
        super("ltrim");
    }

    @Override
    protected String performOp(String val) {
        return StringUtils.stripStart(val, " ");
    }
}

