/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.common.util;

import io.prestosql.hive.$internal.com.google.common.collect.Sets;
import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public class ACLConfigurationParser {
    private static final Logger LOG = LoggerFactory.getLogger(ACLConfigurationParser.class);
    private static final String WILDCARD_ACL_VALUE = "*";
    private static final Pattern splitPattern = Pattern.compile("\\s+");
    private final Set<String> allowedUsers = Sets.newLinkedHashSet();
    private final Set<String> allowedGroups = Sets.newLinkedHashSet();

    public ACLConfigurationParser(Configuration conf, String confPropertyName) {
        this.parse(conf, confPropertyName);
    }

    private boolean isWildCard(String aclStr) {
        return aclStr.trim().equals(WILDCARD_ACL_VALUE);
    }

    private void parse(Configuration conf, String configProperty) {
        String aclsStr = conf.get(configProperty);
        if (aclsStr == null || aclsStr.isEmpty()) {
            return;
        }
        if (this.isWildCard(aclsStr)) {
            this.allowedUsers.add(WILDCARD_ACL_VALUE);
            return;
        }
        String[] splits = splitPattern.split(aclsStr);
        int counter = -1;
        String userListStr = null;
        String groupListStr = null;
        for (String s : splits) {
            if (s.isEmpty() && userListStr != null) continue;
            if (++counter == 0) {
                userListStr = s;
                continue;
            }
            if (counter == 1) {
                groupListStr = s;
                continue;
            }
            LOG.warn("Invalid configuration specified for " + configProperty + ", ignoring configured ACLs, value=" + aclsStr);
            return;
        }
        if (userListStr == null) {
            return;
        }
        if (userListStr.length() >= 1) {
            this.allowedUsers.addAll(StringUtils.getTrimmedStringCollection((String)userListStr));
        }
        if (groupListStr != null && groupListStr.length() >= 1) {
            this.allowedGroups.addAll(StringUtils.getTrimmedStringCollection((String)groupListStr));
        }
    }

    public Set<String> getAllowedUsers() {
        return Collections.unmodifiableSet(this.allowedUsers);
    }

    public Set<String> getAllowedGroups() {
        return Collections.unmodifiableSet(this.allowedGroups);
    }

    public void addAllowedUser(String user) {
        if (io.prestosql.hive.$internal.org.apache.commons.lang3.StringUtils.isBlank(user)) {
            return;
        }
        if (this.allowedUsers.contains(WILDCARD_ACL_VALUE)) {
            return;
        }
        if (user.equals(WILDCARD_ACL_VALUE)) {
            this.allowedUsers.clear();
            this.allowedGroups.clear();
        }
        this.allowedUsers.add(user);
    }

    public void addAllowedGroup(String group) {
        this.allowedGroups.add(group);
    }

    public String toAclString() {
        return this.toString();
    }

    public String toString() {
        if (this.getAllowedUsers().contains(WILDCARD_ACL_VALUE)) {
            return WILDCARD_ACL_VALUE;
        }
        if (this.allowedUsers.size() == 0 && this.allowedGroups.size() == 0) {
            return " ";
        }
        String userString = this.constructCsv(this.allowedUsers);
        String groupString = "";
        if (this.allowedGroups.size() > 0) {
            groupString = " " + this.constructCsv(this.allowedGroups);
        }
        return userString + groupString;
    }

    private String constructCsv(Set<String> inSet) {
        StringBuilder sb = new StringBuilder();
        if (inSet != null) {
            boolean isFirst = true;
            for (String s : inSet) {
                if (!isFirst) {
                    sb.append(",");
                } else {
                    isFirst = false;
                }
                sb.append(s);
            }
        }
        return sb.toString();
    }
}

