/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.mapreduce;

import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.mapred.OutputCommitter;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hive.hcatalog.common.HCatUtil;
import org.apache.hive.hcatalog.mapreduce.HCatMapRedUtil;
import org.apache.hive.hcatalog.mapreduce.OutputCommitterContainer;

class DefaultOutputCommitterContainer
extends OutputCommitterContainer {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultOutputCommitterContainer.class);

    public DefaultOutputCommitterContainer(JobContext context, OutputCommitter baseCommitter) throws IOException {
        super(context, baseCommitter);
    }

    public void abortTask(TaskAttemptContext context) throws IOException {
        this.getBaseOutputCommitter().abortTask((TaskAttemptContext)HCatMapRedUtil.createTaskAttemptContext(context));
    }

    public void commitTask(TaskAttemptContext context) throws IOException {
        this.getBaseOutputCommitter().commitTask((TaskAttemptContext)HCatMapRedUtil.createTaskAttemptContext(context));
    }

    public boolean needsTaskCommit(TaskAttemptContext context) throws IOException {
        return this.getBaseOutputCommitter().needsTaskCommit((TaskAttemptContext)HCatMapRedUtil.createTaskAttemptContext(context));
    }

    public void setupJob(JobContext context) throws IOException {
        this.getBaseOutputCommitter().setupJob((JobContext)HCatMapRedUtil.createJobContext(context));
    }

    public void setupTask(TaskAttemptContext context) throws IOException {
        this.getBaseOutputCommitter().setupTask((TaskAttemptContext)HCatMapRedUtil.createTaskAttemptContext(context));
    }

    public void abortJob(JobContext jobContext, JobStatus.State state) throws IOException {
        this.getBaseOutputCommitter().abortJob((JobContext)HCatMapRedUtil.createJobContext(jobContext), state);
        this.cleanupJob(jobContext);
    }

    public void commitJob(JobContext jobContext) throws IOException {
        this.getBaseOutputCommitter().commitJob((JobContext)HCatMapRedUtil.createJobContext(jobContext));
        this.cleanupJob(jobContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupJob(JobContext context) throws IOException {
        IMetaStoreClient client;
        block4: {
            this.getBaseOutputCommitter().cleanupJob((JobContext)HCatMapRedUtil.createJobContext(context));
            client = null;
            try {
                HiveConf hiveConf = HCatUtil.getHiveConf(context.getConfiguration());
                client = HCatUtil.getHiveMetastoreClient(hiveConf);
                String tokenStrForm = client.getTokenStrForm();
                if (tokenStrForm == null || context.getConfiguration().get("mapreduce.lib.hcatoutput.token.sig") == null) break block4;
                client.cancelDelegationToken(tokenStrForm);
            }
            catch (Exception e) {
                try {
                    LOG.warn("Failed to cancel delegation token", e);
                }
                catch (Throwable throwable) {
                    HCatUtil.closeHiveClientQuietly(client);
                    throw throwable;
                }
                HCatUtil.closeHiveClientQuietly(client);
            }
        }
        HCatUtil.closeHiveClientQuietly(client);
    }
}

