/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.internal.column.columnindex;

import io.prestosql.hive.$internal.parquet.it.unimi.dsi.fastutil.longs.LongArrayList;
import io.prestosql.hive.$internal.parquet.it.unimi.dsi.fastutil.longs.LongList;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.parquet.filter2.predicate.Statistics;
import org.apache.parquet.internal.column.columnindex.ColumnIndexBuilder;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.PrimitiveComparator;
import org.apache.parquet.schema.PrimitiveType;

class LongColumnIndexBuilder
extends ColumnIndexBuilder {
    private final LongList minValues = new LongArrayList();
    private final LongList maxValues = new LongArrayList();

    LongColumnIndexBuilder() {
    }

    private static long convert(ByteBuffer buffer) {
        return buffer.order(ByteOrder.LITTLE_ENDIAN).getLong(0);
    }

    private static ByteBuffer convert(long value) {
        return ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(0, value);
    }

    @Override
    void addMinMaxFromBytes(ByteBuffer min, ByteBuffer max) {
        this.minValues.add(LongColumnIndexBuilder.convert(min));
        this.maxValues.add(LongColumnIndexBuilder.convert(max));
    }

    @Override
    void addMinMax(Object min, Object max) {
        this.minValues.add((long)((Long)min));
        this.maxValues.add((long)((Long)max));
    }

    ColumnIndexBuilder.ColumnIndexBase<Long> createColumnIndex(PrimitiveType type) {
        LongColumnIndex columnIndex = new LongColumnIndex(type);
        LongColumnIndex.access$102(columnIndex, this.minValues.toLongArray());
        LongColumnIndex.access$202(columnIndex, this.maxValues.toLongArray());
        return columnIndex;
    }

    @Override
    void clearMinMax() {
        this.minValues.clear();
        this.maxValues.clear();
    }

    @Override
    int compareMinValues(PrimitiveComparator<Binary> comparator, int index1, int index2) {
        return comparator.compare(this.minValues.get(index1), this.minValues.get(index2));
    }

    @Override
    int compareMaxValues(PrimitiveComparator<Binary> comparator, int index1, int index2) {
        return comparator.compare(this.maxValues.get(index1), this.maxValues.get(index2));
    }

    @Override
    int sizeOf(Object value) {
        return 8;
    }

    private static class LongColumnIndex
    extends ColumnIndexBuilder.ColumnIndexBase<Long> {
        private long[] minValues;
        private long[] maxValues;

        private LongColumnIndex(PrimitiveType type) {
            super(type);
        }

        @Override
        ByteBuffer getMinValueAsBytes(int pageIndex) {
            return LongColumnIndexBuilder.convert(this.minValues[pageIndex]);
        }

        @Override
        ByteBuffer getMaxValueAsBytes(int pageIndex) {
            return LongColumnIndexBuilder.convert(this.maxValues[pageIndex]);
        }

        @Override
        String getMinValueAsString(int pageIndex) {
            return this.stringifier.stringify(this.minValues[pageIndex]);
        }

        @Override
        String getMaxValueAsString(int pageIndex) {
            return this.stringifier.stringify(this.maxValues[pageIndex]);
        }

        @Override
        <T extends Comparable<T>> Statistics<T> createStats(int arrayIndex) {
            return new Statistics<Long>(this.minValues[arrayIndex], this.maxValues[arrayIndex], this.comparator);
        }

        @Override
        ColumnIndexBuilder.ColumnIndexBase.ValueComparator createValueComparator(Object value) {
            final long v = (Long)value;
            return new ColumnIndexBuilder.ColumnIndexBase.ValueComparator(){

                @Override
                int compareValueToMin(int arrayIndex) {
                    return comparator.compare(v, minValues[arrayIndex]);
                }

                @Override
                int compareValueToMax(int arrayIndex) {
                    return comparator.compare(v, maxValues[arrayIndex]);
                }
            };
        }

        static /* synthetic */ long[] access$102(LongColumnIndex x0, long[] x1) {
            x0.minValues = x1;
            return x1;
        }

        static /* synthetic */ long[] access$202(LongColumnIndex x0, long[] x1) {
            x0.maxValues = x1;
            return x1;
        }
    }
}

