/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.client;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class IntervalYearMonth {
    private static final String INT_MIN_VALUE = "-178956970-8";
    private static final Pattern FORMAT = Pattern.compile("(\\d+)-(\\d+)");

    private IntervalYearMonth() {
    }

    public static int toMonths(int year, int months) {
        try {
            return Math.addExact(Math.multiplyExact(year, 12), months);
        }
        catch (ArithmeticException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String formatMonths(int months) {
        int mon = months;
        if (mon == Integer.MIN_VALUE) {
            return INT_MIN_VALUE;
        }
        String sign = "";
        if (mon < 0) {
            sign = "-";
            mon = -mon;
        }
        return String.format("%s%d-%d", sign, mon / 12, mon % 12);
    }

    public static int parseMonths(String value) {
        Matcher matcher;
        String val = value;
        if (val.equals(INT_MIN_VALUE)) {
            return Integer.MIN_VALUE;
        }
        int signum = 1;
        if (val.startsWith("-")) {
            signum = -1;
            val = val.substring(1);
        }
        if (!(matcher = FORMAT.matcher(val)).matches()) {
            throw new IllegalArgumentException("Invalid year-month interval: " + val);
        }
        int years = Integer.parseInt(matcher.group(1));
        int months = Integer.parseInt(matcher.group(2));
        return IntervalYearMonth.toMonths(years, months) * signum;
    }
}

