/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.client.block;

import com.google.common.collect.ImmutableMap;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.prestosql.spi.block.ArrayBlockEncoding;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockEncoding;
import io.prestosql.spi.block.BlockEncodingSerde;
import io.prestosql.spi.block.ByteArrayBlockEncoding;
import io.prestosql.spi.block.DictionaryBlockEncoding;
import io.prestosql.spi.block.Int128ArrayBlockEncoding;
import io.prestosql.spi.block.IntArrayBlockEncoding;
import io.prestosql.spi.block.LazyBlockEncoding;
import io.prestosql.spi.block.LongArrayBlockEncoding;
import io.prestosql.spi.block.MapBlockEncoding;
import io.prestosql.spi.block.RowBlockEncoding;
import io.prestosql.spi.block.RunLengthBlockEncoding;
import io.prestosql.spi.block.ShortArrayBlockEncoding;
import io.prestosql.spi.block.SingleMapBlockEncoding;
import io.prestosql.spi.block.SingleRowBlockEncoding;
import io.prestosql.spi.block.VariableWidthBlockEncoding;
import io.prestosql.spi.type.TypeManager;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;

public final class ExternalBlockEncodingSerde
implements BlockEncodingSerde {
    private final Map<String, BlockEncoding> blockEncodings;

    public ExternalBlockEncodingSerde(TypeManager typeManager) {
        this.blockEncodings = ImmutableMap.builder().put((Object)"VARIABLE_WIDTH", (Object)new VariableWidthBlockEncoding()).put((Object)"BYTE_ARRAY", (Object)new ByteArrayBlockEncoding()).put((Object)"SHORT_ARRAY", (Object)new ShortArrayBlockEncoding()).put((Object)"INT_ARRAY", (Object)new IntArrayBlockEncoding()).put((Object)"LONG_ARRAY", (Object)new LongArrayBlockEncoding()).put((Object)"INT128_ARRAY", (Object)new Int128ArrayBlockEncoding()).put((Object)"DICTIONARY", (Object)new DictionaryBlockEncoding()).put((Object)"ARRAY", (Object)new ArrayBlockEncoding()).put((Object)"MAP", (Object)new MapBlockEncoding(typeManager)).put((Object)"MAP_ELEMENT", (Object)new SingleMapBlockEncoding(typeManager)).put((Object)"ROW", (Object)new RowBlockEncoding()).put((Object)"ROW_ELEMENT", (Object)new SingleRowBlockEncoding()).put((Object)"RLE", (Object)new RunLengthBlockEncoding()).put((Object)"LAZY", (Object)new LazyBlockEncoding()).build();
    }

    public Block readBlock(SliceInput input) {
        String encodingName = ExternalBlockEncodingSerde.readLengthPrefixedString(input);
        BlockEncoding blockEncoding = this.blockEncodings.get(encodingName);
        return blockEncoding.readBlock((BlockEncodingSerde)this, input);
    }

    public void writeBlock(SliceOutput output, Block inputBlock) {
        String encodingName;
        BlockEncoding blockEncoding;
        Optional replacementBlock;
        Block block = inputBlock;
        while ((replacementBlock = (blockEncoding = this.blockEncodings.get(encodingName = block.getEncodingName())).replacementBlockForWrite(block)).isPresent()) {
            block = (Block)replacementBlock.get();
        }
        ExternalBlockEncodingSerde.writeLengthPrefixedString(output, encodingName);
        blockEncoding.writeBlock((BlockEncodingSerde)this, output, block);
    }

    private static String readLengthPrefixedString(SliceInput input) {
        int length = input.readInt();
        byte[] bytes = new byte[length];
        input.readBytes(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private static void writeLengthPrefixedString(SliceOutput output, String value) {
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        output.writeInt(bytes.length);
        output.writeBytes(bytes);
    }
}

