/*
 * Decompiled with CFR 0.152.
 */
package io.hetu.core.plugin.carbondata;

import io.hetu.core.plugin.carbondata.CarbondataMetadata;
import io.hetu.core.plugin.carbondata.impl.CarbondataTableReader;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.metastore.MetastoreUtil;
import io.prestosql.plugin.hive.metastore.SemiTransactionalHiveMetastore;
import io.prestosql.plugin.hive.metastore.Table;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.locks.CarbonLockUtil;
import org.apache.carbondata.core.locks.ICarbonLock;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.SegmentFileStore;
import org.apache.carbondata.core.metadata.schema.PartitionInfo;
import org.apache.carbondata.core.metadata.schema.partition.PartitionType;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.statusmanager.LoadMetadataDetails;
import org.apache.carbondata.core.statusmanager.SegmentStatusManager;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;

public class CarbondataAutoCleaner {
    private final Configuration initialConfiguration;
    private final Table table;
    private final Logger log = LogServiceFactory.getLogService((String)CarbondataAutoCleaner.class.getName());
    private final CarbondataTableReader carbondataTableReader;
    private final SemiTransactionalHiveMetastore metastore;
    private final HdfsEnvironment hdfsEnvironment;
    private final String user;

    public CarbondataAutoCleaner(Table table, Configuration initialConfiguration, CarbondataTableReader carbondataTableReader, SemiTransactionalHiveMetastore metastore, HdfsEnvironment hdfsEnvironment, String user) {
        this.table = table;
        this.initialConfiguration = initialConfiguration;
        this.carbondataTableReader = carbondataTableReader;
        this.metastore = metastore;
        this.hdfsEnvironment = hdfsEnvironment;
        this.user = user;
    }

    public Future<?> submitCarbondataAutoCleanupTask(ScheduledExecutorService executorService) {
        Future<?> result = null;
        if (null != executorService) {
            result = executorService.submit(new CarbondataAutoCleanerTask());
            this.log.debug((Object)"Submitting task to Vacuum Cleaner thread pool");
        }
        return result;
    }

    private void cleanupTable() {
        CarbonTable carbonTable = null;
        try {
            Properties schema = MetastoreUtil.getHiveSchema((Table)this.table);
            schema.setProperty("tablePath", this.table.getStorage().getLocation());
            carbonTable = CarbondataMetadata.getCarbonTable(this.table.getDatabaseName(), this.table.getTableName(), schema, this.initialConfiguration, this.carbondataTableReader);
            CarbondataAutoCleaner.cleanupVacuumTable(carbonTable);
        }
        catch (Exception e) {
            this.log.debug((Object)("Exception in  cleanup: " + e.getMessage()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void cleanupVacuumTable(CarbonTable carbonTable) {
        ICarbonLock cleanFileLock = null;
        try {
            PartitionInfo partitionInfo = carbonTable.getPartitionInfo();
            LoadMetadataDetails[] loadMetadataDetails = null;
            ArrayList currPartitions = null;
            if (partitionInfo != null && partitionInfo.getPartitionType() == PartitionType.NATIVE_HIVE) {
                loadMetadataDetails = SegmentStatusManager.readTableStatusFile((String)CarbonTablePath.getTableStatusFilePath((String)carbonTable.getTablePath()));
                HashSet partitionSpecs = new HashSet();
                for (LoadMetadataDetails loadMetadataDetail : loadMetadataDetails) {
                    SegmentFileStore segmentFileStore = new SegmentFileStore(carbonTable.getTablePath(), loadMetadataDetail.getSegmentFile());
                    partitionSpecs.addAll(segmentFileStore.getPartitionSpecs());
                }
                currPartitions = new ArrayList(partitionSpecs);
            }
            AbsoluteTableIdentifier identifier = carbonTable.getAbsoluteTableIdentifier();
            cleanFileLock = CarbonLockUtil.getLockObject((AbsoluteTableIdentifier)identifier, (String)"clean_files.lock");
            SegmentStatusManager.deleteLoadsAndUpdateMetadata((CarbonTable)carbonTable, (boolean)false, currPartitions);
            if (null == cleanFileLock) return;
        }
        catch (IOException e) {
            try {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Failed while cleaning load: %s", e.getMessage()), (Throwable)e);
            }
            catch (Throwable throwable) {
                if (null == cleanFileLock) throw throwable;
                CarbonLockUtil.fileUnlock(cleanFileLock, (String)"clean_files.lock");
                throw throwable;
            }
        }
        CarbonLockUtil.fileUnlock((ICarbonLock)cleanFileLock, (String)"clean_files.lock");
        return;
    }

    private class CarbondataAutoCleanerTask
    implements Runnable {
        private CarbondataAutoCleanerTask() {
        }

        @Override
        public void run() {
            CarbondataAutoCleaner.this.hdfsEnvironment.doAs(CarbondataAutoCleaner.this.user, () -> CarbondataAutoCleaner.this.cleanupTable());
        }
    }
}

