/*
 * Decompiled with CFR 0.152.
 */
package io.hetu.core.plugin.carbondata;

import com.google.common.annotations.VisibleForTesting;
import io.hetu.core.plugin.carbondata.CarbondataHetuCompactorUtil;
import io.hetu.core.plugin.carbondata.CarbondataMetadata;
import io.hetu.core.plugin.carbondata.impl.CarbondataTableReader;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.authentication.HiveIdentity;
import io.prestosql.plugin.hive.metastore.MetastoreUtil;
import io.prestosql.plugin.hive.metastore.SemiTransactionalHiveMetastore;
import io.prestosql.plugin.hive.metastore.Table;
import io.prestosql.plugin.hive.util.ConfigurationUtils;
import io.prestosql.spi.connector.ConnectorVacuumTableInfo;
import io.prestosql.spi.security.ConnectorIdentity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.mutate.CarbonUpdateUtil;
import org.apache.carbondata.core.statusmanager.LoadMetadataDetails;
import org.apache.carbondata.hive.util.HiveCarbonUtil;
import org.apache.carbondata.processing.loading.model.CarbonLoadModel;
import org.apache.carbondata.processing.merger.CompactionType;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.log4j.Logger;

public class CarbondataAutoVacuumThread {
    private static final Logger LOG = LogServiceFactory.getLogService((String)CarbondataAutoVacuumThread.class.getName());
    private static final ConcurrentSkipListSet<Future<?>> queuedTasks = new ConcurrentSkipListSet();
    private final CarbondataTableReader carbondataTableReader;
    private final long majorVacuumSegSize;
    private final long minorVacuumSegCount;
    private final ScheduledExecutorService executorService;
    private final HdfsEnvironment hdfsEnvironment;
    private final List<ConnectorVacuumTableInfo> connectorVacuumTableInfoList;
    private final Map<String, Long> needToVacuumTablesMap;
    private final HdfsEnvironment.HdfsContext hdfsContext;
    private static CarbondataAutoVacuumThread instance;
    private static boolean enableTracingCleanupTask;
    private static CarbondataAutoVacuumThreadInfo carbondataAutoVacuumThreadInfo;

    public static synchronized CarbondataAutoVacuumThread getInstanceAutoVacuum() {
        if (instance == null) {
            instance = new CarbondataAutoVacuumThread(CarbondataAutoVacuumThread.carbondataAutoVacuumThreadInfo.carbondataTableReader, CarbondataAutoVacuumThread.carbondataAutoVacuumThreadInfo.hdfsEnvironment, CarbondataAutoVacuumThread.carbondataAutoVacuumThreadInfo.majorVacuumSegSize, CarbondataAutoVacuumThread.carbondataAutoVacuumThreadInfo.minorVacuumSegCount, CarbondataAutoVacuumThread.carbondataAutoVacuumThreadInfo.executorService);
        }
        return instance;
    }

    public static synchronized void setAutoVacuumInfo(CarbondataTableReader carbondataTableReader, HdfsEnvironment hdfsEnvironment, long majorVacuumSegSize, long minorVacuumSegCount, ScheduledExecutorService vacuumExecutorService) {
        if (carbondataAutoVacuumThreadInfo == null) {
            carbondataAutoVacuumThreadInfo = new CarbondataAutoVacuumThreadInfo(carbondataTableReader, hdfsEnvironment, majorVacuumSegSize, minorVacuumSegCount, vacuumExecutorService);
        }
    }

    private CarbondataAutoVacuumThread(CarbondataTableReader carbondataTableReader, HdfsEnvironment hdfsEnvironment, long majorVacuumSegSize, long minorVacuumSegCount, ScheduledExecutorService vacuumExecutorService) {
        this.carbondataTableReader = carbondataTableReader;
        this.hdfsEnvironment = hdfsEnvironment;
        this.majorVacuumSegSize = majorVacuumSegSize;
        this.minorVacuumSegCount = minorVacuumSegCount;
        this.connectorVacuumTableInfoList = new ArrayList<ConnectorVacuumTableInfo>();
        this.needToVacuumTablesMap = new ConcurrentHashMap<String, Long>();
        this.executorService = vacuumExecutorService;
        this.hdfsContext = new HdfsEnvironment.HdfsContext(new ConnectorIdentity("openLooKeng", Optional.empty(), Optional.empty()));
    }

    private void scanSchemasAndTables(SemiTransactionalHiveMetastore metastore) {
        try {
            for (String schemaName : metastore.getAllDatabases()) {
                if (enableTracingCleanupTask) {
                    queuedTasks.add(this.executorService.submit(new AutoVacuumScanTask(metastore, schemaName)));
                    continue;
                }
                this.executorService.submit(new AutoVacuumScanTask(metastore, schemaName));
            }
        }
        catch (RuntimeException e) {
            LOG.error((Object)"Error when scanning schema", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void identifyVacuumTables(Table target, String schemaName, String tableName, String dbNameTableName) {
        block7: {
            CarbonTable carbonTable;
            JobConf initialConfiguration = ConfigurationUtils.toJobConf((Configuration)this.hdfsEnvironment.getConfiguration(this.hdfsContext, new Path(target.getStorage().getLocation())));
            Properties schema = MetastoreUtil.getHiveSchema((Table)target);
            schema.setProperty("tablePath", target.getStorage().getLocation());
            try {
                carbonTable = CarbondataMetadata.getCarbonTable(schemaName, tableName, schema, (Configuration)initialConfiguration, this.carbondataTableReader);
            }
            catch (RuntimeException e) {
                return;
            }
            try {
                CarbonLoadModel carbonLoadModel;
                List<List<LoadMetadataDetails>> allGroupedSegList;
                if (null == carbonTable || (allGroupedSegList = CarbondataHetuCompactorUtil.identifyAndGroupSegmentsToBeMerged(carbonLoadModel = HiveCarbonUtil.getCarbonLoadModel((Properties)schema, (Configuration)initialConfiguration), (Configuration)initialConfiguration, CompactionType.MINOR, this.majorVacuumSegSize, this.minorVacuumSegCount)).isEmpty()) break block7;
                ConnectorVacuumTableInfo connectorVacuumTableInfo = new ConnectorVacuumTableInfo(dbNameTableName, false);
                List<ConnectorVacuumTableInfo> list = this.connectorVacuumTableInfoList;
                synchronized (list) {
                    this.connectorVacuumTableInfoList.add(connectorVacuumTableInfo);
                }
            }
            catch (RuntimeException e) {
                LOG.error((Object)("error when identify Vacuum Table " + schemaName + "." + tableName), (Throwable)e);
            }
        }
    }

    private void scanSchemas(SemiTransactionalHiveMetastore metastore, String schemaName) {
        try {
            for (String tableName : metastore.getAllTables(schemaName).orElse(Collections.emptyList())) {
                String dbNameTableName;
                Optional target = metastore.getTable(new HiveIdentity(this.hdfsContext.getIdentity()), schemaName, tableName);
                if (!target.isPresent() || this.needToVacuumTablesMap.containsKey(dbNameTableName = ((Table)target.get()).getDatabaseName() + "." + ((Table)target.get()).getTableName()) || !((Table)target.get()).getStorage().getStorageFormat().getInputFormat().contains("carbon")) continue;
                this.identifyVacuumTables((Table)target.get(), schemaName, tableName, dbNameTableName);
            }
        }
        catch (RuntimeException e) {
            LOG.error((Object)"error when scanning Tables", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ConnectorVacuumTableInfo> getAutoVacuumTableList(SemiTransactionalHiveMetastore metastore) {
        CarbondataAutoVacuumThread instanceAutoVacuum = CarbondataAutoVacuumThread.getInstanceAutoVacuum();
        if (null == instanceAutoVacuum) {
            return null;
        }
        ArrayList<ConnectorVacuumTableInfo> connectorVacuumTableInfos = new ArrayList<ConnectorVacuumTableInfo>();
        List<ConnectorVacuumTableInfo> list = instanceAutoVacuum.connectorVacuumTableInfoList;
        synchronized (list) {
            connectorVacuumTableInfos.addAll(instanceAutoVacuum.connectorVacuumTableInfoList);
            instanceAutoVacuum.connectorVacuumTableInfoList.clear();
        }
        instanceAutoVacuum.submitTaskScanning(instanceAutoVacuum, metastore);
        return connectorVacuumTableInfos;
    }

    private void submitTaskScanning(CarbondataAutoVacuumThread instanceAutoVacuum, SemiTransactionalHiveMetastore metastore) {
        if (enableTracingCleanupTask) {
            queuedTasks.add(instanceAutoVacuum.executorService.submit(new AutoVacuumScanTask(metastore)));
        } else {
            instanceAutoVacuum.executorService.submit(new AutoVacuumScanTask(metastore));
        }
    }

    public static void removeTableFromVacuumTablesMap(String schemaTableName) {
        CarbondataAutoVacuumThread autoVacuumObj = CarbondataAutoVacuumThread.getInstanceAutoVacuum();
        if (null != autoVacuumObj && null != autoVacuumObj.needToVacuumTablesMap.get(schemaTableName)) {
            autoVacuumObj.needToVacuumTablesMap.remove(schemaTableName);
        }
    }

    public static void addTableToVacuumTablesMap(String schemaTableName) {
        CarbondataAutoVacuumThread autoVacuumObj = CarbondataAutoVacuumThread.getInstanceAutoVacuum();
        if (null != autoVacuumObj && null != autoVacuumObj.needToVacuumTablesMap.get(schemaTableName)) {
            autoVacuumObj.needToVacuumTablesMap.put(schemaTableName, CarbonUpdateUtil.readCurrentTime());
        }
    }

    @VisibleForTesting
    public static void enableTracingVacuumTask(boolean isEnabled) {
        enableTracingCleanupTask = isEnabled;
    }

    @VisibleForTesting
    public static void waitForSubmittedVacuumTasksFinish() {
        queuedTasks.stream().forEach(f -> {
            try {
                f.get();
            }
            catch (InterruptedException e) {
                LOG.debug((Object)("Interrupted to get the result of autoCleanup : " + e));
            }
            catch (ExecutionException e) {
                LOG.debug((Object)("Exception to get the result of autoCleanup : " + e));
            }
        });
        queuedTasks.clear();
        LOG.info((Object)"All autocleanup tasks finished");
    }

    static class CarbondataAutoVacuumThreadInfo {
        public final CarbondataTableReader carbondataTableReader;
        public final HdfsEnvironment hdfsEnvironment;
        public final long majorVacuumSegSize;
        public final long minorVacuumSegCount;
        public final ScheduledExecutorService executorService;
        public final List<ConnectorVacuumTableInfo> connectorVacuumTableInfoList;
        public final Map<String, Long> needToVacuumTablesMap;

        private CarbondataAutoVacuumThreadInfo(CarbondataTableReader carbondataTableReader, HdfsEnvironment hdfsEnvironment, long majorVacuumSegSize, long minorVacuumSegCount, ScheduledExecutorService vacuumExecutorService) {
            this.carbondataTableReader = carbondataTableReader;
            this.hdfsEnvironment = hdfsEnvironment;
            this.majorVacuumSegSize = majorVacuumSegSize;
            this.minorVacuumSegCount = minorVacuumSegCount;
            this.connectorVacuumTableInfoList = new ArrayList<ConnectorVacuumTableInfo>();
            this.needToVacuumTablesMap = new ConcurrentHashMap<String, Long>();
            this.executorService = vacuumExecutorService;
        }
    }

    class AutoVacuumScanTask
    implements Runnable {
        SemiTransactionalHiveMetastore metastore;
        String schemaName;

        AutoVacuumScanTask(SemiTransactionalHiveMetastore metastore) {
            this(metastore, null);
        }

        AutoVacuumScanTask(SemiTransactionalHiveMetastore metastore, String schemaName) {
            this.metastore = metastore;
            this.schemaName = schemaName;
        }

        @Override
        public void run() {
            CarbondataAutoVacuumThread.this.hdfsEnvironment.doAs("openLooKeng", () -> {
                if (null == this.schemaName) {
                    CarbondataAutoVacuumThread.this.scanSchemasAndTables(this.metastore);
                } else {
                    CarbondataAutoVacuumThread.this.scanSchemas(this.metastore, this.schemaName);
                }
            });
        }
    }
}

