/*
 * Decompiled with CFR 0.152.
 */
package io.hetu.core.plugin.carbondata;

import java.math.BigDecimal;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.scan.result.vector.CarbonColumnVector;
import org.apache.carbondata.core.scan.result.vector.CarbonDictionary;
import org.apache.carbondata.core.scan.result.vector.impl.CarbonColumnVectorImpl;
import org.apache.carbondata.core.scan.scanner.LazyPageLoader;

public class CarbondataColumnVectorWrapper
implements CarbonColumnVector {
    private CarbonColumnVectorImpl columnVector;
    private CarbondataColumnVectorWrapper dictionaryVectorWrapper;
    private boolean[] filteredRows;
    private int counter;
    private boolean filteredRowsExist;
    private DataType blockDataType;

    public CarbondataColumnVectorWrapper(CarbonColumnVectorImpl columnVector, boolean[] filteredRows) {
        this.columnVector = columnVector;
        this.filteredRows = filteredRows;
        if (columnVector.getDictionaryVector() != null) {
            this.dictionaryVectorWrapper = new CarbondataColumnVectorWrapper((CarbonColumnVectorImpl)columnVector.getDictionaryVector(), filteredRows);
        }
    }

    public void putBoolean(int rowId, boolean value) {
        if (!this.filteredRows[rowId]) {
            this.columnVector.putBoolean(this.counter++, value);
        }
    }

    public void putFloat(int rowId, float value) {
        if (!this.filteredRows[rowId]) {
            this.columnVector.putFloat(this.counter++, value);
        }
    }

    public void putShort(int rowId, short value) {
        if (!this.filteredRows[rowId]) {
            this.columnVector.putShort(this.counter++, value);
        }
    }

    public void putShorts(int rowId, int count, short value) {
        int inputRowId = rowId;
        if (this.filteredRowsExist) {
            for (int i = 0; i < count; ++i) {
                if (!this.filteredRows[inputRowId]) {
                    this.columnVector.putShort(this.counter++, value);
                }
                ++inputRowId;
            }
        } else {
            this.columnVector.putShorts(inputRowId, count, value);
        }
    }

    public void putInt(int rowId, int value) {
        if (!this.filteredRows[rowId]) {
            this.columnVector.putInt(this.counter++, value);
        }
    }

    public void putInts(int rowId, int count, int value) {
        int inputRowId = rowId;
        if (this.filteredRowsExist) {
            for (int i = 0; i < count; ++i) {
                if (!this.filteredRows[inputRowId]) {
                    this.columnVector.putInt(this.counter++, value);
                }
                ++inputRowId;
            }
        } else {
            this.columnVector.putInts(inputRowId, count, value);
        }
    }

    public void putLong(int rowId, long value) {
        if (!this.filteredRows[rowId]) {
            this.columnVector.putLong(this.counter++, value);
        }
    }

    public void putLongs(int rowId, int count, long value) {
        int inputRowId = rowId;
        if (this.filteredRowsExist) {
            for (int i = 0; i < count; ++i) {
                if (!this.filteredRows[inputRowId]) {
                    this.columnVector.putLong(this.counter++, value);
                }
                ++inputRowId;
            }
        } else {
            this.columnVector.putLongs(inputRowId, count, value);
        }
    }

    public void putDecimal(int rowId, BigDecimal value, int precision) {
        if (!this.filteredRows[rowId]) {
            this.columnVector.putDecimal(this.counter++, value, precision);
        }
    }

    public void putDecimals(int rowId, int count, BigDecimal value, int precision) {
        int inputRowId = rowId;
        for (int i = 0; i < count; ++i) {
            if (!this.filteredRows[inputRowId]) {
                this.columnVector.putDecimal(this.counter++, value, precision);
            }
            ++inputRowId;
        }
    }

    public void putDouble(int rowId, double value) {
        if (!this.filteredRows[rowId]) {
            this.columnVector.putDouble(this.counter++, value);
        }
    }

    public void putDoubles(int rowId, int count, double value) {
        int inputRowId = rowId;
        if (this.filteredRowsExist) {
            for (int i = 0; i < count; ++i) {
                if (!this.filteredRows[inputRowId]) {
                    this.columnVector.putDouble(this.counter++, value);
                }
                ++inputRowId;
            }
        } else {
            this.columnVector.putDoubles(inputRowId, count, value);
        }
    }

    public void putByte(int rowId, byte value) {
        if (!this.filteredRows[rowId]) {
            this.columnVector.putByte(this.counter++, value);
        }
    }

    public void putByteArray(int rowId, byte[] value) {
        if (!this.filteredRows[rowId]) {
            this.columnVector.putByteArray(this.counter++, value);
        }
    }

    public void putByteArray(int rowId, int count, byte[] value) {
        int inputRowId = rowId;
        for (int i = 0; i < count; ++i) {
            if (!this.filteredRows[inputRowId]) {
                this.columnVector.putByteArray(this.counter++, value);
            }
            ++inputRowId;
        }
    }

    public void putByteArray(int rowId, int offset, int length, byte[] value) {
        if (!this.filteredRows[rowId]) {
            this.columnVector.putByteArray(this.counter++, offset, length, value);
        }
    }

    public void putNull(int rowId) {
        if (!this.filteredRows[rowId]) {
            this.columnVector.putNull(this.counter++);
        }
    }

    public void putNulls(int rowId, int count) {
        int inputRowId = rowId;
        if (this.filteredRowsExist) {
            for (int i = 0; i < count; ++i) {
                if (!this.filteredRows[inputRowId]) {
                    this.columnVector.putNull(this.counter++);
                }
                ++inputRowId;
            }
        } else {
            this.columnVector.putNulls(inputRowId, count);
        }
    }

    public void putNotNull(int rowId) {
    }

    public void putNotNull(int rowId, int count) {
    }

    public boolean isNull(int rowId) {
        return this.columnVector.isNullAt(rowId);
    }

    public void putObject(int rowId, Object obj) {
    }

    public Object getData(int rowId) {
        return null;
    }

    public void reset() {
        this.counter = 0;
        this.filteredRowsExist = false;
    }

    public DataType getType() {
        return this.columnVector.getType();
    }

    public DataType getBlockDataType() {
        return this.blockDataType;
    }

    public void setBlockDataType(DataType blockDataType) {
        this.blockDataType = blockDataType;
    }

    public void setFilteredRowsExist(boolean filteredRowsExist) {
        this.filteredRowsExist = filteredRowsExist;
    }

    public void setDictionary(CarbonDictionary dictionary) {
        this.columnVector.setDictionary(dictionary);
    }

    public boolean hasDictionary() {
        return this.columnVector.hasDictionary();
    }

    public CarbonColumnVector getDictionaryVector() {
        return this.dictionaryVectorWrapper;
    }

    public void putFloats(int rowId, int count, float[] src, int srcIndex) {
        int inputRowId = rowId;
        for (int i = srcIndex; i < count; ++i) {
            if (!this.filteredRows[inputRowId]) {
                this.columnVector.putFloat(this.counter++, src[i]);
            }
            ++inputRowId;
        }
    }

    public void putShorts(int rowId, int count, short[] src, int srcIndex) {
        int inputRowId = rowId;
        for (int i = srcIndex; i < count; ++i) {
            if (!this.filteredRows[inputRowId]) {
                this.columnVector.putShort(this.counter++, src[i]);
            }
            ++inputRowId;
        }
    }

    public void putInts(int rowId, int count, int[] src, int srcIndex) {
        int inputRowId = rowId;
        for (int i = srcIndex; i < count; ++i) {
            if (!this.filteredRows[inputRowId]) {
                this.columnVector.putInt(this.counter++, src[i]);
            }
            ++inputRowId;
        }
    }

    public void putLongs(int rowId, int count, long[] src, int srcIndex) {
        int inputRowId = rowId;
        for (int i = srcIndex; i < count; ++i) {
            if (!this.filteredRows[inputRowId]) {
                this.columnVector.putLong(this.counter++, src[i]);
            }
            ++inputRowId;
        }
    }

    public void putDoubles(int rowId, int count, double[] src, int srcIndex) {
        int inputRowId = rowId;
        for (int i = srcIndex; i < count; ++i) {
            if (!this.filteredRows[inputRowId]) {
                this.columnVector.putDouble(this.counter++, src[i]);
            }
            ++inputRowId;
        }
    }

    public void putBytes(int rowId, int count, byte[] src, int srcIndex) {
        int inputRowId = rowId;
        for (int i = srcIndex; i < count; ++i) {
            if (!this.filteredRows[inputRowId]) {
                this.columnVector.putByte(this.counter++, src[i]);
            }
            ++inputRowId;
        }
    }

    public void setLazyPage(LazyPageLoader lazyPage) {
        lazyPage.loadPage();
    }

    public void putArray(int rowId, int offset, int length) {
        if (!this.filteredRows[rowId]) {
            this.columnVector.putArray(this.counter++, offset, length);
        }
    }

    public void putAllByteArray(byte[] data, int offset, int length) {
        this.columnVector.putAllByteArray(data, offset, length);
    }
}

