/*
 * Decompiled with CFR 0.152.
 */
package io.hetu.core.plugin.carbondata;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.hetu.core.plugin.carbondata.CarbondataStorageFormat;
import io.prestosql.plugin.hive.HiveConfig;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class CarbondataConfig
extends HiveConfig {
    private String storeLocation = "";
    private long minorVacuumSegCount = Long.parseLong("4,3".split(",")[0]);
    private long majorVacuumSegSize = 1L;
    private int vacuumServiceThreads = 2;
    private boolean autoVacuumEnable;
    private CarbondataStorageFormat carbondataStorageFormat = CarbondataStorageFormat.CARBON;

    @NotNull
    public String getStoreLocation() {
        return this.storeLocation;
    }

    @Config(value="carbondata.store-location")
    public CarbondataConfig setStoreLocation(String storeLocation) {
        this.storeLocation = storeLocation;
        return this;
    }

    @Config(value="carbondata.minor-vacuum-seg-count")
    public CarbondataConfig setMinorVacuumSegCount(String minorVacuumSegCount) {
        this.minorVacuumSegCount = Long.parseLong(minorVacuumSegCount);
        return this;
    }

    @Config(value="carbondata.major-vacuum-seg-size")
    public CarbondataConfig setMajorVacuumSegSize(String majorVacuumSegSize) {
        this.majorVacuumSegSize = Long.parseLong(majorVacuumSegSize);
        return this;
    }

    @NotNull
    public long getMinorVacuumSegCount() {
        return this.minorVacuumSegCount;
    }

    @NotNull
    public long getMajorVacuumSegSize() {
        return this.majorVacuumSegSize;
    }

    @Config(value="carbondata.vacuum-service-threads")
    @ConfigDescription(value="Number of threads to run in the auto vacuum & vacuum cleanup service")
    public CarbondataConfig setCarbondataVacuumServiceThreads(int vacuumServiceThreads) {
        this.vacuumServiceThreads = vacuumServiceThreads;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getCarbondataVacuumServiceThreads() {
        return this.vacuumServiceThreads;
    }

    @Config(value="carbondata.auto-vacuum-enabled")
    @ConfigDescription(value="carbondata auto vacuum default value is true.")
    public CarbondataConfig setAutoVacuumEnable(boolean autoVacuumEnable) {
        this.autoVacuumEnable = autoVacuumEnable;
        return this;
    }

    public boolean getAutoVacuumEnable() {
        return this.autoVacuumEnable;
    }
}

