/*
 * Decompiled with CFR 0.152.
 */
package io.hetu.core.plugin.carbondata;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.bootstrap.LifeCycleManager;
import io.airlift.configuration.ConfigBinder;
import io.airlift.event.client.EventModule;
import io.airlift.json.JsonModule;
import io.airlift.units.DataSize;
import io.hetu.core.plugin.carbondata.CarbondataHandleResolver;
import io.hetu.core.plugin.carbondata.CarbondataModule;
import io.hetu.core.plugin.carbondata.CarbondataTableProperties;
import io.hetu.core.plugin.carbondata.impl.CarbondataTableConfig;
import io.prestosql.plugin.base.jmx.MBeanServerModule;
import io.prestosql.plugin.hive.ConnectorObjectNameGeneratorModule;
import io.prestosql.plugin.hive.HiveAnalyzeProperties;
import io.prestosql.plugin.hive.HiveCatalogName;
import io.prestosql.plugin.hive.HiveConnector;
import io.prestosql.plugin.hive.HiveConnectorFactory;
import io.prestosql.plugin.hive.HiveMetadataFactory;
import io.prestosql.plugin.hive.HiveProcedureModule;
import io.prestosql.plugin.hive.HiveSchemaProperties;
import io.prestosql.plugin.hive.HiveSessionProperties;
import io.prestosql.plugin.hive.HiveStorageFormat;
import io.prestosql.plugin.hive.HiveTransactionManager;
import io.prestosql.plugin.hive.NodeVersion;
import io.prestosql.plugin.hive.authentication.HiveAuthenticationModule;
import io.prestosql.plugin.hive.gcs.HiveGcsModule;
import io.prestosql.plugin.hive.metastore.HiveMetastoreModule;
import io.prestosql.plugin.hive.s3.HiveS3Module;
import io.prestosql.plugin.hive.security.HiveSecurityModule;
import io.prestosql.plugin.hive.security.SystemTableAwareAccessControl;
import io.prestosql.spi.NodeManager;
import io.prestosql.spi.PageIndexerFactory;
import io.prestosql.spi.PageSorter;
import io.prestosql.spi.VersionEmbedder;
import io.prestosql.spi.classloader.ThreadContextClassLoader;
import io.prestosql.spi.connector.Connector;
import io.prestosql.spi.connector.ConnectorAccessControl;
import io.prestosql.spi.connector.ConnectorContext;
import io.prestosql.spi.connector.ConnectorHandleResolver;
import io.prestosql.spi.connector.ConnectorNodePartitioningProvider;
import io.prestosql.spi.connector.ConnectorPageSinkProvider;
import io.prestosql.spi.connector.ConnectorPageSourceProvider;
import io.prestosql.spi.connector.ConnectorSplitManager;
import io.prestosql.spi.connector.classloader.ClassLoaderSafeConnectorPageSinkProvider;
import io.prestosql.spi.connector.classloader.ClassLoaderSafeConnectorPageSourceProvider;
import io.prestosql.spi.connector.classloader.ClassLoaderSafeConnectorSplitManager;
import io.prestosql.spi.connector.classloader.ClassLoaderSafeNodePartitioningProvider;
import io.prestosql.spi.procedure.Procedure;
import io.prestosql.spi.type.TypeManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.carbondata.hive.CarbonHiveSerDe;
import org.apache.carbondata.hive.MapredCarbonInputFormat;
import org.apache.carbondata.hive.MapredCarbonOutputFormat;
import org.weakref.jmx.guice.MBeanModule;
import sun.reflect.ConstructorAccessor;

public class CarbondataConnectorFactory
extends HiveConnectorFactory {
    private final ClassLoader classLoader;

    public CarbondataConnectorFactory(String connectorName, ClassLoader classLoader) {
        super(connectorName, classLoader, Optional.empty());
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
    }

    public ConnectorHandleResolver getHandleResolver() {
        return new CarbondataHandleResolver();
    }

    private static void setCarbonEnum() throws Exception {
        for (HiveStorageFormat format : HiveStorageFormat.values()) {
            if (!format.name().equals("CARBON")) continue;
            return;
        }
        Constructor<?>[] declaredConstructors = HiveStorageFormat.class.getDeclaredConstructors();
        declaredConstructors[0].setAccessible(true);
        Field constructorAccessorField = Constructor.class.getDeclaredField("constructorAccessor");
        constructorAccessorField.setAccessible(true);
        ConstructorAccessor ca = (ConstructorAccessor)constructorAccessorField.get(declaredConstructors[0]);
        if (ca == null) {
            Method acquireConstructorAccessorMethod = Constructor.class.getDeclaredMethod("acquireConstructorAccessor", new Class[0]);
            acquireConstructorAccessorMethod.setAccessible(true);
            ca = (ConstructorAccessor)acquireConstructorAccessorMethod.invoke(declaredConstructors[0], new Object[0]);
        }
        Object instance = ca.newInstance(new Object[]{"CARBON", HiveStorageFormat.values().length, CarbonHiveSerDe.class.getName(), MapredCarbonInputFormat.class.getName(), MapredCarbonOutputFormat.class.getName(), new DataSize(256.0, DataSize.Unit.MEGABYTE)});
        Field values = HiveStorageFormat.class.getDeclaredField("$VALUES");
        values.setAccessible(true);
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(values, values.getModifiers() & 0xFFFFFFEF);
        HiveStorageFormat[] hiveStorageFormats = new HiveStorageFormat[HiveStorageFormat.values().length + 1];
        HiveStorageFormat[] src = (HiveStorageFormat[])values.get(null);
        System.arraycopy(src, 0, hiveStorageFormats, 0, src.length);
        hiveStorageFormats[src.length] = (HiveStorageFormat)instance;
        values.set(null, hiveStorageFormats);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Connector create(String catalogName, Map<String, String> config, ConnectorContext context) {
        Objects.requireNonNull(config, "config is null");
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Bootstrap app = new Bootstrap(new Module[]{new EventModule(), new MBeanModule(), new ConnectorObjectNameGeneratorModule(catalogName), new JsonModule(), new CarbondataModule(catalogName), new HiveS3Module(), new HiveGcsModule(), new HiveMetastoreModule(Optional.ofNullable(null)), new HiveSecurityModule(), new HiveAuthenticationModule(), new HiveProcedureModule(), new MBeanServerModule(), binder -> {
                binder.bind(NodeVersion.class).toInstance((Object)new NodeVersion(context.getNodeManager().getCurrentNode().getVersion()));
                binder.bind(NodeManager.class).toInstance((Object)context.getNodeManager());
                binder.bind(VersionEmbedder.class).toInstance((Object)context.getVersionEmbedder());
                binder.bind(TypeManager.class).toInstance((Object)context.getTypeManager());
                binder.bind(PageIndexerFactory.class).toInstance((Object)context.getPageIndexerFactory());
                binder.bind(PageSorter.class).toInstance((Object)context.getPageSorter());
                binder.bind(HiveCatalogName.class).toInstance((Object)new HiveCatalogName(catalogName));
                ConfigBinder.configBinder((Binder)binder).bindConfig(CarbondataTableConfig.class);
            }});
            Injector injector = app.strictConfig().doNotInitializeLogging().setRequiredConfigurationProperties(config).initialize();
            LifeCycleManager lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
            HiveMetadataFactory metadataFactory = (HiveMetadataFactory)injector.getInstance(HiveMetadataFactory.class);
            HiveTransactionManager transactionManager = (HiveTransactionManager)injector.getInstance(HiveTransactionManager.class);
            ConnectorSplitManager splitManager = (ConnectorSplitManager)injector.getInstance(ConnectorSplitManager.class);
            ConnectorPageSourceProvider connectorPageSource = (ConnectorPageSourceProvider)injector.getInstance(ConnectorPageSourceProvider.class);
            ConnectorPageSinkProvider pageSinkProvider = (ConnectorPageSinkProvider)injector.getInstance(ConnectorPageSinkProvider.class);
            ConnectorNodePartitioningProvider connectorDistributionProvider = (ConnectorNodePartitioningProvider)injector.getInstance(ConnectorNodePartitioningProvider.class);
            HiveSessionProperties hiveSessionProperties = (HiveSessionProperties)injector.getInstance(HiveSessionProperties.class);
            CarbondataTableProperties hiveTableProperties = (CarbondataTableProperties)((Object)injector.getInstance(CarbondataTableProperties.class));
            HiveAnalyzeProperties hiveAnalyzeProperties = (HiveAnalyzeProperties)injector.getInstance(HiveAnalyzeProperties.class);
            SystemTableAwareAccessControl accessControl = new SystemTableAwareAccessControl((ConnectorAccessControl)injector.getInstance(ConnectorAccessControl.class));
            Set procedures = (Set)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<Procedure>>(){}));
            HiveConnector hiveConnector = new HiveConnector(lifeCycleManager, (Supplier)metadataFactory, transactionManager, (ConnectorSplitManager)new ClassLoaderSafeConnectorSplitManager(splitManager, this.classLoader), (ConnectorPageSourceProvider)new ClassLoaderSafeConnectorPageSourceProvider(connectorPageSource, this.classLoader), (ConnectorPageSinkProvider)new ClassLoaderSafeConnectorPageSinkProvider(pageSinkProvider, this.classLoader), (ConnectorNodePartitioningProvider)new ClassLoaderSafeNodePartitioningProvider(connectorDistributionProvider, this.classLoader), (Set)ImmutableSet.of(), procedures, hiveSessionProperties.getSessionProperties(), HiveSchemaProperties.SCHEMA_PROPERTIES, hiveTableProperties.getTableProperties(), hiveAnalyzeProperties.getAnalyzeProperties(), (ConnectorAccessControl)accessControl, this.classLoader);
            return hiveConnector;
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            CarbondataConnectorFactory.setCarbonEnum();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

