/*
 * Decompiled with CFR 0.152.
 */
package io.hetu.core.plugin.carbondata;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import io.airlift.log.Logger;
import io.prestosql.plugin.hive.HiveACIDWriteType;
import io.prestosql.plugin.hive.HiveErrorCode;
import io.prestosql.plugin.hive.HiveFileWriter;
import io.prestosql.plugin.hive.HiveType;
import io.prestosql.plugin.hive.util.FieldSetterFactory;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.Page;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.index.Segment;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.mutate.CarbonUpdateUtil;
import org.apache.carbondata.core.mutate.DeleteDeltaBlockDetails;
import org.apache.carbondata.core.mutate.SegmentUpdateDetails;
import org.apache.carbondata.core.mutate.TupleIdEnum;
import org.apache.carbondata.core.mutate.data.RowCountDetailsVO;
import org.apache.carbondata.core.statusmanager.LoadMetadataDetails;
import org.apache.carbondata.core.statusmanager.SegmentStatus;
import org.apache.carbondata.core.statusmanager.SegmentStatusManager;
import org.apache.carbondata.core.statusmanager.SegmentUpdateStatusManager;
import org.apache.carbondata.core.util.ObjectSerializationUtil;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.carbondata.core.writer.CarbonDeleteDeltaWriterImpl;
import org.apache.carbondata.hadoop.api.CarbonTableOutputFormat;
import org.apache.carbondata.hive.CarbonHiveSerDe;
import org.apache.carbondata.hive.MapredCarbonOutputFormat;
import org.apache.carbondata.hive.util.HiveCarbonUtil;
import org.apache.carbondata.processing.exception.MultipleMatchingException;
import org.apache.carbondata.processing.loading.model.CarbonLoadModel;
import org.apache.carbondata.processing.util.TableOptionConstant;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.AcidOutputFormat;
import org.apache.hadoop.hive.ql.io.parquet.serde.ArrayWritableObjectInspector;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.SettableStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.util.Progressable;
import org.joda.time.DateTimeZone;

public class CarbondataFileWriter
implements HiveFileWriter {
    private static final org.apache.log4j.Logger LOG = LogServiceFactory.getLogService((String)CarbondataFileWriter.class.getName());
    private static final Logger AIR_LOG = Logger.get(CarbondataFileWriter.class);
    private static final String LOAD_MODEL = "mapreduce.carbontable.load.model";
    private final JobConf configuration;
    private final CarbonHiveSerDe serDe;
    private final int fieldCount;
    private final Object row;
    private final SettableStructObjectInspector tableInspector;
    private final List<StructField> structFields;
    private final FieldSetterFactory.FieldSetter[] setters;
    private final Properties properties;
    private final Optional<AcidOutputFormat.Options> acidOptions;
    private final HiveACIDWriteType acidWriteType;
    private final String txnTimeStamp;
    private final String tablePath;
    private final int taskId;
    private Path outPutPath;
    private FileSinkOperator.RecordWriter recordWriter;
    private ConcurrentHashMap<String, DeleteDeltaBlockDetails> deleteDeltaDetailsMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, SegmentUpdateDetails> segmentUpdateDetailMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, FileSinkOperator.RecordWriter> segmentRecordWriterMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Boolean> deleteSegmentMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, String> deltaPathSegmentMap = new ConcurrentHashMap();
    private Map<String, RowCountDetailsVO> segmentNoRowCountMapping;
    private CarbonTable carbonTable;
    private SegmentUpdateStatusManager segmentUpdateStatusManager;
    private boolean isInitDone;
    private boolean isCommitDone;

    public CarbondataFileWriter(Path paramOutPutPath, List<String> inputColumnNames, Properties properties, JobConf configuration, TypeManager typeManager, Optional<AcidOutputFormat.Options> acidOptions, Optional<HiveACIDWriteType> acidWriteType, OptionalInt taskId) throws SerDeException {
        Path localOutPutPath = paramOutPutPath;
        this.outPutPath = Objects.requireNonNull(localOutPutPath, "path is null");
        if (null != properties.getProperty("location")) {
            this.outPutPath = new Path(properties.getProperty("location"));
            localOutPutPath = new Path(properties.getProperty("location"));
        }
        this.configuration = Objects.requireNonNull(configuration, "conf is null");
        this.properties = Objects.requireNonNull(properties, "Properties is null");
        this.acidOptions = acidOptions;
        this.acidWriteType = acidWriteType.isPresent() ? acidWriteType.get() : HiveACIDWriteType.INSERT;
        this.txnTimeStamp = configuration.get("hetu.carbondata.states.transactionbegintimestamp", Long.toString(System.currentTimeMillis()));
        this.taskId = taskId.orElseGet(() -> 0);
        AIR_LOG.debug("[carbonWriterTask] taskId: " + this.taskId + ", outputPath: " + this.outPutPath);
        try {
            if (HiveACIDWriteType.isUpdateOrDelete((HiveACIDWriteType)this.acidWriteType)) {
                String encodedCarbonTable = configuration.get("hetu.carbondata.states.carbonTable");
                this.carbonTable = (CarbonTable)ObjectSerializationUtil.convertStringToObject((String)encodedCarbonTable);
                LoadMetadataDetails[] loadMetadataDetails = SegmentStatusManager.readTableStatusFile((String)CarbonTablePath.getTableStatusFilePath((String)this.carbonTable.getTablePath()));
                this.segmentUpdateStatusManager = new SegmentUpdateStatusManager(this.carbonTable, loadMetadataDetails);
            }
            if (HiveACIDWriteType.DELETE == this.acidWriteType) {
                this.segmentNoRowCountMapping = (Map)ObjectSerializationUtil.convertStringToObject((String)configuration.get("hetu.carbondata.states.segmentNoRowCountMapping"));
            }
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Failed while converting string to object", (Throwable)e);
        }
        this.tablePath = configuration.get("table.write.path");
        String segmentId = configuration.get("hetu.carbondata.states.newSegmentId");
        String encodedLoadModal = configuration.get("hetu.carbondata.states.encodedLoadModel");
        List<String> columnNames = Arrays.asList(properties.getProperty("columns", "").split(","));
        List fileColumnTypes = HiveType.toHiveTypes((String)properties.getProperty("columns.types", "")).stream().map(hiveType -> hiveType.getType(typeManager)).collect(Collectors.toList());
        this.fieldCount = columnNames.size();
        this.serDe = new CarbonHiveSerDe();
        this.serDe.initialize((Configuration)configuration, properties);
        this.tableInspector = (ArrayWritableObjectInspector)this.serDe.getObjectInspector();
        this.structFields = ImmutableList.copyOf((Collection)((Collection)inputColumnNames.stream().map(arg_0 -> ((SettableStructObjectInspector)this.tableInspector).getStructFieldRef(arg_0)).collect(ImmutableList.toImmutableList())));
        this.isInitDone = false;
        this.isCommitDone = false;
        this.row = this.tableInspector.create();
        this.setters = new FieldSetterFactory.FieldSetter[this.structFields.size()];
        FieldSetterFactory fieldSetterFactory = new FieldSetterFactory(DateTimeZone.UTC);
        for (int i = 0; i < this.setters.length; ++i) {
            this.setters[i] = fieldSetterFactory.create(this.tableInspector, this.row, this.structFields.get(i), (Type)fileColumnTypes.get(this.structFields.get(i).getFieldID()));
        }
        if (this.acidWriteType == HiveACIDWriteType.INSERT || this.acidWriteType == HiveACIDWriteType.INSERT_OVERWRITE) {
            try {
                boolean compress = HiveConf.getBoolVar((Configuration)configuration, (HiveConf.ConfVars)HiveConf.ConfVars.COMPRESSRESULT);
                if (segmentId != null && StringUtils.isEmpty((String)encodedLoadModal)) {
                    this.recordWriter = this.getHiveWriter(segmentId, Long.parseLong(configuration.get("carbon.outputformat.taskno", "0")));
                } else {
                    if (StringUtils.isNotEmpty((String)encodedLoadModal)) {
                        configuration.set(LOAD_MODEL, encodedLoadModal);
                    }
                    this.configuration.set("mapred.task.id", this.getTaskAttemptId(String.valueOf(this.taskId)));
                    Object writer = Class.forName(MapredCarbonOutputFormat.class.getName()).getConstructor(new Class[0]).newInstance(new Object[0]);
                    this.recordWriter = ((MapredCarbonOutputFormat)writer).getHiveRecordWriter(this.configuration, localOutPutPath, Text.class, compress, properties, (Progressable)Reporter.NULL);
                }
                this.isInitDone = true;
            }
            catch (Exception e) {
                LOG.error((Object)"error while initializing writer", (Throwable)e);
                throw new RuntimeException("writer class not found");
            }
        }
    }

    private FileSinkOperator.RecordWriter getHiveWriter(String segmentId, long taskNo) throws Exception {
        Path finalOutPutPath = this.outPutPath;
        Properties finalProperties = this.properties;
        JobConf finalConfiguration = this.configuration;
        boolean compress = HiveConf.getBoolVar((Configuration)finalConfiguration, (HiveConf.ConfVars)HiveConf.ConfVars.COMPRESSRESULT);
        CarbonLoadModel carbonLoadModel = HiveCarbonUtil.getCarbonLoadModel((Properties)finalProperties, (Configuration)finalConfiguration);
        carbonLoadModel.setSegmentId(segmentId);
        carbonLoadModel.setTaskNo(String.valueOf(taskNo));
        carbonLoadModel.setFactTimeStamp(Long.parseLong(this.txnTimeStamp));
        carbonLoadModel.setBadRecordsAction(TableOptionConstant.BAD_RECORDS_ACTION.getName() + ",force");
        CarbonTableOutputFormat.setLoadModel((Configuration)finalConfiguration, (CarbonLoadModel)carbonLoadModel);
        this.configuration.set("mapred.task.id", this.getTaskAttemptId(String.valueOf(taskNo)));
        Object writer = Class.forName(MapredCarbonOutputFormat.class.getName()).getConstructor(new Class[0]).newInstance(new Object[0]);
        return ((MapredCarbonOutputFormat)writer).getHiveRecordWriter(finalConfiguration, finalOutPutPath, Text.class, compress, finalProperties, (Progressable)Reporter.NULL);
    }

    public long getWrittenBytes() {
        if (this.isCommitDone) {
            try {
                return this.outPutPath.getFileSystem((Configuration)this.configuration).getFileStatus(this.outPutPath).getLen();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return 0L;
    }

    public long getSystemMemoryUsage() {
        return 0L;
    }

    public void appendRows(Page dataPage) {
        for (int position = 0; position < dataPage.getPositionCount(); ++position) {
            this.appendRow(dataPage, position);
        }
    }

    private String getUpdateTupleIdFromRec(Page dataPage, int position) {
        Block tupleIdBlock = null;
        tupleIdBlock = dataPage.getBlock(dataPage.getChannelCount() - 1).getLoadedBlock();
        return tupleIdBlock.getString(position, 0, 0);
    }

    public void appendRow(Page dataPage, int position) {
        FileSinkOperator.RecordWriter finalRecordWriter = null;
        if (HiveACIDWriteType.isUpdateOrDelete((HiveACIDWriteType)this.acidWriteType)) {
            try {
                DeleteDeltaBlockDetails deleteDeltaBlockDetails = null;
                SegmentUpdateDetails segmentUpdateDetails = null;
                String tupleId = this.getUpdateTupleIdFromRec(dataPage, position);
                String blockId = CarbonUpdateUtil.getRequiredFieldFromTID((String)tupleId, (TupleIdEnum)TupleIdEnum.BLOCK_ID);
                String blockletId = CarbonUpdateUtil.getRequiredFieldFromTID((String)tupleId, (TupleIdEnum)TupleIdEnum.BLOCKLET_ID);
                String pageId = CarbonUpdateUtil.getRequiredFieldFromTID((String)tupleId, (TupleIdEnum)TupleIdEnum.PAGE_ID);
                String rowId = CarbonUpdateUtil.getRequiredFieldFromTID((String)tupleId, (TupleIdEnum)TupleIdEnum.OFFSET);
                final String segmentId = CarbonUpdateUtil.getRequiredFieldFromTID((String)tupleId, (TupleIdEnum)TupleIdEnum.SEGMENT_ID);
                final String segmentBlockId = CarbonUpdateUtil.getSegmentWithBlockFromTID((String)tupleId, (boolean)false);
                final String blockName = CarbonUpdateUtil.getBlockName((String)CarbonTablePath.addDataPartPrefix((String)blockId));
                final String completeBlockName = CarbonTablePath.addDataPartPrefix((String)(blockId + ".carbondata"));
                String blockPath = CarbonUpdateUtil.getTableBlockPath((String)tupleId, (String)this.tablePath, (boolean)true);
                String deltaPath = CarbonUpdateUtil.getDeleteDeltaFilePath((String)blockPath, (String)blockName, (String)this.txnTimeStamp);
                deleteDeltaBlockDetails = this.deleteDeltaDetailsMap.computeIfAbsent(deltaPath, v -> new DeleteDeltaBlockDetails(blockName));
                this.deltaPathSegmentMap.put(deltaPath, segmentId);
                segmentUpdateDetails = this.segmentUpdateDetailMap.computeIfAbsent(segmentBlockId, v -> new SegmentUpdateDetails(){
                    {
                        this.setSegmentName(segmentId);
                        this.setBlockName(blockName);
                        this.setActualBlockName(completeBlockName);
                        this.setDeleteDeltaEndTimestamp(CarbondataFileWriter.this.txnTimeStamp);
                        this.setDeleteDeltaStartTimestamp(CarbondataFileWriter.this.txnTimeStamp);
                        this.setDeletedRowsInBlock(CarbondataFileWriter.this.segmentUpdateStatusManager.getDetailsForABlock(segmentBlockId) != null ? CarbondataFileWriter.this.segmentUpdateStatusManager.getDetailsForABlock(segmentBlockId).getDeletedRowsInBlock() : "0");
                    }
                });
                Long deletedRows = Long.parseLong(segmentUpdateDetails.getDeletedRowsInBlock()) + 1L;
                segmentUpdateDetails.setDeletedRowsInBlock(Long.toString(deletedRows));
                if (!deleteDeltaBlockDetails.addBlocklet(blockletId, rowId, Integer.valueOf(Integer.parseInt(pageId)))) {
                    LOG.error((Object)"Multiple input rows matched for same row!");
                    throw new MultipleMatchingException("Multiple input rows matched for same row!");
                }
                if (HiveACIDWriteType.DELETE == this.acidWriteType) {
                    return;
                }
                finalRecordWriter = this.segmentRecordWriterMap.computeIfAbsent(segmentId, v -> {
                    try {
                        return this.getHiveWriter(segmentId, CarbonUpdateUtil.getLatestTaskIdForSegment((Segment)new Segment(segmentId), (String)this.tablePath) + 1L);
                    }
                    catch (Exception e) {
                        LOG.error((Object)"error while getting Carbon :: hiveRecordWriter", (Throwable)e);
                        throw new RuntimeException("error while getting Carbon :: hiveRecordWriter");
                    }
                });
            }
            catch (Exception e) {
                LOG.error((Object)"error while initializing writer", (Throwable)e);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "writer class not found", (Throwable)e);
            }
        } else {
            finalRecordWriter = this.recordWriter;
        }
        for (int field = 0; field < this.fieldCount; ++field) {
            Block block = dataPage.getBlock(field);
            if (block.isNull(position)) {
                this.tableInspector.setStructFieldData(this.row, this.structFields.get(field), null);
                continue;
            }
            this.setters[field].setField(block, position);
        }
        try {
            if (finalRecordWriter != null) {
                finalRecordWriter.write(this.serDe.serialize(this.row, (ObjectInspector)this.tableInspector));
            }
        }
        catch (IOException | SerDeException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_DATA_ERROR, e);
        }
    }

    public void commit() {
        try {
            if (HiveACIDWriteType.isUpdateOrDelete((HiveACIDWriteType)this.acidWriteType)) {
                if (HiveACIDWriteType.DELETE == this.acidWriteType) {
                    for (String segmentBlockId : this.segmentUpdateDetailMap.keySet()) {
                        Long totalDeletedRowsInBlock;
                        SegmentUpdateDetails segmentUpdateDetails = this.segmentUpdateDetailMap.get(segmentBlockId);
                        RowCountDetailsVO rowCountDetailsVO = this.segmentNoRowCountMapping.get(segmentUpdateDetails.getSegmentName());
                        Long totalRowsInBlock = rowCountDetailsVO.getTotalNumberOfRows();
                        boolean isSegmentDelete = totalRowsInBlock.equals(totalDeletedRowsInBlock = Long.valueOf(Long.parseLong(segmentUpdateDetails.getDeletedRowsInBlock())));
                        if (!isSegmentDelete) continue;
                        this.deleteSegmentMap.put(segmentUpdateDetails.getSegmentName(), true);
                        this.segmentUpdateDetailMap.get(segmentBlockId).setSegmentStatus(SegmentStatus.MARKED_FOR_DELETE);
                    }
                }
                this.deleteDeltaDetailsMap.forEach((k, v) -> {
                    try {
                        if (this.deleteSegmentMap.get(this.deltaPathSegmentMap.get(k)) == null) {
                            new CarbonDeleteDeltaWriterImpl(k).write(v);
                        }
                    }
                    catch (IOException e) {
                        LOG.error((Object)"Error while writing the deleteDeltas ", (Throwable)e);
                        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Error while writing the deleteDeltas", (Throwable)e);
                    }
                });
            }
            if (this.recordWriter != null) {
                this.recordWriter.close(false);
            }
            this.segmentRecordWriterMap.forEach((k, v) -> {
                try {
                    v.close(false);
                }
                catch (IOException e) {
                    LOG.error((Object)"Error while closing the record writer", (Throwable)e);
                    throw new RuntimeException(e);
                }
            });
        }
        catch (Exception ex) {
            LOG.error((Object)"Error while closing the record writer", (Throwable)ex);
            throw new RuntimeException(ex);
        }
        this.isCommitDone = true;
    }

    public void rollback() {
    }

    public long getValidationCpuNanos() {
        return 0L;
    }

    public ImmutableList<String> getExtraPartitionFiles() {
        ImmutableList.Builder deltaFiles = ImmutableList.builder();
        this.deleteDeltaDetailsMap.forEach((deltaFile, v) -> deltaFiles.add(deltaFile));
        return deltaFiles.build();
    }

    public ImmutableList<String> getMiscData() {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        Gson gsonObjectToWrite = new Gson();
        this.segmentUpdateDetailMap.forEach((k, sud) -> listBuilder.add((Object)StringEscapeUtils.escapeJson((String)gsonObjectToWrite.toJson(sud, SegmentUpdateDetails.class))));
        return listBuilder.build();
    }

    private String getTaskAttemptId(String taskId) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmm");
        String jobTrackerId = formatter.format(new Date());
        TaskAttemptID taskAttemptID = new TaskAttemptID(jobTrackerId, 0, TaskType.MAP, Integer.parseInt(taskId), 0);
        return taskAttemptID.toString();
    }
}

