/*
 * Decompiled with CFR 0.152.
 */
package io.hetu.core.plugin.carbondata;

import com.google.inject.Inject;
import io.hetu.core.plugin.carbondata.CarbondataFileWriter;
import io.prestosql.plugin.hive.FileFormatDataSourceStats;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.HiveACIDWriteType;
import io.prestosql.plugin.hive.HiveFileWriter;
import io.prestosql.plugin.hive.HiveFileWriterFactory;
import io.prestosql.plugin.hive.NodeVersion;
import io.prestosql.plugin.hive.metastore.StorageFormat;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.type.TypeManager;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.AcidOutputFormat;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.mapred.JobConf;

public class CarbondataFileWriterFactory
implements HiveFileWriterFactory {
    private final HdfsEnvironment hdfsEnvironment;
    private final TypeManager typeManager;
    private final NodeVersion nodeVersion;
    private final FileFormatDataSourceStats stats;

    @Inject
    public CarbondataFileWriterFactory(HdfsEnvironment hdfsEnvironment, TypeManager typeManager, NodeVersion nodeVersion, FileFormatDataSourceStats stats) {
        this(typeManager, hdfsEnvironment, nodeVersion, stats);
    }

    public CarbondataFileWriterFactory(TypeManager typeManager, HdfsEnvironment hdfsEnvironment, NodeVersion nodeVersion, FileFormatDataSourceStats stats) {
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.nodeVersion = Objects.requireNonNull(nodeVersion, "nodeVersion is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
    }

    public Optional<HiveFileWriter> createFileWriter(Path path, List<String> inputColumnNames, StorageFormat storageFormat, Properties schema, JobConf configuration, ConnectorSession session, Optional<AcidOutputFormat.Options> acidOptions, Optional<HiveACIDWriteType> acidWriteType) {
        try {
            int taskId = session.getTaskId().getAsInt();
            int driverId = session.getDriverId().getAsInt();
            int taskWriterCount = session.getTaskWriterCount();
            int bucketNumber = taskId * taskWriterCount + driverId;
            return Optional.of(new CarbondataFileWriter(path, inputColumnNames, schema, configuration, this.typeManager, acidOptions, acidWriteType, OptionalInt.of(bucketNumber)));
        }
        catch (SerDeException e) {
            throw new RuntimeException("Error while creating carbon file writer", e);
        }
    }
}

