/*
 * Decompiled with CFR 0.152.
 */
package io.hetu.core.plugin.carbondata;

import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.filesystem.CarbonFile;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.index.Segment;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.statusmanager.LoadMetadataDetails;
import org.apache.carbondata.core.statusmanager.SegmentStatus;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.carbondata.processing.loading.model.CarbonLoadModel;
import org.apache.carbondata.processing.merger.CompactionType;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;

public class CarbondataHetuCompactorUtil {
    private static final Logger LOG = LogServiceFactory.getLogService((String)CarbondataHetuCompactorUtil.class.getName());

    private CarbondataHetuCompactorUtil() {
    }

    public static List<List<LoadMetadataDetails>> identifyAndGroupSegmentsToBeMerged(CarbonLoadModel carbonLoadModel, Configuration configuration, CompactionType compaction, long majorCompactionSegSize, long minorCompactionSegCount) {
        Objects.requireNonNull(carbonLoadModel, "carbonLoadModel is null");
        Objects.requireNonNull(configuration, "Configuration is null");
        Objects.requireNonNull(compaction, "Compaction type is null");
        ArrayList<LoadMetadataDetails> carbonSegments = new ArrayList<LoadMetadataDetails>();
        for (LoadMetadataDetails load : carbonLoadModel.getLoadMetadataDetails()) {
            if (!load.isCarbonFormat() || load.getSegmentStatus() != SegmentStatus.SUCCESS) continue;
            carbonSegments.add(load);
        }
        ArrayList<List<LoadMetadataDetails>> groupedCompactionSegments = new ArrayList<List<LoadMetadataDetails>>();
        ArrayList<String> skipSegList = new ArrayList<String>();
        if (compaction == CompactionType.MAJOR) {
            while (true) {
                List<LoadMetadataDetails> segments = CarbondataHetuCompactorUtil.identifySegmentsToBeMergedBasedOnSize(carbonSegments, carbonLoadModel, skipSegList, configuration, majorCompactionSegSize);
                CarbondataHetuCompactorUtil.populateSkipSegs(segments, skipSegList);
                if (segments.size() >= 2) {
                    groupedCompactionSegments.add(segments);
                    continue;
                }
                break;
            }
        } else {
            while (true) {
                List<LoadMetadataDetails> segments = CarbondataHetuCompactorUtil.identifySegmentsToBeMergedBasedOnSegCount(carbonSegments, skipSegList, minorCompactionSegCount);
                CarbondataHetuCompactorUtil.populateSkipSegs(segments, skipSegList);
                if (segments.size() < 2) break;
                groupedCompactionSegments.add(segments);
            }
        }
        return groupedCompactionSegments;
    }

    private static void populateSkipSegs(List<LoadMetadataDetails> segList, List<String> skipSegList) {
        for (LoadMetadataDetails load : segList) {
            skipSegList.add(load.getLoadName());
        }
    }

    private static List<LoadMetadataDetails> identifySegmentsToBeMergedBasedOnSize(List<LoadMetadataDetails> listOfSegmentsAfterPreserve, CarbonLoadModel carbonLoadModel, List<String> segmentsToBeSkipped, Configuration configuration, long majorVacuumSize) {
        ArrayList<Object> segmentsToBeMerged = new ArrayList<LoadMetadataDetails>(16);
        CarbonTable carbonTable = carbonLoadModel.getCarbonDataLoadSchema().getCarbonTable();
        long totalLength = 0L;
        for (LoadMetadataDetails segment : listOfSegmentsAfterPreserve) {
            String segId = segment.getLoadName();
            if (segmentsToBeSkipped.contains(segId)) continue;
            long sizeOfOneSegmentAcrossPartition = 0L;
            if (segment.getSegmentFile() != null) {
                if (!StringUtils.isEmpty((CharSequence)segment.getDataSize())) {
                    sizeOfOneSegmentAcrossPartition = Long.parseLong(segment.getDataSize());
                } else {
                    try {
                        sizeOfOneSegmentAcrossPartition = CarbonUtil.getSizeOfSegment((String)carbonTable.getTablePath(), (Segment)new Segment(segId, segment.getSegmentFile()));
                    }
                    catch (IOException e) {
                        LOG.error((Object)"Size of segment is not available");
                        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Error while reading size of segment" + e);
                    }
                }
            } else {
                sizeOfOneSegmentAcrossPartition = CarbondataHetuCompactorUtil.getSizeOfSegment(carbonTable.getTablePath(), segId, configuration);
            }
            if (sizeOfOneSegmentAcrossPartition > majorVacuumSize * 1024L * 1024L * 1024L) {
                if (segmentsToBeMerged.size() > 1) break;
                segmentsToBeMerged = new ArrayList(16);
                totalLength = 0L;
                continue;
            }
            if ((totalLength += sizeOfOneSegmentAcrossPartition) < majorVacuumSize * 1024L * 1024L) {
                segmentsToBeMerged.add(segment);
                continue;
            }
            if (segmentsToBeMerged.size() > 1) break;
            segmentsToBeMerged = new ArrayList(16);
            segmentsToBeMerged.add(segment);
            totalLength = sizeOfOneSegmentAcrossPartition;
        }
        return segmentsToBeMerged;
    }

    private static List<LoadMetadataDetails> identifySegmentsToBeMergedBasedOnSegCount(List<LoadMetadataDetails> listOfSegmentsAfterPreserve, List<String> segsToBeSkipped, long minorVacuumSegCount) {
        ArrayList<LoadMetadataDetails> unMergedSegments = new ArrayList<LoadMetadataDetails>(16);
        int level1Size = -1;
        boolean isUserDefinedMinorSegCountUsed = false;
        if (minorVacuumSegCount >= 2L) {
            level1Size = (int)minorVacuumSegCount;
            isUserDefinedMinorSegCountUsed = true;
        }
        int unMergeCounter = 0;
        for (LoadMetadataDetails segment : listOfSegmentsAfterPreserve) {
            String segName = segment.getLoadName();
            if (segsToBeSkipped.contains(segName)) continue;
            unMergedSegments.add(segment);
            if (!isUserDefinedMinorSegCountUsed || ++unMergeCounter != level1Size) continue;
            break;
        }
        if (isUserDefinedMinorSegCountUsed) {
            if (unMergedSegments.size() != 0 && (long)unMergedSegments.size() == minorVacuumSegCount) {
                return unMergedSegments;
            }
            return new ArrayList<LoadMetadataDetails>(0);
        }
        if (unMergedSegments.size() != 0) {
            return unMergedSegments;
        }
        return new ArrayList<LoadMetadataDetails>(0);
    }

    private static long getSizeOfSegment(String tablePath, String segId, Configuration configuration) {
        String loadPath = CarbonTablePath.getSegmentPath((String)tablePath, (String)segId);
        CarbonFile segmentFolder = FileFactory.getCarbonFile((String)loadPath, (Configuration)configuration);
        return CarbondataHetuCompactorUtil.getSizeOfFactFileInLoad(segmentFolder);
    }

    private static long getSizeOfFactFileInLoad(CarbonFile carbonFile) {
        CarbonFile[] factFile;
        long factSize = 0L;
        for (CarbonFile fact : factFile = carbonFile.listFiles(file -> CarbonTablePath.isCarbonDataFile((String)file.getName()))) {
            factSize += fact.getSize();
        }
        return factSize;
    }
}

