/*
 * Decompiled with CFR 0.152.
 */
package io.hetu.core.plugin.carbondata;

import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.prestosql.plugin.hive.HiveColumnHandle;
import io.prestosql.plugin.hive.HiveType;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.Range;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.Decimals;
import io.prestosql.spi.type.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.scan.expression.ColumnExpression;
import org.apache.carbondata.core.scan.expression.Expression;
import org.apache.carbondata.core.scan.expression.LiteralExpression;
import org.apache.carbondata.core.scan.expression.conditional.EqualToExpression;
import org.apache.carbondata.core.scan.expression.conditional.GreaterThanEqualToExpression;
import org.apache.carbondata.core.scan.expression.conditional.GreaterThanExpression;
import org.apache.carbondata.core.scan.expression.conditional.InExpression;
import org.apache.carbondata.core.scan.expression.conditional.LessThanEqualToExpression;
import org.apache.carbondata.core.scan.expression.conditional.LessThanExpression;
import org.apache.carbondata.core.scan.expression.conditional.ListExpression;
import org.apache.carbondata.core.scan.expression.logical.AndExpression;
import org.apache.carbondata.core.scan.expression.logical.OrExpression;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;

public class CarbondataHetuFilterUtil {
    private static final String HIVE_DEFAULT_DYNAMIC_PARTITION = "__HIVE_DEFAULT_PARTITION__";
    private static Map<Integer, Expression> filterMap = new HashMap<Integer, Expression>();

    private CarbondataHetuFilterUtil() {
    }

    public static DataType spi2CarbondataTypeMapper(HiveColumnHandle columnHandle) {
        HiveType colType = columnHandle.getHiveType();
        if (colType.equals((Object)HiveType.HIVE_BOOLEAN)) {
            return DataTypes.BOOLEAN;
        }
        if (colType.equals((Object)HiveType.HIVE_SHORT)) {
            return DataTypes.SHORT;
        }
        if (colType.equals((Object)HiveType.HIVE_INT)) {
            return DataTypes.INT;
        }
        if (colType.equals((Object)HiveType.HIVE_LONG)) {
            return DataTypes.LONG;
        }
        if (colType.equals((Object)HiveType.HIVE_FLOAT)) {
            return DataTypes.FLOAT;
        }
        if (colType.equals((Object)HiveType.HIVE_DOUBLE)) {
            return DataTypes.DOUBLE;
        }
        if (colType.equals((Object)HiveType.HIVE_STRING)) {
            return DataTypes.STRING;
        }
        if (colType.equals((Object)HiveType.HIVE_DATE)) {
            return DataTypes.DATE;
        }
        if (colType.equals((Object)HiveType.HIVE_TIMESTAMP)) {
            return DataTypes.TIMESTAMP;
        }
        if (colType.getTypeInfo() instanceof DecimalTypeInfo) {
            DecimalTypeInfo typeInfo = (DecimalTypeInfo)colType.getTypeInfo();
            return DataTypes.createDecimalType((int)typeInfo.getPrecision(), (int)typeInfo.getScale());
        }
        return DataTypes.STRING;
    }

    public static List<String> getPartitionFilters(CarbonTable carbonTable, TupleDomain<HiveColumnHandle> originalConstraint) {
        List columnSchemas = carbonTable.getPartitionInfo().getColumnSchemaList();
        ArrayList<String> filter = new ArrayList<String>();
        for (HiveColumnHandle columnHandle : ((Map)originalConstraint.getDomains().get()).keySet()) {
            List partitionedColumnSchema = columnSchemas.stream().filter(columnSchema -> columnHandle.getName().equals(columnSchema.getColumnName())).collect(Collectors.toList());
            if (partitionedColumnSchema.size() == 0) continue;
            filter.addAll(CarbondataHetuFilterUtil.createPartitionFilters(originalConstraint, columnHandle));
        }
        return filter;
    }

    private static List<String> createPartitionFilters(TupleDomain<HiveColumnHandle> originalConstraint, HiveColumnHandle columnHandle) {
        ArrayList<String> filter = new ArrayList<String>();
        if (!originalConstraint.getDomains().isPresent()) {
            return filter;
        }
        Domain domain = (Domain)((Map)originalConstraint.getDomains().get()).get(columnHandle);
        if (domain != null && domain.isNullableSingleValue()) {
            Object value = domain.getNullableSingleValue();
            Type type = domain.getType();
            if (value == null) {
                filter.add(columnHandle.getName() + "=" + HIVE_DEFAULT_DYNAMIC_PARTITION);
            } else if (columnHandle.getHiveType().getTypeInfo() instanceof DecimalTypeInfo) {
                int scale = ((DecimalTypeInfo)columnHandle.getHiveType().getTypeInfo()).getScale();
                if (value instanceof Long) {
                    BigDecimal decimalValue = new BigDecimal(new BigInteger(String.valueOf(value)), scale);
                    filter.add(columnHandle.getName() + "=" + decimalValue.toString());
                } else if (value instanceof Slice) {
                    BigDecimal decimalValue = new BigDecimal(Decimals.decodeUnscaledValue((Slice)((Slice)value)), scale);
                    filter.add(columnHandle.getName() + "=" + decimalValue.toString());
                }
            } else if (value instanceof Slice) {
                filter.add(columnHandle.getName() + "=" + ((Slice)value).toStringUtf8());
            } else if (value instanceof Long && columnHandle.getHiveType().equals((Object)HiveType.HIVE_DATE)) {
                Calendar c = Calendar.getInstance();
                c.setTime(new Date(0L));
                c.add(6, ((Long)value).intValue());
                Date date = new Date(c.getTime().getTime());
                filter.add(columnHandle.getName() + "=" + date.toString());
            } else if (value instanceof Long && columnHandle.getHiveType().equals((Object)HiveType.HIVE_TIMESTAMP)) {
                String timeStamp = new Timestamp((Long)value).toString();
                filter.add(columnHandle.getName() + "=" + timeStamp.substring(0, timeStamp.indexOf(46)));
            } else if (value instanceof Boolean || value instanceof Double || value instanceof Long) {
                filter.add(columnHandle.getName() + "=" + value.toString());
            } else {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported partition key type: %s", type.getDisplayName()));
            }
        }
        return filter;
    }

    static Expression parseFilterExpression(TupleDomain<HiveColumnHandle> originalConstraint) {
        if (originalConstraint.isNone()) {
            return null;
        }
        AndExpression finalFilters = null;
        for (HiveColumnHandle cdch : ((Map)originalConstraint.getDomains().get()).keySet()) {
            HiveType type = cdch.getHiveType();
            DataType coltype = CarbondataHetuFilterUtil.spi2CarbondataTypeMapper(cdch);
            ColumnExpression colExpression = new ColumnExpression(cdch.getName(), coltype);
            Domain domain = (Domain)((Map)originalConstraint.getDomains().get()).get(cdch);
            Preconditions.checkArgument((boolean)domain.getType().isOrderable(), (Object)"Domain type must be orderable");
            ArrayList<Object> singleValues = new ArrayList<Object>();
            AndExpression colValueExpression = null;
            for (Range range : domain.getValues().getRanges().getOrderedRanges()) {
                if (range.isSingleValue()) {
                    Object value = CarbondataHetuFilterUtil.convertDataByType(range.getLow().getValue(), type);
                    singleValues.add(value);
                    continue;
                }
                OrExpression rangeExpression = null;
                if (!range.getLow().isLowerUnbounded()) {
                    Object value = CarbondataHetuFilterUtil.convertDataByType(range.getLow().getValue(), type);
                    switch (range.getLow().getBound()) {
                        case ABOVE: {
                            rangeExpression = new GreaterThanExpression((Expression)colExpression, (Expression)new LiteralExpression(value, coltype));
                            break;
                        }
                        case EXACTLY: {
                            rangeExpression = new GreaterThanEqualToExpression((Expression)colExpression, (Expression)new LiteralExpression(value, coltype));
                            break;
                        }
                        case BELOW: {
                            throw new IllegalArgumentException("Low marker should never use BELOW bound");
                        }
                        default: {
                            throw new AssertionError((Object)("Unhandled bound: " + range.getLow().getBound()));
                        }
                    }
                }
                if (!range.getHigh().isUpperUnbounded()) {
                    LessThanEqualToExpression lessThanExpression;
                    Object value = CarbondataHetuFilterUtil.convertDataByType(range.getHigh().getValue(), type);
                    switch (range.getHigh().getBound()) {
                        case ABOVE: {
                            throw new IllegalArgumentException("High marker should never use ABOVE bound");
                        }
                        case EXACTLY: {
                            lessThanExpression = new LessThanEqualToExpression((Expression)colExpression, (Expression)new LiteralExpression(value, coltype));
                            break;
                        }
                        case BELOW: {
                            lessThanExpression = new LessThanExpression((Expression)colExpression, (Expression)new LiteralExpression(value, coltype));
                            break;
                        }
                        default: {
                            throw new AssertionError((Object)("Unhandled bound: " + range.getHigh().getBound()));
                        }
                    }
                    rangeExpression = rangeExpression == null ? lessThanExpression : new AndExpression((Expression)rangeExpression, (Expression)lessThanExpression);
                }
                colValueExpression = colValueExpression == null ? rangeExpression : new OrExpression((Expression)colValueExpression, (Expression)rangeExpression);
            }
            if (singleValues.size() == 1) {
                colValueExpression = new EqualToExpression((Expression)colExpression, (Expression)new LiteralExpression(singleValues.get(0), coltype));
            } else if (singleValues.size() > 1) {
                List exs = singleValues.stream().map(a -> new LiteralExpression(a, coltype)).collect(Collectors.toList());
                colValueExpression = new InExpression((Expression)colExpression, (Expression)new ListExpression(exs));
            }
            if (colValueExpression == null) continue;
            finalFilters = finalFilters == null ? colValueExpression : new AndExpression((Expression)finalFilters, (Expression)colValueExpression);
        }
        return finalFilters;
    }

    private static Object convertDataByType(Object rawData, HiveType type) {
        if (type.equals((Object)HiveType.HIVE_INT) || type.equals((Object)HiveType.HIVE_SHORT)) {
            return Integer.valueOf(rawData.toString());
        }
        if (type.equals((Object)HiveType.HIVE_LONG)) {
            return rawData;
        }
        if (type.equals((Object)HiveType.HIVE_STRING) || type.getTypeInfo() instanceof VarcharTypeInfo || type.getTypeInfo() instanceof CharTypeInfo) {
            if (rawData instanceof Slice) {
                String value = ((Slice)rawData).toStringUtf8();
                if (type.getTypeInfo() instanceof CharTypeInfo) {
                    StringBuilder padding = new StringBuilder();
                    int paddedLength = ((CharTypeInfo)type.getTypeInfo()).getLength();
                    int truncatedLength = value.length();
                    for (int i = 0; i < paddedLength - truncatedLength; ++i) {
                        padding.append(" ");
                    }
                    return value + padding;
                }
                return value;
            }
            return rawData;
        }
        if (type.equals((Object)HiveType.HIVE_BOOLEAN)) {
            return rawData;
        }
        if (type.equals((Object)HiveType.HIVE_DATE)) {
            Calendar c = Calendar.getInstance();
            c.setTime(new java.util.Date(0L));
            c.add(6, ((Long)rawData).intValue());
            java.util.Date date = c.getTime();
            return date.getTime() * 1000L;
        }
        if (type.getTypeInfo() instanceof DecimalTypeInfo) {
            if (rawData instanceof Double) {
                return new BigDecimal((Double)rawData);
            }
            if (rawData instanceof Long) {
                return new BigDecimal(new BigInteger(String.valueOf(rawData)), ((DecimalTypeInfo)type.getTypeInfo()).getScale());
            }
            if (rawData instanceof Slice) {
                return new BigDecimal(Decimals.decodeUnscaledValue((Slice)((Slice)rawData)), ((DecimalTypeInfo)type.getTypeInfo()).getScale());
            }
        } else if (type.equals((Object)HiveType.HIVE_TIMESTAMP)) {
            return (Long)rawData * 1000L;
        }
        return rawData;
    }

    static Expression getFilters(Integer key) {
        return filterMap.get(key);
    }

    static void setFilter(Integer tableId, Expression filter) {
        filterMap.put(tableId, filter);
    }
}

