/*
 * Decompiled with CFR 0.152.
 */
package io.hetu.core.plugin.carbondata;

import com.google.inject.Inject;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.HiveErrorCode;
import io.prestosql.plugin.hive.HiveLocationService;
import io.prestosql.plugin.hive.HiveWriteUtils;
import io.prestosql.plugin.hive.LocationHandle;
import io.prestosql.plugin.hive.LocationService;
import io.prestosql.plugin.hive.WriteIdInfo;
import io.prestosql.plugin.hive.metastore.SemiTransactionalHiveMetastore;
import io.prestosql.plugin.hive.metastore.Table;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.connector.ConnectorSession;
import java.util.Optional;
import org.apache.hadoop.fs.Path;

public class CarbondataLocationService
extends HiveLocationService {
    private final HdfsEnvironment hdfsEnvironment;

    @Inject
    public CarbondataLocationService(HdfsEnvironment hdfsEnvironment) {
        super(hdfsEnvironment);
        this.hdfsEnvironment = hdfsEnvironment;
    }

    public LocationHandle forNewTable(SemiTransactionalHiveMetastore metastore, ConnectorSession session, String schemaName, String tableName, Optional<WriteIdInfo> writeIdInfo, Optional<Path> tablePath, HiveWriteUtils.OpertionType opertionType) {
        super.forNewTable(metastore, session, schemaName, tableName, writeIdInfo, tablePath, opertionType);
        HdfsEnvironment.HdfsContext context = new HdfsEnvironment.HdfsContext(session, schemaName, tableName);
        Path targetPath = tablePath.isPresent() ? tablePath.get() : HiveWriteUtils.getTableDefaultLocation((HdfsEnvironment.HdfsContext)context, (SemiTransactionalHiveMetastore)metastore, (HdfsEnvironment)this.hdfsEnvironment, (String)schemaName, (String)tableName);
        if (HiveWriteUtils.pathExists((HdfsEnvironment.HdfsContext)context, (HdfsEnvironment)this.hdfsEnvironment, (Path)targetPath)) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PATH_ALREADY_EXISTS, String.format("Target directory for table '%s.%s' already exists: %s", schemaName, tableName, targetPath));
        }
        return new LocationHandle(targetPath, targetPath, false, LocationHandle.WriteMode.DIRECT_TO_TARGET_NEW_DIRECTORY, writeIdInfo);
    }

    public LocationHandle forExistingTable(SemiTransactionalHiveMetastore metastore, ConnectorSession session, Table table, Optional<WriteIdInfo> writeIdInfo, HiveWriteUtils.OpertionType opertionType) {
        Path targetPath = new Path(table.getStorage().getLocation());
        return new LocationHandle(targetPath, targetPath, true, LocationHandle.WriteMode.DIRECT_TO_TARGET_EXISTING_DIRECTORY, writeIdInfo);
    }

    public LocationService.WriteInfo getTableWriteInfo(LocationHandle locationHandle, boolean overwrite) {
        return new LocationService.WriteInfo(locationHandle.getTargetPath(), locationHandle.getWritePath(), locationHandle.getWriteMode());
    }
}

