/*
 * Decompiled with CFR 0.152.
 */
package io.hetu.core.plugin.carbondata;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import io.airlift.json.JsonCodec;
import io.airlift.slice.Slice;
import io.airlift.units.Duration;
import io.hetu.core.plugin.carbondata.CarbonDeleteAsInsertTableHandle;
import io.hetu.core.plugin.carbondata.CarbondataAutoCleaner;
import io.hetu.core.plugin.carbondata.CarbondataAutoVacuumThread;
import io.hetu.core.plugin.carbondata.CarbondataHetuFilterUtil;
import io.hetu.core.plugin.carbondata.CarbondataInsertTableHandle;
import io.hetu.core.plugin.carbondata.CarbondataMetadataUtils;
import io.hetu.core.plugin.carbondata.CarbondataOutputTableHandle;
import io.hetu.core.plugin.carbondata.CarbondataSegmentInfoUtil;
import io.hetu.core.plugin.carbondata.CarbondataStorageFormat;
import io.hetu.core.plugin.carbondata.CarbondataTableHandle;
import io.hetu.core.plugin.carbondata.CarbondataTableProperties;
import io.hetu.core.plugin.carbondata.CarbondataUpdateTableHandle;
import io.hetu.core.plugin.carbondata.CarbondataVacuumTableHandle;
import io.hetu.core.plugin.carbondata.impl.CarbondataTableCacheModel;
import io.hetu.core.plugin.carbondata.impl.CarbondataTableReader;
import io.prestosql.plugin.hive.BaseStorageFormat;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.HiveACIDWriteType;
import io.prestosql.plugin.hive.HiveBasicStatistics;
import io.prestosql.plugin.hive.HiveBucketProperty;
import io.prestosql.plugin.hive.HiveBucketing;
import io.prestosql.plugin.hive.HiveColumnHandle;
import io.prestosql.plugin.hive.HiveDeleteAsInsertTableHandle;
import io.prestosql.plugin.hive.HiveErrorCode;
import io.prestosql.plugin.hive.HiveInsertTableHandle;
import io.prestosql.plugin.hive.HiveMetadata;
import io.prestosql.plugin.hive.HiveOutputTableHandle;
import io.prestosql.plugin.hive.HivePartitionManager;
import io.prestosql.plugin.hive.HiveSessionProperties;
import io.prestosql.plugin.hive.HiveStorageFormat;
import io.prestosql.plugin.hive.HiveTableHandle;
import io.prestosql.plugin.hive.HiveTableProperties;
import io.prestosql.plugin.hive.HiveType;
import io.prestosql.plugin.hive.HiveTypeName;
import io.prestosql.plugin.hive.HiveUpdateTableHandle;
import io.prestosql.plugin.hive.HiveUtil;
import io.prestosql.plugin.hive.HiveWriteUtils;
import io.prestosql.plugin.hive.HiveWriterFactory;
import io.prestosql.plugin.hive.HiveWrittenPartitions;
import io.prestosql.plugin.hive.LocationHandle;
import io.prestosql.plugin.hive.LocationService;
import io.prestosql.plugin.hive.PartitionStatistics;
import io.prestosql.plugin.hive.PartitionUpdate;
import io.prestosql.plugin.hive.TypeTranslator;
import io.prestosql.plugin.hive.authentication.GenericExceptionAction;
import io.prestosql.plugin.hive.authentication.HiveIdentity;
import io.prestosql.plugin.hive.metastore.Column;
import io.prestosql.plugin.hive.metastore.Database;
import io.prestosql.plugin.hive.metastore.MetastoreUtil;
import io.prestosql.plugin.hive.metastore.Partition;
import io.prestosql.plugin.hive.metastore.PrincipalPrivileges;
import io.prestosql.plugin.hive.metastore.SemiTransactionalHiveMetastore;
import io.prestosql.plugin.hive.metastore.SortingColumn;
import io.prestosql.plugin.hive.metastore.StorageFormat;
import io.prestosql.plugin.hive.metastore.Table;
import io.prestosql.plugin.hive.security.AccessControlMetadata;
import io.prestosql.plugin.hive.statistics.HiveStatisticsProvider;
import io.prestosql.plugin.hive.util.ConfigurationUtils;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.ConnectorDeleteAsInsertTableHandle;
import io.prestosql.spi.connector.ConnectorInsertTableHandle;
import io.prestosql.spi.connector.ConnectorNewTableLayout;
import io.prestosql.spi.connector.ConnectorOutputMetadata;
import io.prestosql.spi.connector.ConnectorOutputTableHandle;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTableMetadata;
import io.prestosql.spi.connector.ConnectorUpdateTableHandle;
import io.prestosql.spi.connector.ConnectorVacuumTableHandle;
import io.prestosql.spi.connector.ConnectorVacuumTableInfo;
import io.prestosql.spi.connector.RetryMode;
import io.prestosql.spi.connector.SchemaNotFoundException;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.connector.TableAlreadyExistsException;
import io.prestosql.spi.connector.TableNotFoundException;
import io.prestosql.spi.statistics.ComputedStatistics;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.carbondata.common.exceptions.sql.NoSuchMVException;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.filesystem.CarbonFile;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.features.TableOperation;
import org.apache.carbondata.core.fileoperations.FileWriteOperation;
import org.apache.carbondata.core.index.Segment;
import org.apache.carbondata.core.locks.CarbonLockFactory;
import org.apache.carbondata.core.locks.CarbonLockUtil;
import org.apache.carbondata.core.locks.ICarbonLock;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.CarbonMetadata;
import org.apache.carbondata.core.metadata.CarbonTableIdentifier;
import org.apache.carbondata.core.metadata.SegmentFileStore;
import org.apache.carbondata.core.metadata.converter.ThriftWrapperSchemaConverterImpl;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.datatype.StructField;
import org.apache.carbondata.core.metadata.schema.PartitionInfo;
import org.apache.carbondata.core.metadata.schema.SchemaEvolutionEntry;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.TableInfo;
import org.apache.carbondata.core.metadata.schema.table.TableSchema;
import org.apache.carbondata.core.metadata.schema.table.TableSchemaBuilder;
import org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema;
import org.apache.carbondata.core.mutate.CarbonUpdateUtil;
import org.apache.carbondata.core.mutate.SegmentUpdateDetails;
import org.apache.carbondata.core.mutate.data.BlockMappingVO;
import org.apache.carbondata.core.statusmanager.LoadMetadataDetails;
import org.apache.carbondata.core.statusmanager.SegmentStatus;
import org.apache.carbondata.core.statusmanager.SegmentStatusManager;
import org.apache.carbondata.core.statusmanager.SegmentUpdateStatusManager;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.ObjectSerializationUtil;
import org.apache.carbondata.core.util.ThreadLocalSessionInfo;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.carbondata.core.writer.ThriftWriter;
import org.apache.carbondata.hadoop.api.CarbonOutputCommitter;
import org.apache.carbondata.hadoop.api.CarbonTableInputFormat;
import org.apache.carbondata.hadoop.api.CarbonTableOutputFormat;
import org.apache.carbondata.hive.MapredCarbonOutputFormat;
import org.apache.carbondata.hive.util.HiveCarbonUtil;
import org.apache.carbondata.processing.loading.TableProcessingOperations;
import org.apache.carbondata.processing.loading.model.CarbonLoadModel;
import org.apache.carbondata.processing.merger.CarbonDataMergerUtil;
import org.apache.carbondata.processing.merger.CompactionType;
import org.apache.carbondata.processing.util.CarbonLoaderUtil;
import org.apache.carbondata.processing.util.TableOptionConstant;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.ProtectMode;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.task.JobContextImpl;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.log4j.Logger;
import org.apache.thrift.TBase;

public class CarbondataMetadata
extends HiveMetadata {
    private static final Logger LOG = LogServiceFactory.getLogService((String)CarbondataMetadata.class.getName());
    private static final String LOAD_MODEL = "mapreduce.carbontable.load.model";
    private static final String SET_OVERWRITE = "mapreduce.carbontable.set.overwrite";
    private final CarbondataTableReader carbondataTableReader;
    private final String carbondataStorageFolderName = "carbon.store";
    private final String defaultDBName = "default";
    private final String serdeTableName = "tablename";
    private final String serdeIsExternal = "isExternal";
    private final String serdePath = "path";
    private final String serdeTablePath = "tablePath";
    private final String serdeIsTransactional = "isTransactional";
    private final String serdeIsVisible = "isVisible";
    private final String serdeSerializationFormat = "serialization.format";
    private final String serdeDbName = "dbname";
    private final JsonCodec<CarbondataSegmentInfoUtil> segmentInfoCodec;
    private OutputCommitter carbonOutputCommitter;
    private JobContextImpl jobContext;
    private Optional<Table> table;
    private CarbonTable carbonTable;
    private Long timeStamp = System.currentTimeMillis();
    private ICarbonLock metadataLock;
    private ICarbonLock compactionLock;
    private ICarbonLock updateLock;
    private Configuration initialConfiguration;
    private List<SegmentUpdateDetails> blockUpdateDetailsList;
    private State currentState = State.OTHER;
    private CarbonLoadModel carbonLoadModel;
    private AbsoluteTableIdentifier absoluteTableIdentifier;
    private TableInfo tableInfo;
    private SchemaTableName schemaTableName;
    private String user;
    private Optional<String> tableStorageLocation;
    private String carbondataTableStore;
    private ICarbonLock carbonDropTableLock;
    private String schemaName;
    private String compactionType;
    private long minorVacuumSegCount;
    private long majorVacuumSegSize;
    private List<Segment> segmentFilesToBeUpdatedLatest = new ArrayList<Segment>();
    private List<List<LoadMetadataDetails>> segmentsMerged = new ArrayList<List<LoadMetadataDetails>>();
    private List<CarbondataAutoCleaner> autoCleanerTasks = new ArrayList<CarbondataAutoCleaner>();
    private static boolean enableTracingCleanupTask;
    private static ConcurrentSkipListSet<Future<?>> queuedTasks;

    public CarbondataMetadata(SemiTransactionalHiveMetastore metastore, HdfsEnvironment hdfsEnvironment, HivePartitionManager partitionManager, boolean writesToNonManagedTablesEnabled, boolean createsOfNonManagedTablesEnabled, boolean tableCreatesWithLocationAllowed, TypeManager typeManager, LocationService locationService, JsonCodec<PartitionUpdate> partitionUpdateCodec, JsonCodec<CarbondataSegmentInfoUtil> segmentInfoCodec, TypeTranslator typeTranslator, String hetuVersion, HiveStatisticsProvider hiveStatisticsProvider, AccessControlMetadata accessControlMetadata, CarbondataTableReader carbondataTableReader, String carbondataTableStore, long carbondataMajorVacuumSegSize, long carbondataMinorVacuumSegCount, ScheduledExecutorService executorService, ScheduledExecutorService hiveMetastoreClientService) {
        super(metastore, hdfsEnvironment, partitionManager, writesToNonManagedTablesEnabled, createsOfNonManagedTablesEnabled, tableCreatesWithLocationAllowed, typeManager, locationService, partitionUpdateCodec, typeTranslator, hetuVersion, hiveStatisticsProvider, accessControlMetadata, false, 2, 0.0, executorService, Optional.of(new Duration(5.0, TimeUnit.MINUTES)), hiveMetastoreClientService);
        this.carbondataTableReader = carbondataTableReader;
        this.carbondataTableStore = carbondataTableStore;
        this.metadataLock = null;
        this.carbonDropTableLock = null;
        this.schemaName = null;
        this.tableStorageLocation = Optional.empty();
        this.majorVacuumSegSize = carbondataMajorVacuumSegSize;
        this.minorVacuumSegCount = carbondataMinorVacuumSegCount;
        this.segmentInfoCodec = Objects.requireNonNull(segmentInfoCodec, "segmentInfoCodec is null");
    }

    private void setupCommitWriter(Optional<Table> table, Path outputPath, Configuration initialConfiguration, boolean isOverwrite) {
        Properties hiveSchema = MetastoreUtil.getHiveSchema((Table)table.get());
        this.setupCommitWriter(hiveSchema, outputPath, initialConfiguration, isOverwrite);
    }

    private void setupCommitWriter(Properties hiveSchema, Path outputPath, Configuration initialConfiguration, boolean isOverwrite) throws PrestoException {
        TaskAttemptID taskAttemptID = TaskAttemptID.forName((String)initialConfiguration.get("mapred.task.id"));
        try {
            ThreadLocalSessionInfo.setConfigurationToCurrentThread((Configuration)initialConfiguration);
            CarbonLoadModel finalCarbonLoadModel = HiveCarbonUtil.getCarbonLoadModel((Properties)hiveSchema, (Configuration)initialConfiguration);
            finalCarbonLoadModel.setBadRecordsAction(TableOptionConstant.BAD_RECORDS_ACTION.getName() + ",force");
            CarbonTableOutputFormat.setLoadModel((Configuration)initialConfiguration, (CarbonLoadModel)finalCarbonLoadModel);
        }
        catch (IOException ex) {
            LOG.error((Object)"Error while creating carbon load model", (Throwable)ex);
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Error while creating carbon load model", (Throwable)ex);
        }
        if (taskAttemptID == null) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmssSSS");
            String jobTrackerId = formatter.format(new Date());
            taskAttemptID = new TaskAttemptID(jobTrackerId, 0, TaskType.MAP, 0, 0);
        }
        TaskAttemptContextImpl context = new TaskAttemptContextImpl(initialConfiguration, taskAttemptID);
        initialConfiguration.set(SET_OVERWRITE, String.valueOf(isOverwrite));
        try {
            this.carbonOutputCommitter = new CarbonOutputCommitter(outputPath, (TaskAttemptContext)context);
            this.jobContext = new JobContextImpl(initialConfiguration, new JobID());
            this.carbonOutputCommitter.setupJob((JobContext)this.jobContext);
            ThreadLocalSessionInfo.setConfigurationToCurrentThread((Configuration)context.getConfiguration());
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Error setting the output committer", (Throwable)e);
        }
    }

    public CarbondataInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle) {
        boolean isInsertExistingPartitionsOverwrite = HiveSessionProperties.getInsertExistingPartitionsBehavior((ConnectorSession)session) == HiveSessionProperties.InsertExistingPartitionsBehavior.OVERWRITE;
        return this.beginInsertUpdateInternal(session, tableHandle, isInsertExistingPartitionsOverwrite);
    }

    public CarbondataInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle, RetryMode retryMode) {
        if (retryMode != RetryMode.NO_RETRIES) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Carbondata connector does not support insert with query retries enabled");
        }
        return this.beginInsert(session, tableHandle);
    }

    public CarbondataInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle, boolean isOverwrite, RetryMode retryMode) {
        if (retryMode != RetryMode.NO_RETRIES) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Carbondata connector does not support insert with query retries enabled");
        }
        return this.beginInsert(session, tableHandle, isOverwrite);
    }

    public CarbondataInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle, boolean isOverwrite) {
        return this.beginInsertUpdateInternal(session, tableHandle, isOverwrite);
    }

    private CarbondataInsertTableHandle beginInsertUpdateInternal(ConnectorSession session, ConnectorTableHandle tableHandle, boolean isOverwrite) {
        this.currentState = State.INSERT;
        HiveInsertTableHandle parent = super.beginInsert(session, tableHandle);
        this.user = session.getUser();
        return (CarbondataInsertTableHandle)((Object)this.hdfsEnvironment.doAs(this.user, () -> {
            SchemaTableName tableName = parent.getSchemaTableName();
            Optional finalTable = this.metastore.getTable(new HiveIdentity(session), tableName.getSchemaName(), tableName.getTableName());
            if (finalTable.isPresent() && ((Table)finalTable.get()).getPartitionColumns().size() > 0) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Operations on Partitioned CarbonTables is not supported");
            }
            this.table = finalTable;
            Path outputPath = new Path(parent.getLocationHandle().getJsonSerializableTargetPath());
            this.initialConfiguration = ConfigurationUtils.toJobConf((Configuration)this.hdfsEnvironment.getConfiguration(new HdfsEnvironment.HdfsContext(session, parent.getSchemaName(), parent.getTableName()), new Path(parent.getLocationHandle().getJsonSerializableWritePath())));
            try {
                outputPath.getFileSystem(this.initialConfiguration);
            }
            catch (IOException e) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Failed to get file system", (Throwable)e);
            }
            this.setupCommitWriter(finalTable, outputPath, this.initialConfiguration, isOverwrite);
            return new CarbondataInsertTableHandle(parent.getSchemaName(), parent.getTableName(), parent.getInputColumns(), parent.getPageSinkMetadata(), parent.getLocationHandle(), parent.getBucketProperty(), parent.getTableStorageFormat(), parent.getPartitionStorageFormat(), (Map<String, String>)ImmutableMap.of((Object)"hetu.carbondata.states.encodedLoadModel", (Object)this.jobContext.getConfiguration().get(LOAD_MODEL)), isOverwrite);
        }));
    }

    public Optional<ConnectorOutputMetadata> finishInsert(ConnectorSession session, ConnectorInsertTableHandle insertHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        Optional connectorOutputMetadata = super.finishInsert(session, insertHandle, fragments, computedStatistics);
        this.writeSegmentFileAndSetLoadModel();
        this.autoCleanerTasks.add(new CarbondataAutoCleaner(this.table.get(), this.initialConfiguration, this.carbondataTableReader, this.metastore, this.hdfsEnvironment, this.user));
        return connectorOutputMetadata;
    }

    public CarbondataUpdateTableHandle beginUpdateAsInsert(ConnectorSession session, ConnectorTableHandle tableHandle, RetryMode retryMode) {
        if (retryMode != RetryMode.NO_RETRIES) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Carbondata connector does not support update with query retries enabled");
        }
        return this.beginUpdateAsInsert(session, tableHandle);
    }

    public CarbondataUpdateTableHandle beginUpdateAsInsert(ConnectorSession session, ConnectorTableHandle tableHandle) {
        this.currentState = State.UPDATE;
        HiveInsertTableHandle parent = super.beginInsert(session, tableHandle);
        SchemaTableName tableName = parent.getSchemaTableName();
        Optional finalTable = this.metastore.getTable(new HiveIdentity(session), tableName.getSchemaName(), tableName.getTableName());
        if (finalTable.isPresent() && ((Table)finalTable.get()).getPartitionColumns().size() > 0) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Operations on Partitioned CarbonTables is not supported");
        }
        this.table = finalTable;
        this.user = session.getUser();
        this.hdfsEnvironment.doAs(this.user, () -> {
            this.initialConfiguration = ConfigurationUtils.toJobConf((Configuration)this.hdfsEnvironment.getConfiguration(new HdfsEnvironment.HdfsContext(session, parent.getSchemaName(), parent.getTableName()), new Path(parent.getLocationHandle().getJsonSerializableWritePath())));
            Properties schema = MetastoreUtil.getHiveSchema((Table)((Table)finalTable.get()));
            schema.setProperty("tablePath", ((Table)finalTable.get()).getStorage().getLocation());
            this.carbonTable = this.getCarbonTable(parent.getSchemaName(), parent.getTableName(), schema, this.initialConfiguration);
            this.takeLocks(this.currentState);
            try {
                CarbonUpdateUtil.cleanUpDeltaFiles((CarbonTable)this.carbonTable, (boolean)false);
            }
            catch (IOException e) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Failed while cleaning Delta files", (Throwable)e);
            }
        });
        HashMap<String, String> additionalConf = new HashMap<String, String>();
        additionalConf.put("hetu.carbondata.states.transactionbegintimestamp", this.timeStamp.toString());
        try {
            additionalConf.put("hetu.carbondata.states.carbonTable", ObjectSerializationUtil.convertObjectToString((Object)this.carbonTable));
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Failed while converting objects to string", (Throwable)e);
        }
        return new CarbondataUpdateTableHandle(parent.getSchemaName(), parent.getTableName(), parent.getInputColumns(), parent.getPageSinkMetadata(), parent.getLocationHandle(), parent.getBucketProperty(), parent.getTableStorageFormat(), parent.getPartitionStorageFormat(), additionalConf);
    }

    public CarbonDeleteAsInsertTableHandle beginDeletesAsInsert(ConnectorSession session, ConnectorTableHandle tableHandle, RetryMode retryMode) {
        if (retryMode != RetryMode.NO_RETRIES) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Carbondata connector does not support delete with query retries enabled");
        }
        return this.beginDeletesAsInsert(session, tableHandle);
    }

    public CarbonDeleteAsInsertTableHandle beginDeletesAsInsert(ConnectorSession session, ConnectorTableHandle tableHandle) {
        this.currentState = State.DELETE;
        HiveInsertTableHandle parent = super.beginInsert(session, tableHandle);
        List<HiveColumnHandle> inputColumns = parent.getInputColumns().stream().filter(HiveColumnHandle::isRequired).collect(Collectors.toList());
        SchemaTableName tableName = parent.getSchemaTableName();
        Optional finalTable = this.metastore.getTable(new HiveIdentity(session), tableName.getSchemaName(), tableName.getTableName());
        if (finalTable.isPresent() && ((Table)finalTable.get()).getPartitionColumns().size() > 0) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Operations on Partitioned CarbonTables is not supported");
        }
        this.table = finalTable;
        this.user = session.getUser();
        this.hdfsEnvironment.doAs(this.user, () -> {
            this.initialConfiguration = ConfigurationUtils.toJobConf((Configuration)this.hdfsEnvironment.getConfiguration(new HdfsEnvironment.HdfsContext(session, parent.getSchemaName(), parent.getTableName()), new Path(parent.getLocationHandle().getJsonSerializableWritePath())));
            Properties schema = MetastoreUtil.getHiveSchema((Table)((Table)finalTable.get()));
            schema.setProperty("tablePath", ((Table)finalTable.get()).getStorage().getLocation());
            this.carbonTable = this.getCarbonTable(parent.getSchemaName(), parent.getTableName(), schema, this.initialConfiguration);
            this.takeLocks(this.currentState);
            try {
                CarbonUpdateUtil.cleanUpDeltaFiles((CarbonTable)this.carbonTable, (boolean)false);
            }
            catch (IOException e) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Failed while cleaning Delta files", (Throwable)e);
            }
        });
        HashMap<String, String> additionalConf = new HashMap<String, String>();
        this.initialConfiguration.set("mapreduce.input.fileinputformat.inputdir", parent.getLocationHandle().getTargetPath().toString());
        this.initialConfiguration.set("mapreduce.input.carboninputformat.databaseName", parent.getSchemaName());
        this.initialConfiguration.set("mapreduce.input.carboninputformat.tableName", parent.getTableName());
        additionalConf.put("hetu.carbondata.states.transactionbegintimestamp", this.timeStamp.toString());
        try {
            Job job = new Job(this.initialConfiguration);
            CarbonTableInputFormat carbonTableInputFormat = new CarbonTableInputFormat();
            FileInputFormat.addInputPath((JobConf)((JobConf)this.initialConfiguration), (Path)parent.getLocationHandle().getTargetPath());
            BlockMappingVO blockMappingVO = carbonTableInputFormat.getBlockRowCount(job, this.carbonTable, null, true);
            LoadMetadataDetails[] loadMetadataDetails = SegmentStatusManager.readTableStatusFile((String)CarbonTablePath.getTableStatusFilePath((String)this.carbonTable.getTablePath()));
            SegmentUpdateStatusManager segmentUpdateStatusManager = new SegmentUpdateStatusManager(this.carbonTable, loadMetadataDetails);
            CarbonUpdateUtil.createBlockDetailsMap((BlockMappingVO)blockMappingVO, (SegmentUpdateStatusManager)segmentUpdateStatusManager);
            HashMap segmentNoRowCountMapping = new HashMap();
            TreeMap blockRowCountMapping = new TreeMap();
            for (Map.Entry entry : blockMappingVO.getBlockRowCountMapping().entrySet()) {
                blockRowCountMapping.put(entry.getKey(), entry.getValue());
            }
            for (Map.Entry entry : blockRowCountMapping.entrySet()) {
                String key = (String)entry.getKey();
                segmentNoRowCountMapping.putIfAbsent(blockMappingVO.getBlockToSegmentMapping().get(key), blockMappingVO.getCompleteBlockRowDetailVO().get(key));
            }
            additionalConf.put("hetu.carbondata.states.carbonTable", ObjectSerializationUtil.convertObjectToString((Object)this.carbonTable));
            additionalConf.put("hetu.carbondata.states.segmentNoRowCountMapping", ObjectSerializationUtil.convertObjectToString(segmentNoRowCountMapping));
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Failed while converting objects to string", (Throwable)e);
        }
        return new CarbonDeleteAsInsertTableHandle(parent.getSchemaName(), parent.getTableName(), inputColumns, parent.getPageSinkMetadata(), parent.getLocationHandle(), parent.getBucketProperty(), parent.getTableStorageFormat(), parent.getPartitionStorageFormat(), additionalConf);
    }

    public Optional<ConnectorOutputMetadata> finishUpdateAsInsert(ConnectorSession session, ConnectorUpdateTableHandle updateHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        HiveUpdateTableHandle updateTableHandle = (HiveUpdateTableHandle)updateHandle;
        HiveInsertTableHandle insertTableHandle = new HiveInsertTableHandle(updateTableHandle.getSchemaName(), updateTableHandle.getTableName(), updateTableHandle.getInputColumns(), updateTableHandle.getPageSinkMetadata(), updateTableHandle.getLocationHandle(), updateTableHandle.getBucketProperty(), updateTableHandle.getTableStorageFormat(), updateTableHandle.getPartitionStorageFormat(), false, updateTableHandle.isRetriesEnabled());
        this.autoCleanerTasks.add(new CarbondataAutoCleaner(this.table.get(), this.initialConfiguration, this.carbondataTableReader, this.metastore, this.hdfsEnvironment, this.user));
        return this.finishUpdateAndDelete(session, insertTableHandle, fragments, computedStatistics);
    }

    public Optional<ConnectorOutputMetadata> finishDeleteAsInsert(ConnectorSession session, ConnectorDeleteAsInsertTableHandle deleteHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        HiveDeleteAsInsertTableHandle deleteTableHandle = (HiveDeleteAsInsertTableHandle)deleteHandle;
        HiveInsertTableHandle insertTableHandle = new HiveInsertTableHandle(deleteTableHandle.getSchemaName(), deleteTableHandle.getTableName(), deleteTableHandle.getInputColumns(), deleteTableHandle.getPageSinkMetadata(), deleteTableHandle.getLocationHandle(), deleteTableHandle.getBucketProperty(), deleteTableHandle.getTableStorageFormat(), deleteTableHandle.getPartitionStorageFormat(), false, deleteTableHandle.isRetriesEnabled());
        this.autoCleanerTasks.add(new CarbondataAutoCleaner(this.table.get(), this.initialConfiguration, this.carbondataTableReader, this.metastore, this.hdfsEnvironment, this.user));
        return this.finishUpdateAndDelete(session, insertTableHandle, fragments, computedStatistics);
    }

    public CarbondataVacuumTableHandle beginVacuum(ConnectorSession session, ConnectorTableHandle tableHandle, boolean full, boolean merge, Optional<String> partition) throws PrestoException {
        if (merge) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support vacuum merge");
        }
        this.currentState = State.VACUUM;
        HiveInsertTableHandle insertTableHandle = super.beginInsert(session, tableHandle);
        this.user = session.getUser();
        SchemaTableName tableName = insertTableHandle.getSchemaTableName();
        this.table = this.metastore.getTable(new HiveIdentity(session), tableName.getSchemaName(), tableName.getTableName());
        try {
            this.hdfsEnvironment.getFileSystem(new HdfsEnvironment.HdfsContext(session, this.table.get().getDatabaseName()), new Path(this.table.get().getStorage().getLocation()));
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Failed to get file system" + e.getMessage());
        }
        return (CarbondataVacuumTableHandle)((Object)this.hdfsEnvironment.doAs(this.user, () -> {
            this.initialConfiguration = ConfigurationUtils.toJobConf((Configuration)this.hdfsEnvironment.getConfiguration(new HdfsEnvironment.HdfsContext(session, insertTableHandle.getSchemaName(), insertTableHandle.getTableName()), new Path(insertTableHandle.getLocationHandle().getJsonSerializableWritePath())));
            Properties hiveSchema = MetastoreUtil.getHiveSchema((Table)this.table.get());
            this.carbonTable = this.getCarbonTable(insertTableHandle.getSchemaName(), insertTableHandle.getTableName(), hiveSchema, this.initialConfiguration);
            try {
                this.takeLocks(this.currentState);
                this.carbonLoadModel = HiveCarbonUtil.getCarbonLoadModel((Properties)hiveSchema, (Configuration)this.initialConfiguration);
                CarbonTableOutputFormat.setLoadModel((Configuration)this.initialConfiguration, (CarbonLoadModel)this.carbonLoadModel);
            }
            catch (IOException ex) {
                this.releaseLocks();
                LOG.error((Object)"Error while creating carbon load model", (Throwable)ex);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Error while creating carbon load model", (Throwable)ex);
            }
            try {
                CarbonUpdateUtil.cleanUpDeltaFiles((CarbonTable)this.carbonTable, (boolean)false);
            }
            catch (IOException ex) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Error while cleaning up delta files", (Throwable)ex);
            }
            this.addToAutoVacuumMap(session);
            return new CarbondataVacuumTableHandle(insertTableHandle.getSchemaName(), insertTableHandle.getTableName(), insertTableHandle.getInputColumns(), insertTableHandle.getPageSinkMetadata(), insertTableHandle.getLocationHandle(), insertTableHandle.getBucketProperty(), insertTableHandle.getTableStorageFormat(), insertTableHandle.getPartitionStorageFormat(), full, (Map<String, String>)ImmutableMap.of((Object)"hetu.carbondata.states.encodedLoadModel", (Object)this.initialConfiguration.get(LOAD_MODEL), (Object)"hetu.carbondata.states.transactionbegintimestamp", (Object)this.timeStamp.toString()));
        }));
    }

    public Optional<ConnectorOutputMetadata> finishVacuum(ConnectorSession session, ConnectorVacuumTableHandle handle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        ArrayList partitionUpdates = new ArrayList();
        CarbondataVacuumTableHandle carbondataVacuumTableHandle = (CarbondataVacuumTableHandle)handle;
        return (Optional)this.hdfsEnvironment.doAs(session.getUser(), () -> {
            Properties hiveSchema = MetastoreUtil.getHiveSchema((Table)this.table.get());
            CarbonTable finalCarbonTable = this.getCarbonTable(carbondataVacuumTableHandle.getSchemaName(), carbondataVacuumTableHandle.getTableName(), hiveSchema, this.initialConfiguration);
            this.compactionType = carbondataVacuumTableHandle.isFullVacuum() ? "MAJOR" : "MINOR";
            List mergedSegmentInfoUtilList = fragments.stream().map(Slice::getBytes).map(arg_0 -> this.segmentInfoCodec.fromJson(arg_0)).collect(Collectors.toList());
            HashMap<String, Set<String>> mergedSegmentInfoUtilListMap = new HashMap<String, Set<String>>();
            for (Object segment : mergedSegmentInfoUtilList) {
                if (mergedSegmentInfoUtilListMap.containsKey(((CarbondataSegmentInfoUtil)segment).getDestinationSegment())) {
                    Set set = (Set)mergedSegmentInfoUtilListMap.get(((CarbondataSegmentInfoUtil)segment).getDestinationSegment());
                    set.addAll(((CarbondataSegmentInfoUtil)segment).getSourceSegmentIdSet());
                    mergedSegmentInfoUtilListMap.put(((CarbondataSegmentInfoUtil)segment).getDestinationSegment(), set);
                    continue;
                }
                mergedSegmentInfoUtilListMap.put(((CarbondataSegmentInfoUtil)segment).getDestinationSegment(), ((CarbondataSegmentInfoUtil)segment).getSourceSegmentIdSet());
            }
            ArrayList<CarbondataSegmentInfoUtil> newMergedSegmentInfoUtilList = new ArrayList<CarbondataSegmentInfoUtil>();
            for (Map.Entry entry : mergedSegmentInfoUtilListMap.entrySet()) {
                CarbondataSegmentInfoUtil carbondataSegmentInfoUtil = new CarbondataSegmentInfoUtil((String)entry.getKey(), (Set)entry.getValue());
                newMergedSegmentInfoUtilList.add(carbondataSegmentInfoUtil);
            }
            HashSet<Set<String>> segmentIdSuperSet = new HashSet<Set<String>>();
            for (CarbondataSegmentInfoUtil carbondataSegmentInfoUtil : newMergedSegmentInfoUtilList) {
                Set<String> tempSet = carbondataSegmentInfoUtil.getSourceSegmentIdSet();
                segmentIdSuperSet.add(tempSet);
            }
            for (Set set : segmentIdSuperSet) {
                ArrayList<LoadMetadataDetails> segmentsMergedList = new ArrayList<LoadMetadataDetails>();
                for (LoadMetadataDetails load : this.carbonLoadModel.getLoadMetadataDetails()) {
                    if (!load.isCarbonFormat() || load.getSegmentStatus() != SegmentStatus.SUCCESS || !this.loadIsMergedInWorker(load.getLoadName(), set)) continue;
                    segmentsMergedList.add(load);
                }
                this.segmentsMerged.add(segmentsMergedList);
            }
            if (this.carbonTable.isHivePartitionTable()) {
                List list = partitionUpdates.stream().map(PartitionUpdate::getName).collect(Collectors.toList());
                String string = CarbonTablePath.getSegmentFilesLocation((String)(this.carbonLoadModel.getTablePath() + "/" + this.carbonLoadModel.getSegmentId() + "_" + this.carbonLoadModel.getFactTimeStamp() + ".tmp"));
                String segmentFileName = SegmentFileStore.genSegmentFileName((String)this.carbonLoadModel.getSegmentId(), (String)String.valueOf(this.timeStamp));
                try {
                    SegmentFileStore.mergeSegmentFiles((String)string, (String)segmentFileName, (String)CarbonTablePath.getSegmentFilesLocation((String)this.carbonLoadModel.getTablePath()));
                    for (String currPartitionName : list) {
                        String source = finalCarbonTable.getTablePath() + "/" + currPartitionName;
                        this.moveFromTempFolder(source + "/" + this.carbonLoadModel.getSegmentId() + "_" + this.timeStamp + ".tmp", source);
                    }
                    this.segmentFilesToBeUpdatedLatest.add(new Segment(this.carbonLoadModel.getSegmentId(), segmentFileName));
                }
                catch (IOException e) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Failed while merging segment files", (Throwable)e);
                }
                segmentFileName = segmentFileName + ".segment";
            } else {
                for (CarbondataSegmentInfoUtil carbondataSegmentInfoUtil : newMergedSegmentInfoUtilList) {
                    String mergedLoadNumber = carbondataSegmentInfoUtil.getDestinationSegment();
                    try {
                        String e = SegmentFileStore.writeSegmentFile((CarbonTable)finalCarbonTable, (String)mergedLoadNumber, (String)String.valueOf(this.carbonLoadModel.getFactTimeStamp()));
                    }
                    catch (IOException e) {
                        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Failed while merging segment files", (Throwable)e);
                    }
                }
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            for (CarbondataSegmentInfoUtil segment : mergedSegmentInfoUtilList) {
                arrayList.addAll(segment.getSourceSegmentIdSet());
            }
            this.autoCleanerTasks.add(new CarbondataAutoCleaner(this.table.get(), this.initialConfiguration, this.carbondataTableReader, this.metastore, this.hdfsEnvironment, this.user));
            return Optional.of(new HiveWrittenPartitions(arrayList));
        });
    }

    private boolean loadIsMergedInWorker(String loadName, Set<String> mergedSegmentNames) {
        return mergedSegmentNames.contains(loadName);
    }

    private void moveFromTempFolder(String source, String dest) {
        CarbonFile[] oldFiles;
        CarbonFile oldFolder = FileFactory.getCarbonFile((String)source);
        for (CarbonFile file : oldFiles = oldFolder.listFiles()) {
            file.renameForce(dest + "/" + file.getName());
        }
        oldFolder.delete();
    }

    public Optional<ConnectorNewTableLayout> getUpdateLayout(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return this.getInsertLayout(session, tableHandle);
    }

    public ColumnHandle getDeleteRowIdColumnHandle(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return new HiveColumnHandle("tupleId", HiveType.HIVE_STRING, HiveType.HIVE_STRING.getTypeSignature(), -13, HiveColumnHandle.ColumnType.SYNTHESIZED, Optional.empty());
    }

    public ColumnHandle getUpdateRowIdColumnHandle(ConnectorSession session, ConnectorTableHandle tableHandle, List<ColumnHandle> updatedColumns) {
        return new HiveColumnHandle("tupleId", HiveType.HIVE_STRING, HiveType.HIVE_STRING.getTypeSignature(), -13, HiveColumnHandle.ColumnType.SYNTHESIZED, Optional.empty());
    }

    protected Map<String, String> getEmptyTableProperties(ConnectorTableMetadata tableMetadata, Optional<HiveBucketProperty> bucketProperty, HdfsEnvironment.HdfsContext hdfsContext) {
        CarbondataStorageFormat hiveStorageFormat = (CarbondataStorageFormat)CarbondataTableProperties.getCarbondataStorageFormat(tableMetadata.getProperties());
        ImmutableMap.Builder tableProperties = ImmutableMap.builder();
        if (HiveTableProperties.getTransactionalValue((Map)tableMetadata.getProperties())) {
            if (!hiveStorageFormat.name().equals("CARBON")) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Only CARBON storage format supports creating transactional table.");
            }
            tableProperties.put((Object)"transactional", (Object)Boolean.toString(HiveTableProperties.getTransactionalValue((Map)tableMetadata.getProperties())));
        }
        tableMetadata.getComment().ifPresent(value -> tableProperties.put((Object)"comment", value));
        return tableProperties.build();
    }

    private CarbonTable getCarbonTable(String dbName, String tableName, Properties schema, Configuration configuration) {
        return CarbondataMetadata.getCarbonTable(dbName, tableName, schema, configuration, this.carbondataTableReader);
    }

    static CarbonTable getCarbonTable(String dbName, String tableName, Properties schema, Configuration configuration, CarbondataTableReader carbondataTableReader) {
        CarbondataTableCacheModel tableCacheModel = carbondataTableReader.getCarbonCache(new SchemaTableName(dbName, tableName), schema.getProperty("tablePath"), configuration);
        Objects.requireNonNull(tableCacheModel, "tableCacheModel should not be null");
        Objects.requireNonNull(tableCacheModel.getCarbonTable(), "tableCacheModel.carbonTable should not be null");
        Objects.requireNonNull(tableCacheModel.getCarbonTable().getTableInfo(), "tableCacheModel.carbonTable.tableInfo should not be null");
        return tableCacheModel.getCarbonTable();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void rollback() {
        try {
            switch (this.currentState) {
                case INSERT: {
                    this.hdfsEnvironment.doAs(this.user, () -> {
                        if (this.carbonLoadModel != null) {
                            CarbonLoaderUtil.deleteSegment((CarbonLoadModel)this.carbonLoadModel, (int)Integer.parseInt(this.carbonLoadModel.getSegmentId()));
                        }
                        try {
                            this.carbonOutputCommitter.abortJob((JobContext)this.jobContext, JobStatus.State.FAILED);
                        }
                        catch (IOException e) {
                            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Failed to abort job", (Throwable)e);
                        }
                    });
                    return;
                }
                case UPDATE: 
                case DELETE: {
                    this.hdfsEnvironment.doAs(this.user, () -> {
                        if (this.carbonTable != null) {
                            CarbonUpdateUtil.cleanStaleDeltaFiles((CarbonTable)this.carbonTable, (String)this.timeStamp.toString());
                        }
                    });
                    return;
                }
                case VACUUM: {
                    this.hdfsEnvironment.doAs(this.user, () -> {
                        if (this.carbonTable != null) {
                            try {
                                TableProcessingOperations.deletePartialLoadDataIfExist((CarbonTable)this.carbonTable, (boolean)true);
                            }
                            catch (IOException e) {
                                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("carbondata Vacuum Rollback failed: %s", e.getMessage()), (Throwable)e);
                            }
                        }
                    });
                    return;
                }
                case CREATE_TABLE_AS: 
                case CREATE_TABLE: {
                    this.hdfsEnvironment.doAs(this.user, () -> {
                        if (this.tableStorageLocation.isPresent()) {
                            try {
                                CarbonUtil.dropDatabaseDirectory((String)this.tableStorageLocation.get());
                            }
                            catch (IOException | InterruptedException e) {
                                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("cabondata table storage cleanup: %s", e.getMessage()), (Throwable)e);
                            }
                        }
                    });
                    return;
                }
                case DROP_TABLE: {
                    return;
                }
                case ADD_COLUMN: 
                case DROP_COLUMN: 
                case RENAME_COLUMN: {
                    this.hdfsEnvironment.doAs(this.user, () -> this.revertAlterTableChanges());
                    return;
                }
                default: {
                    return;
                }
            }
        }
        catch (RuntimeException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("error in rollback, %s", e.getMessage()), (Throwable)e);
        }
        finally {
            super.rollback();
            this.releaseLocks();
        }
    }

    private LocationHandle getCarbonDataTableCreationPath(ConnectorSession session, ConnectorTableMetadata tableMetadata, HiveWriteUtils.OpertionType opertionType) throws PrestoException {
        Path targetPath = null;
        SchemaTableName finalSchemaTableName = tableMetadata.getTable();
        String finalSchemaName = finalSchemaTableName.getSchemaName();
        String tableName = finalSchemaTableName.getTableName();
        Optional<String> location = CarbondataTableProperties.getCarbondataLocation(tableMetadata.getProperties());
        String targetLocation = null;
        try {
            if (location.isPresent()) {
                if (!this.tableCreatesWithLocationAllowed) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Setting %s property is not allowed", "location"));
                }
                FileSystem fileSystem = this.hdfsEnvironment.getFileSystem(new HdfsEnvironment.HdfsContext(session, finalSchemaName), new Path(location.get()));
                targetLocation = fileSystem.getFileStatus(new Path(location.get())).getPath().toString();
                targetPath = this.getPath(new HdfsEnvironment.HdfsContext(session, finalSchemaName, tableName), targetLocation, false);
            } else {
                this.updateEmptyCarbondataTableStorePath(session, finalSchemaName);
                targetLocation = this.carbondataTableStore;
                targetLocation = targetLocation + File.separator + finalSchemaName + File.separator + tableName;
                targetPath = new Path(targetLocation);
            }
        }
        catch (IOException | IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Error %s store path %s ", e.getMessage(), targetLocation));
        }
        LocationHandle locationHandle = this.locationService.forNewTable(this.metastore, session, finalSchemaName, tableName, Optional.empty(), Optional.of(targetPath), opertionType);
        return locationHandle;
    }

    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, boolean ignoreExisting) {
        SchemaTableName localSchemaTableName = tableMetadata.getTable();
        String localSchemaName = localSchemaTableName.getSchemaName();
        String tableName = localSchemaTableName.getTableName();
        this.user = session.getUser();
        this.schemaName = localSchemaName;
        this.currentState = State.CREATE_TABLE;
        ArrayList<String> partitionedBy = new ArrayList<String>();
        ArrayList<SortingColumn> sortBy = new ArrayList<SortingColumn>();
        ArrayList<HiveColumnHandle> columnHandles = new ArrayList<HiveColumnHandle>();
        HashMap<String, String> tableProperties = new HashMap<String, String>();
        this.getParametersForCreateTable(session, tableMetadata, partitionedBy, sortBy, columnHandles, tableProperties);
        this.metastore.getDatabase(localSchemaName).orElseThrow(() -> new SchemaNotFoundException(localSchemaName));
        BaseStorageFormat hiveStorageFormat = CarbondataTableProperties.getCarbondataStorageFormat(tableMetadata.getProperties());
        LocationHandle locationHandle = this.getCarbonDataTableCreationPath(session, tableMetadata, HiveWriteUtils.OpertionType.CREATE_TABLE);
        Path targetPath = this.locationService.getQueryWriteInfo(locationHandle).getTargetPath();
        AbsoluteTableIdentifier finalAbsoluteTableIdentifier = AbsoluteTableIdentifier.from((String)targetPath.toString(), (CarbonTableIdentifier)new CarbonTableIdentifier(localSchemaName, tableName, UUID.randomUUID().toString()));
        this.hdfsEnvironment.doAs(session.getUser(), () -> {
            this.initialConfiguration = ConfigurationUtils.toJobConf((Configuration)this.hdfsEnvironment.getConfiguration(new HdfsEnvironment.HdfsContext(session, localSchemaName, tableName), new Path(locationHandle.getJsonSerializableTargetPath())));
            CarbondataMetadataUtils.createMetaDataFolderSchemaFile(this.hdfsEnvironment, session, columnHandles, finalAbsoluteTableIdentifier, partitionedBy, sortBy.stream().map(s -> s.getColumnName().toLowerCase(Locale.ENGLISH)).collect(Collectors.toList()), targetPath.toString(), this.initialConfiguration);
            this.tableStorageLocation = Optional.of(targetPath.toString());
            try {
                Map<String, String> serdeParameters = this.initSerDeProperties(tableName);
                Table localTable = CarbondataMetadata.buildTableObject((String)session.getQueryId(), (String)localSchemaName, (String)tableName, (String)session.getUser(), (List)columnHandles, (BaseStorageFormat)hiveStorageFormat, (List)partitionedBy, Optional.empty(), (Map)tableProperties, (Path)targetPath, (boolean)true, (String)this.prestoVersion, serdeParameters);
                PrincipalPrivileges principalPrivileges = MetastoreUtil.buildInitialPrivilegeSet((String)localTable.getOwner());
                HiveBasicStatistics basicStatistics = localTable.getPartitionColumns().isEmpty() ? HiveBasicStatistics.createZeroStatistics() : HiveBasicStatistics.createEmptyStatistics();
                this.metastore.createTable(session, localTable, principalPrivileges, Optional.empty(), ignoreExisting, new PartitionStatistics(basicStatistics, (Map)ImmutableMap.of()));
            }
            catch (RuntimeException ex) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Error: creating table: %s ", ex.getMessage()), (Throwable)ex);
            }
        });
    }

    /*
     * Unable to fully structure code
     */
    public void commit() {
        try {
            switch (1.$SwitchMap$io$hetu$core$plugin$carbondata$CarbondataMetadata$State[this.currentState.ordinal()]) {
                case 1: {
                    this.hdfsEnvironment.doAs(this.user, (GenericExceptionAction)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$commit$14(), ()Ljava/lang/Boolean;)((CarbondataMetadata)this));
                    super.commit();
                    ** break;
lbl8:
                    // 1 sources

                    break;
                }
                case 2: 
                case 3: {
                    this.hdfsEnvironment.doAs(this.user, (GenericExceptionAction)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$commit$15(), ()Ljava/lang/Boolean;)((CarbondataMetadata)this));
                    super.commit();
                    ** break;
lbl14:
                    // 1 sources

                    break;
                }
                case 4: {
                    this.hdfsEnvironment.doAs(this.user, (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$commit$16(), ()V)((CarbondataMetadata)this));
                    super.commit();
                    ** break;
lbl19:
                    // 1 sources

                    break;
                }
                case 7: {
                    super.commit();
                    this.hdfsEnvironment.doAs(this.user, (GenericExceptionAction)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$commit$17(), ()Ljava/lang/Boolean;)((CarbondataMetadata)this));
                    ** break;
lbl25:
                    // 1 sources

                    break;
                }
                case 6: {
                    super.commit();
                    ** break;
lbl29:
                    // 1 sources

                    break;
                }
                case 5: {
                    this.hdfsEnvironment.doAs(this.user, (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$commit$18(), ()V)((CarbondataMetadata)this));
                    super.commit();
                    ** break;
lbl34:
                    // 1 sources

                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    this.hdfsEnvironment.doAs(this.user, (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$commit$19(), ()V)((CarbondataMetadata)this));
                    super.commit();
                    ** break;
lbl39:
                    // 1 sources

                    break;
                }
                default: {
                    super.commit();
                    break;
                }
            }
        }
        catch (TableAlreadyExistsException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Error commit %s", new Object[]{e.getMessage()}), (Throwable)e);
        }
        catch (Exception e) {
            block18: {
                block19: {
                    if (!this.tableStorageLocation.isPresent()) break block18;
                    if (State.CREATE_TABLE == this.currentState) break block19;
                    if (State.CREATE_TABLE_AS != this.currentState) break block18;
                }
                this.hdfsEnvironment.doAs(this.user, (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$commit$20(java.lang.Exception ), ()V)((CarbondataMetadata)this, (Exception)e));
            }
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Error commit %s", new Object[]{e.getMessage()}), (Throwable)e);
        }
        finally {
            this.releaseLocks();
        }
        this.submitCleanupTasks();
    }

    public CarbondataTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        Objects.requireNonNull(tableName, "tableName is null");
        Optional finalTable = this.metastore.getTable(new HiveIdentity(session), tableName.getSchemaName(), tableName.getTableName());
        if (!finalTable.isPresent()) {
            return null;
        }
        if (CarbondataMetadata.getSourceTableNameFromSystemTable((SchemaTableName)tableName).isPresent()) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "Unexpected table present in Hive metastore: " + tableName);
        }
        MetastoreUtil.verifyOnline((SchemaTableName)tableName, Optional.empty(), (ProtectMode)MetastoreUtil.getProtectMode((Table)((Table)finalTable.get())), (Map)((Table)finalTable.get()).getParameters());
        return new CarbondataTableHandle(tableName.getSchemaName(), tableName.getTableName(), ((Table)finalTable.get()).getParameters(), HiveUtil.getPartitionKeyColumnHandles((Table)((Table)finalTable.get())), HiveBucketing.getHiveBucketHandle((Table)((Table)finalTable.get())));
    }

    private Optional<ConnectorOutputMetadata> finishUpdateAndDelete(ConnectorSession session, HiveInsertTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        ArrayList partitionUpdates = new ArrayList();
        Optional connectorOutputMetadata = super.finishInsert(session, (ConnectorInsertTableHandle)tableHandle, fragments, computedStatistics, partitionUpdates);
        Gson gson = new Gson();
        this.blockUpdateDetailsList = partitionUpdates.stream().map(PartitionUpdate::getMiscData).flatMap(Collection::stream).map(json -> (SegmentUpdateDetails)gson.fromJson(StringEscapeUtils.unescapeJson((String)json), SegmentUpdateDetails.class)).collect(Collectors.toList());
        this.hdfsEnvironment.doAs(this.user, () -> {
            if (this.blockUpdateDetailsList.size() > 0) {
                SegmentUpdateDetails[] segementDetailsList;
                CarbonTable finalCarbonTable = this.getCarbonTable(tableHandle.getSchemaName(), tableHandle.getTableName(), MetastoreUtil.getHiveSchema((Table)this.table.get()), this.initialConfiguration);
                SegmentUpdateStatusManager statusManager = new SegmentUpdateStatusManager(finalCarbonTable);
                for (SegmentUpdateDetails segementDetails : segementDetailsList = statusManager.getUpdateStatusDetails()) {
                    segementDetails.getDeletedRowsInBlock();
                }
            }
        });
        return connectorOutputMetadata;
    }

    private void updateEmptyCarbondataTableStorePath(ConnectorSession session, String schemaName) throws IOException {
        if (StringUtils.isEmpty((CharSequence)this.carbondataTableStore)) {
            Database database = (Database)this.metastore.getDatabase("default").orElseThrow(() -> new SchemaNotFoundException("default"));
            String tableStore = (String)database.getLocation().get();
            FileSystem fileSystem = this.hdfsEnvironment.getFileSystem(new HdfsEnvironment.HdfsContext(session, schemaName), new Path(tableStore));
            String targetLocation = fileSystem.getFileStatus(new Path(tableStore)).getPath().toString();
            this.carbondataTableStore = targetLocation.endsWith(File.separator) ? targetLocation + "carbon.store" : targetLocation + File.separator + "carbon.store";
        } else {
            FileSystem fileSystem = this.hdfsEnvironment.getFileSystem(new HdfsEnvironment.HdfsContext(session, schemaName), new Path(this.carbondataTableStore));
            this.carbondataTableStore = fileSystem.getFileStatus(new Path(this.carbondataTableStore)).getPath().toString();
        }
    }

    public void getParametersForCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, List<String> partitionedBy, List<SortingColumn> sortBy, List<HiveColumnHandle> columnHandles, Map<String, String> tableProperties) {
        SchemaTableName finalSchemaTableName = tableMetadata.getTable();
        String finalSchemaName = finalSchemaTableName.getSchemaName();
        String finalTableName = finalSchemaTableName.getTableName();
        partitionedBy.addAll(CarbondataTableProperties.getPartitionedBy(tableMetadata.getProperties()));
        sortBy.addAll(CarbondataTableProperties.getSortedBy(tableMetadata.getProperties()));
        Optional<HiveBucketProperty> bucketProperty = Optional.empty();
        columnHandles.addAll(this.getColumnHandles(tableMetadata, (Set)ImmutableSet.copyOf(partitionedBy), this.typeTranslator));
        tableProperties.putAll(this.getEmptyTableProperties(tableMetadata, bucketProperty, new HdfsEnvironment.HdfsContext(session, finalSchemaName, finalTableName)));
    }

    public CarbondataOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, Optional<ConnectorNewTableLayout> layout, RetryMode retryMode) {
        if (retryMode != RetryMode.NO_RETRIES) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Carbondata connector does not support create table with query retries enabled");
        }
        return this.beginCreateTable(session, tableMetadata, layout);
    }

    public CarbondataOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, Optional<ConnectorNewTableLayout> layout) {
        HiveStorageFormat tableStorageFormat;
        SchemaTableName finalSchemaTableName = tableMetadata.getTable();
        String finalSchemaName = finalSchemaTableName.getSchemaName();
        String finalTableName = finalSchemaTableName.getTableName();
        this.user = session.getUser();
        this.schemaName = finalSchemaName;
        this.currentState = State.CREATE_TABLE_AS;
        ArrayList<String> partitionedBy = new ArrayList<String>();
        ArrayList<SortingColumn> sortBy = new ArrayList<SortingColumn>();
        ArrayList<HiveColumnHandle> columnHandles = new ArrayList<HiveColumnHandle>();
        HashMap<String, String> tableProperties = new HashMap<String, String>();
        this.getParametersForCreateTable(session, tableMetadata, partitionedBy, sortBy, columnHandles, tableProperties);
        this.metastore.getDatabase(finalSchemaName).orElseThrow(() -> new SchemaNotFoundException(finalSchemaName));
        HiveStorageFormat partitionStorageFormat = tableStorageFormat = HiveStorageFormat.valueOf((String)"CARBON");
        ImmutableMap columnHandlesByName = Maps.uniqueIndex(columnHandles, HiveColumnHandle::getName);
        List partitionColumns = partitionedBy.stream().map(((Map)columnHandlesByName)::get).map(column -> new Column(column.getName(), column.getHiveType(), column.getComment())).collect(Collectors.toList());
        this.checkPartitionTypesSupported(partitionColumns);
        LocationHandle locationHandle = this.getCarbonDataTableCreationPath(session, tableMetadata, HiveWriteUtils.OpertionType.CREATE_TABLE_AS);
        Path targetPath = this.locationService.getTableWriteInfo(locationHandle, false).getTargetPath();
        AbsoluteTableIdentifier finalAbsoluteTableIdentifier = AbsoluteTableIdentifier.from((String)targetPath.toString(), (CarbonTableIdentifier)new CarbonTableIdentifier(finalSchemaName, finalTableName, UUID.randomUUID().toString()));
        this.hdfsEnvironment.doAs(session.getUser(), () -> {
            this.initialConfiguration = ConfigurationUtils.toJobConf((Configuration)this.hdfsEnvironment.getConfiguration(new HdfsEnvironment.HdfsContext(session, finalSchemaName, finalTableName), new Path(locationHandle.getJsonSerializableTargetPath())));
            CarbondataMetadataUtils.createMetaDataFolderSchemaFile(this.hdfsEnvironment, session, columnHandles, finalAbsoluteTableIdentifier, partitionedBy, sortBy.stream().map(s -> s.getColumnName().toLowerCase(Locale.ENGLISH)).collect(Collectors.toList()), targetPath.toString(), this.initialConfiguration);
            this.tableStorageLocation = Optional.of(targetPath.toString());
            Path outputPath = new Path(locationHandle.getJsonSerializableTargetPath());
            Properties schema = this.readSchemaForCarbon(finalSchemaName, finalTableName, targetPath, columnHandles, partitionColumns);
            this.setupCommitWriter(schema, outputPath, this.initialConfiguration, false);
        });
        try {
            CarbondataOutputTableHandle result = new CarbondataOutputTableHandle(finalSchemaName, finalTableName, columnHandles, this.metastore.generatePageSinkMetadata(new HiveIdentity(session), finalSchemaTableName), locationHandle, tableStorageFormat, partitionStorageFormat, partitionedBy, Optional.empty(), session.getUser(), tableProperties, (Map<String, String>)ImmutableMap.of((Object)"hetu.carbondata.states.encodedLoadModel", (Object)this.jobContext.getConfiguration().get(LOAD_MODEL)));
            LocationService.WriteInfo writeInfo = this.locationService.getQueryWriteInfo(locationHandle);
            this.metastore.declareIntentionToWrite(session, writeInfo.getWriteMode(), writeInfo.getWritePath(), finalSchemaTableName);
            return result;
        }
        catch (RuntimeException ex) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Error: creating table: %s ", ex.getMessage()), (Throwable)ex);
        }
    }

    public Optional<ConnectorOutputMetadata> finishCreateTable(ConnectorSession session, ConnectorOutputTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        HiveOutputTableHandle handle = (HiveOutputTableHandle)tableHandle;
        this.setExternalTable(true);
        Map<String, String> serdeParameters = this.initSerDeProperties(handle.getTableName());
        Optional connectorOutputMetadata = super.finishCreateTable(session, tableHandle, fragments, computedStatistics, serdeParameters);
        this.writeSegmentFileAndSetLoadModel();
        return connectorOutputMetadata;
    }

    private void initLocksForCurrentTable() {
        this.metadataLock = CarbonLockFactory.getCarbonLockObj((AbsoluteTableIdentifier)this.carbonTable.getAbsoluteTableIdentifier(), (String)"meta.lock");
        this.compactionLock = CarbonLockFactory.getCarbonLockObj((AbsoluteTableIdentifier)this.carbonTable.getAbsoluteTableIdentifier(), (String)"compaction.lock");
        this.updateLock = CarbonLockFactory.getCarbonLockObj((AbsoluteTableIdentifier)this.carbonTable.getAbsoluteTableIdentifier(), (String)"update.lock");
        this.carbonDropTableLock = CarbonLockFactory.getCarbonLockObj((AbsoluteTableIdentifier)this.carbonTable.getAbsoluteTableIdentifier(), (String)"droptable.lock");
    }

    private void takeLocks(State state) throws PrestoException {
        this.initLocksForCurrentTable();
        try {
            switch (state) {
                case UPDATE: 
                case DELETE: {
                    this.takeMetadataLock();
                    this.takeUpdateCompactionLock();
                    break;
                }
                case DROP_TABLE: {
                    this.takeDropTableLock();
                    break;
                }
                case VACUUM: {
                    this.takeUpdateCompactionLock();
                    break;
                }
                default: {
                    LOG.error((Object)("Should not take locks for " + (Object)((Object)state) + " state."));
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Should not take locks in " + (Object)((Object)state) + " state");
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Exception in " + (Object)((Object)state) + " operation."), (Throwable)e);
            this.releaseLocks();
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Error while taking locks", (Throwable)e);
        }
    }

    private void takeMetadataLock() throws RuntimeException {
        boolean lockStatus = this.metadataLock.lockWithRetries();
        if (!lockStatus) {
            throw new RuntimeException("Unable to get metadata lock. Please try after some time");
        }
        LOG.info((Object)"Successfully able to get the table metadata file lock");
    }

    private void takeDropTableLock() throws RuntimeException {
        this.takeMetadataLock();
        boolean lockStatus = this.carbonDropTableLock.lockWithRetries();
        if (!lockStatus) {
            throw new RuntimeException("Unable to get Drop Table lock. Please try after some time");
        }
        LOG.info((Object)"Successfully able to get the drop table lock");
    }

    private void takeUpdateCompactionLock() throws RuntimeException {
        try {
            if (!this.updateLock.lockWithRetries() || !this.compactionLock.lockWithRetries()) {
                throw new RuntimeException("Unable to get update and compaction locks");
            }
            LOG.info((Object)"Successfully able to get update and compaction locks");
        }
        catch (RuntimeException e) {
            LOG.error((Object)"Exception in taking update and compaction locks", (Throwable)e);
            this.releaseLocks();
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Error while taking locks", (Throwable)e);
        }
    }

    private void releaseLocks() {
        if (null != this.updateLock) {
            this.updateLock.unlock();
        }
        if (null != this.compactionLock) {
            this.compactionLock.unlock();
        }
        if (null != this.carbonDropTableLock) {
            CarbonLockUtil.fileUnlock((ICarbonLock)this.carbonDropTableLock, (String)"droptable.lock");
        }
        if (null != this.metadataLock) {
            CarbonLockUtil.fileUnlock((ICarbonLock)this.metadataLock, (String)"meta.lock");
        }
    }

    private void commitUpdateAndDelete() throws IOException {
        boolean updateSegmentStatusSuccess = CarbonUpdateUtil.updateSegmentStatus(this.blockUpdateDetailsList, (CarbonTable)this.carbonTable, (String)this.timeStamp.toString(), (boolean)false);
        List segmentFilesToBeUpdated = this.blockUpdateDetailsList.stream().map(SegmentUpdateDetails::getSegmentName).map(Segment::new).collect(Collectors.toList());
        ArrayList<Segment> finalSegmentFilesToBeUpdatedLatest = new ArrayList<Segment>();
        List segmentFilesToBeDeleted = this.blockUpdateDetailsList.stream().filter(segmentUpdateDetails -> segmentUpdateDetails.getSegmentStatus() != null && segmentUpdateDetails.getSegmentStatus().equals((Object)SegmentStatus.MARKED_FOR_DELETE)).map(SegmentUpdateDetails::getSegmentName).map(Segment::new).collect(Collectors.toList());
        for (Segment segment : segmentFilesToBeUpdated) {
            String file = SegmentFileStore.writeSegmentFile((CarbonTable)this.carbonTable, (String)segment.getSegmentNo(), (String)this.timeStamp.toString());
            finalSegmentFilesToBeUpdatedLatest.add(new Segment(segment.getSegmentNo(), file));
        }
        if (!updateSegmentStatusSuccess || !CarbonUpdateUtil.updateTableMetadataStatus(new HashSet(segmentFilesToBeUpdated), (CarbonTable)this.carbonTable, (String)this.timeStamp.toString(), (boolean)true, segmentFilesToBeDeleted, finalSegmentFilesToBeUpdatedLatest, (String)"")) {
            CarbonUpdateUtil.cleanStaleDeltaFiles((CarbonTable)this.carbonTable, (String)this.timeStamp.toString());
        }
    }

    protected void finishInsertOverwrite(ConnectorSession session, HiveInsertTableHandle handle, Table table, PartitionUpdate partitionUpdate, PartitionStatistics partitionStatistics) {
        this.metastore.finishInsertIntoExistingTable(session, handle.getSchemaName(), handle.getTableName(), partitionUpdate.getWritePath(), partitionUpdate.getFileNames(), partitionStatistics, HiveACIDWriteType.INSERT_OVERWRITE, false);
        this.markSegmentsForDelete(session, table);
    }

    protected void finishInsertInNewPartition(ConnectorSession session, HiveInsertTableHandle handle, Table table, Map<String, Type> columnTypes, PartitionUpdate partitionUpdate, Map<List<String>, ComputedStatistics> partitionComputedStatistics, HiveACIDWriteType acidWriteType) {
        if (partitionUpdate.getUpdateMode() == PartitionUpdate.UpdateMode.OVERWRITE) {
            List partitionValues = HiveUtil.toPartitionValues((String)partitionUpdate.getName());
            PartitionStatistics partitionStatistics = this.createPartitionStatistics(session, partitionUpdate.getStatistics(), columnTypes, CarbondataMetadata.getColumnStatistics(partitionComputedStatistics, (List)partitionValues));
            this.metastore.finishInsertIntoExistingPartition(session, handle.getSchemaName(), handle.getTableName(), partitionValues, partitionUpdate.getWritePath(), partitionUpdate.getFileNames(), partitionStatistics, acidWriteType, false);
        } else if (partitionUpdate.getUpdateMode() == PartitionUpdate.UpdateMode.APPEND) {
            Partition partition = this.buildPartitionObject(session, table, partitionUpdate);
            if (!partition.getStorage().getStorageFormat().getInputFormat().equals(handle.getPartitionStorageFormat().getInputFormat()) && HiveSessionProperties.isRespectTableFormat((ConnectorSession)session)) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CONCURRENT_MODIFICATION_DETECTED, "Partition format changed during insert");
            }
            PartitionStatistics partitionStatistics = this.createPartitionStatistics(session, partitionUpdate.getStatistics(), columnTypes, CarbondataMetadata.getColumnStatistics(partitionComputedStatistics, (List)partition.getValues()));
            this.metastore.addPartition(session, handle.getSchemaName(), handle.getTableName(), partition, partitionUpdate.getWritePath(), partitionStatistics, acidWriteType, Optional.empty(), false);
        }
    }

    private void markSegmentsForDelete(ConnectorSession session, Table table) {
        this.hdfsEnvironment.doAs(session.getUser(), () -> {
            try {
                Properties hiveschema = MetastoreUtil.getHiveSchema((Table)table);
                Configuration configuration = this.jobContext.getConfiguration();
                configuration.set(SET_OVERWRITE, "false");
                CarbonLoadModel loadModel = HiveCarbonUtil.getCarbonLoadModel((Properties)hiveschema, (Configuration)configuration);
                LoadMetadataDetails loadMetadataDetails = loadModel.getCurrentLoadMetadataDetail();
                loadModel.setSegmentId(loadMetadataDetails.getLoadName());
                CarbonLoaderUtil.recordNewLoadMetadata((LoadMetadataDetails)loadMetadataDetails, (CarbonLoadModel)loadModel, (boolean)false, (boolean)true);
            }
            catch (IOException e) {
                LOG.error((Object)"Error occurred while committing the insert job.", (Throwable)e);
                throw new RuntimeException(e);
            }
        });
    }

    private Properties readSchemaForCarbon(String schemaName, String tableName, Path targetPath, List<HiveColumnHandle> columnHandles, List<Column> partitionColumns) {
        ImmutableList.Builder dataColumns = ImmutableList.builder();
        for (HiveColumnHandle column : columnHandles) {
            HiveType hiveType = column.getHiveType();
            if (column.isPartitionKey()) continue;
            dataColumns.add((Object)new HiveWriterFactory.DataColumn(column.getName(), hiveType));
        }
        ImmutableList dataColumnsList = dataColumns.build();
        Properties schema = new Properties();
        schema.setProperty("columns", dataColumnsList.stream().map(HiveWriterFactory.DataColumn::getName).collect(Collectors.joining(",")));
        schema.setProperty("columns.types", dataColumnsList.stream().map(HiveWriterFactory.DataColumn::getHiveType).map(HiveType::getHiveTypeName).map(HiveTypeName::toString).collect(Collectors.joining(":")));
        String name = schemaName + "." + tableName;
        schema.setProperty("name", name);
        schema.setProperty("location", targetPath.toString());
        MetastoreUtil.insertPartitionIntoProperties(partitionColumns, (Properties)schema);
        return schema;
    }

    protected void validateBucketColumns(ConnectorTableMetadata tableMetadata) {
    }

    protected void validateCsvColumns(ConnectorTableMetadata tableMetadata) {
    }

    public Optional<ConnectorNewTableLayout> getNewTableLayout(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        return Optional.empty();
    }

    public void dropTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        HiveTableHandle handle = (HiveTableHandle)tableHandle;
        Optional target = this.metastore.getTable(new HiveIdentity(session), handle.getSchemaName(), handle.getTableName());
        if (!target.isPresent()) {
            throw new TableNotFoundException(handle.getSchemaTableName());
        }
        if (((Table)target.get()).getPartitionColumns().size() > 0) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Operations on Partitioned CarbonTables is not supported");
        }
        this.user = session.getUser();
        this.schemaName = ((Table)target.get()).getDatabaseName();
        this.currentState = State.DROP_TABLE;
        this.tableStorageLocation = Optional.of(((Table)target.get()).getStorage().getLocation());
        try {
            this.hdfsEnvironment.getFileSystem(new HdfsEnvironment.HdfsContext(session, ((Table)target.get()).getDatabaseName()), new Path(this.tableStorageLocation.get()));
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "hdfsEnvironment.getFileSystem", (Throwable)e);
        }
        try {
            this.hdfsEnvironment.doAs(session.getUser(), () -> {
                this.metastore.dropTable(session, handle.getSchemaName(), handle.getTableName());
                JobConf finalInitialConfiguration = ConfigurationUtils.toJobConf((Configuration)this.hdfsEnvironment.getConfiguration(new HdfsEnvironment.HdfsContext(session, handle.getSchemaName(), handle.getTableName()), new Path(this.tableStorageLocation.get())));
                Properties schema = MetastoreUtil.getHiveSchema((Table)((Table)target.get()));
                schema.setProperty("tablePath", this.tableStorageLocation.get());
                this.carbonTable = this.getCarbonTable(handle.getSchemaName(), handle.getTableName(), schema, (Configuration)finalInitialConfiguration);
                this.takeLocks(State.DROP_TABLE);
                AbsoluteTableIdentifier identifier = this.carbonTable.getAbsoluteTableIdentifier();
                if (SegmentStatusManager.isLoadInProgressInTable((CarbonTable)this.carbonTable).booleanValue()) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Table insert or overwrite in Progress");
                }
                try {
                    this.carbonTable = this.getCarbonTable(handle.getSchemaName(), handle.getTableName(), schema, (Configuration)finalInitialConfiguration);
                }
                catch (RuntimeException e) {
                    try {
                        CarbonUtil.dropDatabaseDirectory((String)this.tableStorageLocation.get());
                    }
                    catch (IOException | InterruptedException ex) {
                        LOG.error((Object)String.format("Failed carbon cleanup db directory:  %s", ex.getMessage()));
                    }
                    throw new TableNotFoundException(handle.getSchemaTableName());
                }
                this.carbondataTableReader.deleteTableFromCarbonCache(new SchemaTableName(this.schemaName, ((Table)target.get()).getTableName()));
            });
        }
        catch (PrestoException e) {
            this.releaseLocks();
            throw e;
        }
        catch (RuntimeException ex) {
            this.releaseLocks();
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Error in drop table %s", ex.getMessage()), (Throwable)ex);
        }
    }

    protected void verifyStorageFormatForCatalog(StorageFormat storageFormat) {
        Objects.requireNonNull(storageFormat, "Storage format is null");
        if (!storageFormat.getInputFormat().contains("CarbonInputFormat")) {
            String sf = storageFormat.getInputFormat();
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Tables with %s are not supported by Carbondata connector", sf.substring(sf.lastIndexOf(".") + 1)));
        }
    }

    private Map<String, String> initSerDeProperties(String tableName) {
        HashMap<String, String> serdeParameters = new HashMap<String, String>();
        serdeParameters.put("dbname", this.schemaName);
        serdeParameters.put("tablename", tableName);
        serdeParameters.put("isExternal", "false");
        serdeParameters.put("path", this.tableStorageLocation.get());
        serdeParameters.put("tablePath", this.tableStorageLocation.get());
        serdeParameters.put("isTransactional", "true");
        serdeParameters.put("isVisible", "true");
        serdeParameters.put("serialization.format", "1");
        return serdeParameters;
    }

    public void addColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnMetadata column) {
        this.currentState = State.ADD_COLUMN;
        this.updateSchemaInfo(session, tableHandle, column, null, null);
        super.addColumn(session, tableHandle, column);
    }

    public void renameColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle source, String target) {
        this.currentState = State.RENAME_COLUMN;
        this.updateSchemaInfo(session, tableHandle, null, source, target);
        super.renameColumn(session, tableHandle, source, target);
    }

    public void dropColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle column) {
        this.currentState = State.DROP_COLUMN;
        this.updateSchemaInfo(session, tableHandle, null, column, null);
        super.dropColumn(session, tableHandle, column);
    }

    private void updateSchemaInfo(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnMetadata column, ColumnHandle source, String target) {
        SchemaEvolutionEntry schemaEvolutionEntry;
        HiveTableHandle handle = (HiveTableHandle)tableHandle;
        this.table = this.metastore.getTable(new HiveIdentity(session), handle.getSchemaName(), handle.getTableName());
        String tablePath = this.table.get().getStorage().getLocation();
        this.hdfsEnvironment.doAs(this.user, () -> {
            this.initialConfiguration = ConfigurationUtils.toJobConf((Configuration)this.hdfsEnvironment.getConfiguration(new HdfsEnvironment.HdfsContext(session, handle.getSchemaName(), handle.getTableName()), new Path(tablePath)));
            Properties schema = MetastoreUtil.getHiveSchema((Table)this.table.get());
            schema.setProperty("tablePath", tablePath);
            this.carbonTable = this.getCarbonTable(handle.getSchemaName(), handle.getTableName(), schema, this.initialConfiguration);
        });
        this.acquireLocksForAlter();
        this.schemaTableName = handle.getSchemaTableName();
        this.absoluteTableIdentifier = AbsoluteTableIdentifier.from((String)tablePath, (String)handle.getTableName(), (String)handle.getSchemaName());
        this.tableInfo = this.carbonTable.getTableInfo();
        switch (this.currentState) {
            case ADD_COLUMN: {
                schemaEvolutionEntry = this.updateSchemaInfoAddColumn(column);
                break;
            }
            case RENAME_COLUMN: {
                schemaEvolutionEntry = this.updateSchemaInfoRenameColumn(source, target);
                break;
            }
            case DROP_TABLE: {
                schemaEvolutionEntry = this.updateSchemaInfoDropColumn(source);
                break;
            }
            default: {
                return;
            }
        }
        if (schemaEvolutionEntry != null) {
            this.tableInfo.getFactTable().getSchemaEvolution().getSchemaEvolutionEntryList().add(schemaEvolutionEntry);
        }
    }

    private SchemaEvolutionEntry updateSchemaInfoAddColumn(ColumnMetadata column) {
        HiveColumnHandle columnHandle = new HiveColumnHandle(column.getName(), HiveType.toHiveType((TypeTranslator)this.typeTranslator, (Type)column.getType()), column.getType().getTypeSignature(), this.tableInfo.getFactTable().getListOfColumns().size(), HiveColumnHandle.ColumnType.REGULAR, Optional.empty());
        TableSchema tableSchema = this.tableInfo.getFactTable();
        List tableColumns = tableSchema.getListOfColumns();
        int currentSchemaOrdinal = tableColumns.stream().max(Comparator.comparing(ColumnSchema::getSchemaOrdinal)).orElseThrow(NoSuchElementException::new).getSchemaOrdinal() + 1;
        ArrayList<ColumnSchema> longStringColumns = new ArrayList<ColumnSchema>();
        List allColumns = tableColumns.stream().filter(cols -> cols.isDimensionColumn() && !cols.getDataType().isComplexType() && cols.getSchemaOrdinal() != -1 && cols.getDataType() != DataTypes.VARCHAR).collect(Collectors.toList());
        TableSchemaBuilder schemaBuilder = new TableSchemaBuilder();
        ArrayList<ColumnSchema> columnSchemas = new ArrayList<ColumnSchema>();
        ColumnSchema newColumn = schemaBuilder.addColumn(new StructField(columnHandle.getName(), CarbondataHetuFilterUtil.spi2CarbondataTypeMapper(columnHandle)), null, false, false);
        newColumn.setSchemaOrdinal(currentSchemaOrdinal);
        columnSchemas.add(newColumn);
        if (newColumn.getDataType() == DataTypes.VARCHAR) {
            longStringColumns.add(newColumn);
        } else if (newColumn.isDimensionColumn()) {
            allColumns.add(newColumn);
        }
        allColumns.addAll(tableColumns.stream().filter(cols -> cols.isDimensionColumn() && cols.getDataType() == DataTypes.VARCHAR).collect(Collectors.toList()));
        allColumns.addAll(longStringColumns);
        allColumns.addAll(tableColumns.stream().filter(cols -> cols.isDimensionColumn() && (cols.isComplexColumn() || cols.getSchemaOrdinal() == -1)).collect(Collectors.toList()));
        allColumns.addAll(tableColumns.stream().filter(cols -> !cols.isDimensionColumn()).collect(Collectors.toList()));
        if (!newColumn.isDimensionColumn()) {
            allColumns.add(newColumn);
        }
        allColumns.stream().filter(cols -> !cols.isInvisible()).collect(Collectors.groupingBy(ColumnSchema::getColumnName)).forEach((columnName, schemaList) -> {
            if (schemaList.size() > 2) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Duplicate columns found", new Object[0]));
            }
        });
        if (newColumn.isComplexColumn()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Complex column cannot be added", new Object[0]));
        }
        List finalAllColumns = allColumns;
        allColumns.stream().forEach(columnSchema -> {
            List colWithSameId = finalAllColumns.stream().filter(x -> x.getColumnUniqueId().equals(columnSchema.getColumnUniqueId())).collect(Collectors.toList());
            if (colWithSameId.size() > 1) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Two columns can not have same columnId", new Object[0]));
            }
        });
        if (this.tableInfo.getFactTable().getPartitionInfo() != null) {
            List par = this.tableInfo.getFactTable().getPartitionInfo().getColumnSchemaList();
            allColumns = allColumns.stream().filter(cols -> !par.contains(cols)).collect(Collectors.toList());
            allColumns.addAll(par);
        }
        tableSchema.setListOfColumns(allColumns);
        this.tableInfo.setLastUpdatedTime(this.timeStamp.longValue());
        this.tableInfo.setFactTable(tableSchema);
        SchemaEvolutionEntry schemaEvolutionEntry = new SchemaEvolutionEntry();
        schemaEvolutionEntry.setTimeStamp(this.timeStamp.longValue());
        schemaEvolutionEntry.setAdded(columnSchemas);
        return schemaEvolutionEntry;
    }

    private SchemaEvolutionEntry updateSchemaInfoRenameColumn(ColumnHandle source, String target) {
        HiveColumnHandle oldColumnHandle = (HiveColumnHandle)source;
        String oldColumnName = oldColumnHandle.getColumnName();
        String newColumnName = target;
        if (!this.carbonTable.canAllow(this.carbonTable, TableOperation.ALTER_COLUMN_RENAME, new Object[]{oldColumnHandle.getName()})) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Alter table rename column is  not supported for index indexschema", new Object[0]));
        }
        TableSchema tableSchema = this.tableInfo.getFactTable();
        List tableColumns = tableSchema.getListOfColumns();
        if (!tableColumns.stream().map(cols -> cols.getColumnName()).collect(Collectors.toList()).contains(oldColumnHandle.getName())) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Column " + oldColumnHandle.getName() + "does not exist in " + this.carbonTable.getDatabaseName() + "." + this.carbonTable.getTableName(), new Object[0]));
        }
        List carbonColumns = this.carbonTable.getCreateOrderColumn().stream().filter(cols -> !cols.isInvisible()).map(cols -> cols.getColumnSchema()).collect(Collectors.toList());
        ColumnSchema oldCarbonColumn = carbonColumns.stream().filter(cols -> cols.getColumnName().equalsIgnoreCase(oldColumnName)).findFirst().get();
        this.validateColumnsForRenaming(oldCarbonColumn);
        TableSchemaBuilder schemaBuilder = new TableSchemaBuilder();
        ColumnSchema deletedColumn = schemaBuilder.addColumn(new StructField(oldColumnHandle.getName(), CarbondataHetuFilterUtil.spi2CarbondataTypeMapper(oldColumnHandle)), null, false, false);
        SchemaEvolutionEntry schemaEvolutionEntry = new SchemaEvolutionEntry();
        tableColumns.forEach(cols -> {
            if (cols.getColumnName().equalsIgnoreCase(oldColumnName)) {
                cols.setColumnName(newColumnName);
                schemaEvolutionEntry.setTimeStamp(this.timeStamp.longValue());
                schemaEvolutionEntry.setAdded(Arrays.asList(cols));
                schemaEvolutionEntry.setRemoved(Arrays.asList(deletedColumn));
            }
        });
        Map tableProperties = this.tableInfo.getFactTable().getTableProperties();
        tableProperties.forEach((tablePropertyKey, tablePropertyValue) -> {
            if (tablePropertyKey.equalsIgnoreCase(oldColumnName)) {
                tableProperties.put(tablePropertyKey, newColumnName);
            }
        });
        this.tableInfo.setLastUpdatedTime(System.currentTimeMillis());
        this.tableInfo.setFactTable(tableSchema);
        return schemaEvolutionEntry;
    }

    private SchemaEvolutionEntry updateSchemaInfoDropColumn(ColumnHandle column) {
        HiveColumnHandle columnHandle = (HiveColumnHandle)column;
        TableSchema tableSchema = this.tableInfo.getFactTable();
        List tableColumns = tableSchema.getListOfColumns();
        int currentSchemaOrdinal = tableColumns.stream().max(Comparator.comparing(ColumnSchema::getSchemaOrdinal)).orElseThrow(NoSuchElementException::new).getSchemaOrdinal() + 1;
        TableSchemaBuilder schemaBuilder = new TableSchemaBuilder();
        ArrayList<ColumnSchema> columnSchemas = new ArrayList<ColumnSchema>();
        ColumnSchema newColumn = schemaBuilder.addColumn(new StructField(columnHandle.getColumnName(), CarbondataHetuFilterUtil.spi2CarbondataTypeMapper(columnHandle)), null, false, false);
        newColumn.setSchemaOrdinal(currentSchemaOrdinal);
        columnSchemas.add(newColumn);
        PartitionInfo partitionInfo = this.tableInfo.getFactTable().getPartitionInfo();
        if (partitionInfo != null) {
            List partitionColumnSchemaList = this.tableInfo.getFactTable().getPartitionInfo().getColumnSchemaList().stream().map(cols -> cols.getColumnName()).collect(Collectors.toList());
            if (partitionColumnSchemaList.stream().anyMatch(partitionColumn -> partitionColumn.equals(newColumn.getColumnName()))) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Partition columns cannot be dropped");
            }
            if (tableColumns.stream().filter(cols -> !cols.getColumnName().equals(newColumn.getColumnName())).map(cols -> cols.getColumnName()).equals(partitionColumnSchemaList)) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Cannot have table with all columns as partition columns");
            }
        }
        if (!tableColumns.stream().filter(cols -> cols.getColumnName().equals(newColumn.getColumnName())).collect(Collectors.toList()).isEmpty()) {
            if (newColumn.isComplexColumn()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Complex column cannot be dropped");
            }
        } else {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Cannot have table with all columns as partition columns");
        }
        this.tableInfo.setLastUpdatedTime(System.currentTimeMillis());
        this.tableInfo.setFactTable(tableSchema);
        SchemaEvolutionEntry schemaEvolutionEntry = new SchemaEvolutionEntry();
        schemaEvolutionEntry.setTimeStamp(this.timeStamp.longValue());
        schemaEvolutionEntry.setRemoved(columnSchemas);
        return schemaEvolutionEntry;
    }

    private void revertAlterTableChanges() {
        String tableName = this.absoluteTableIdentifier.getTableName();
        String databaseName = this.absoluteTableIdentifier.getDatabaseName();
        TableInfo finalTableInfo = this.carbonTable.getTableInfo();
        List evolutionEntryList = finalTableInfo.getFactTable().getSchemaEvolution().getSchemaEvolutionEntryList();
        Long updatedTime = ((SchemaEvolutionEntry)evolutionEntryList.get(evolutionEntryList.size() - 1)).getTimeStamp();
        LOG.info((Object)("Reverting changes for " + databaseName + "." + tableName));
        List addedSchemas = ((SchemaEvolutionEntry)evolutionEntryList.get(evolutionEntryList.size() - 1)).getAdded();
        List removedSchemas = ((SchemaEvolutionEntry)evolutionEntryList.get(evolutionEntryList.size() - 1)).getRemoved();
        if (updatedTime == this.timeStamp) {
            switch (this.currentState) {
                case ADD_COLUMN: {
                    this.carbonTable.getTableInfo().getFactTable().getListOfColumns().removeAll(addedSchemas);
                    break;
                }
                case DROP_COLUMN: {
                    finalTableInfo.getFactTable().getListOfColumns().forEach(cols -> removedSchemas.forEach(removedCols -> {
                        if (cols.isInvisible() && removedCols.getColumnUniqueId().equals(cols.getColumnUniqueId())) {
                            cols.setInvisible(false);
                        }
                    }));
                    break;
                }
            }
            evolutionEntryList.remove(evolutionEntryList.size() - 1);
            this.writeSchemaFile();
        }
    }

    private void writeSchemaFile() {
        try {
            String schemaFilePath = CarbonTablePath.getSchemaFilePath((String)this.table.get().getStorage().getLocation());
            ThriftWrapperSchemaConverterImpl schemaConverter = new ThriftWrapperSchemaConverterImpl();
            ThriftWriter thriftWriter = new ThriftWriter(schemaFilePath, false);
            thriftWriter.open(FileWriteOperation.OVERWRITE);
            thriftWriter.write((TBase)schemaConverter.fromWrapperToExternalTableInfo(this.tableInfo, this.absoluteTableIdentifier.getTableName(), this.absoluteTableIdentifier.getDatabaseName()));
            thriftWriter.close();
            FileFactory.getCarbonFile((String)schemaFilePath).setLastModifiedTime(this.timeStamp.longValue());
            this.carbondataTableReader.deleteTableFromCarbonCache(new SchemaTableName(this.absoluteTableIdentifier.getDatabaseName(), this.absoluteTableIdentifier.getTableName()));
            CarbonMetadata.getInstance().removeTable(this.absoluteTableIdentifier.getTablePath(), this.absoluteTableIdentifier.getDatabaseName());
            CarbonMetadata.getInstance().loadTableMetadata(this.tableInfo);
            LOG.info((Object)"Schema file written");
        }
        catch (IOException e) {
            this.releaseLocks();
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Error while writing to schema file", e));
        }
    }

    private void acquireLocksForAlter() {
        this.metadataLock = CarbonLockFactory.getCarbonLockObj((AbsoluteTableIdentifier)this.carbonTable.getAbsoluteTableIdentifier(), (String)"meta.lock");
        this.compactionLock = CarbonLockFactory.getCarbonLockObj((AbsoluteTableIdentifier)this.carbonTable.getAbsoluteTableIdentifier(), (String)"compaction.lock");
        try {
            boolean lockStatus = this.metadataLock.lockWithRetries();
            if (!lockStatus) {
                throw new Exception("Table is already locked");
            }
            LOG.info((Object)"Successfully able to get the table metadata file lock");
            if (!this.compactionLock.lockWithRetries()) {
                throw new RuntimeException("Unable to get compaction locks");
            }
            LOG.info((Object)"Successfully able to get compaction lock");
        }
        catch (Exception e) {
            LOG.error((Object)"Exception in alter operation", (Throwable)e);
            this.releaseLocks();
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Error while taking locks", (Throwable)e);
        }
    }

    private void validateColumnsForRenaming(ColumnSchema oldColumn) {
        if (this.carbonTable != null) {
            List partitionColumns;
            if (oldColumn.isComplexColumn()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Rename column is not supported for complex datatype", new Object[0]));
            }
            if (null != this.carbonTable.getPartitionInfo() && !(partitionColumns = this.carbonTable.getPartitionInfo().getColumnSchemaList()).stream().filter(cols -> cols.getColumnName().equalsIgnoreCase(oldColumn.getColumnName())).collect(Collectors.toList()).isEmpty()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Cannot rename a partition column", new Object[0]));
            }
        }
    }

    private void writeSegmentFileAndSetLoadModel() {
        this.hdfsEnvironment.doAs(this.user, () -> {
            try {
                this.carbonLoadModel = MapredCarbonOutputFormat.getLoadModel((Configuration)this.initialConfiguration);
                ThreadLocalSessionInfo.unsetAll();
                CarbondataMetadataUtils.writeSegmentFile(this.carbonLoadModel.getCarbonDataLoadSchema().getCarbonTable(), this.carbonLoadModel.getSegmentId(), String.valueOf(this.carbonLoadModel.getFactTimeStamp()));
                CarbonTableOutputFormat.setLoadModel((Configuration)this.initialConfiguration, (CarbonLoadModel)this.carbonLoadModel);
            }
            catch (IOException e) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Error in write segment ", (Throwable)e);
            }
        });
    }

    private void commitVacuum() throws PrestoException {
        try {
            if (this.segmentsMerged.size() != 0) {
                for (List<LoadMetadataDetails> segmentsMergedList : this.segmentsMerged) {
                    String mergedLoadNumber = CarbonDataMergerUtil.getMergedLoadName(segmentsMergedList).split("_")[1];
                    String segmentFileName = SegmentFileStore.writeSegmentFile((CarbonTable)this.carbonTable, (String)mergedLoadNumber, (String)String.valueOf(this.carbonLoadModel.getFactTimeStamp()));
                    boolean updateMergeStatus = CarbonDataMergerUtil.updateLoadMetadataWithMergeStatus(segmentsMergedList, (String)this.carbonTable.getMetadataPath(), (String)mergedLoadNumber, (CarbonLoadModel)this.carbonLoadModel, (CompactionType)(this.compactionType.equals("MAJOR") ? CompactionType.MAJOR : CompactionType.MINOR), (String)segmentFileName, null);
                    if (updateMergeStatus) continue;
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Error in updating load metadata with merge status");
                }
            }
        }
        catch (IOException | NoSuchMVException e) {
            LOG.error((Object)"Error in updating table status file after compaction");
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Error in updating table status file after compaction");
        }
    }

    protected ConnectorTableMetadata doGetTableMetadata(ConnectorSession session, SchemaTableName tableName) {
        Optional finalTable = this.metastore.getTable(new HiveIdentity(session), tableName.getSchemaName(), tableName.getTableName());
        if (!finalTable.isPresent() || ((Table)finalTable.get()).getTableType().equals(TableType.VIRTUAL_VIEW.name())) {
            throw new TableNotFoundException(tableName);
        }
        Function metadataGetter = CarbondataMetadata.columnMetadataGetter((Table)((Table)finalTable.get()), (TypeManager)this.typeManager);
        ImmutableList.Builder columns = ImmutableList.builder();
        for (HiveColumnHandle columnHandle : HiveUtil.hiveColumnHandles((Table)((Table)finalTable.get()))) {
            columns.add(metadataGetter.apply(columnHandle));
        }
        ImmutableMap.Builder properties = ImmutableMap.builder();
        properties.put((Object)"location", (Object)((Table)finalTable.get()).getStorage().getLocation());
        properties.put((Object)"format", (Object)CarbondataStorageFormat.CARBON);
        List partitionedBy = ((Table)finalTable.get()).getPartitionColumns().stream().map(Column::getName).collect(Collectors.toList());
        if (!partitionedBy.isEmpty()) {
            properties.put((Object)"partitioned_by", partitionedBy);
        }
        Optional comment = Optional.ofNullable(((Table)finalTable.get()).getParameters().get("comment"));
        ImmutableList.Builder immutableColumns = ImmutableList.builder();
        for (HiveColumnHandle columnHandle : HiveUtil.hiveColumnHandles((Table)((Table)finalTable.get()))) {
            if (!columnHandle.getColumnType().equals((Object)HiveColumnHandle.ColumnType.PARTITION_KEY)) continue;
            immutableColumns.add(metadataGetter.apply(columnHandle));
        }
        return new ConnectorTableMetadata(tableName, (List)columns.build(), (Map)properties.build(), comment, Optional.of(immutableColumns.build()), Optional.of(HiveTableProperties.NON_INHERITABLE_PROPERTIES));
    }

    public List<ConnectorVacuumTableInfo> getTablesForVacuum() {
        return CarbondataAutoVacuumThread.getAutoVacuumTableList(this.getMetastore());
    }

    public void submitCleanupTasks() {
        if (this.autoCleanerTasks.size() > 0) {
            if (enableTracingCleanupTask) {
                queuedTasks.addAll(this.autoCleanerTasks.stream().map(act -> act.submitCarbondataAutoCleanupTask(this.vacuumExecutorService)).collect(Collectors.toList()));
            } else {
                this.autoCleanerTasks.forEach(c -> c.submitCarbondataAutoCleanupTask(this.vacuumExecutorService));
            }
        }
    }

    @VisibleForTesting
    public static void enableTracingCleanupTask(boolean isEnabled) {
        enableTracingCleanupTask = isEnabled;
    }

    @VisibleForTesting
    public static void waitForSubmittedTasksFinish() {
        queuedTasks.stream().forEach(f -> {
            try {
                f.get();
            }
            catch (InterruptedException e) {
                LOG.debug((Object)("Interrupted to get the result of autoCleanup : " + e));
            }
            catch (ExecutionException e) {
                LOG.debug((Object)("Exception to get the result of autoCleanup : " + e));
            }
        });
        queuedTasks.clear();
        LOG.info((Object)"All autocleanup tasks finished");
    }

    protected boolean checkIfSuitableToPush(Set<ColumnHandle> allColumnHandles, ConnectorTableHandle tableHandle, ConnectorSession session) {
        return false;
    }

    public void cleanupQuery(ConnectorSession session) {
        super.cleanupQuery(session);
        if (this.currentState == State.VACUUM && !((String)session.getSource().get()).isEmpty() && ((String)session.getSource().get()).equals("auto-vacuum")) {
            CarbondataAutoVacuumThread.removeTableFromVacuumTablesMap(this.table.get().getDatabaseName() + "." + this.table.get().getTableName());
        }
    }

    public void addToAutoVacuumMap(ConnectorSession session) {
        if (!((String)session.getSource().get()).isEmpty() && ((String)session.getSource().get()).equals("auto-vacuum")) {
            CarbondataAutoVacuumThread.addTableToVacuumTablesMap(this.table.get().getDatabaseName() + "." + this.table.get().getTableName());
        }
    }

    private /* synthetic */ void lambda$commit$20(Exception e) {
        try {
            CarbonUtil.dropDatabaseDirectory((String)this.tableStorageLocation.get());
        }
        catch (IOException | InterruptedException ex) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Error in commit & carbon cleanup %s", ex.getMessage()), (Throwable)e);
        }
    }

    private /* synthetic */ void lambda$commit$19() {
        this.writeSchemaFile();
    }

    private /* synthetic */ void lambda$commit$18() {
        try {
            this.carbonOutputCommitter.commitJob((JobContext)this.jobContext);
        }
        catch (IOException e) {
            LOG.error((Object)"Error occurred while carbon commitJob.", (Throwable)e);
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Error occurred while carbon commitJob %s", e.getMessage()), (Throwable)e);
        }
    }

    private /* synthetic */ Boolean lambda$commit$17() throws Exception {
        CarbonUtil.dropDatabaseDirectory((String)this.tableStorageLocation.get());
        return true;
    }

    private /* synthetic */ void lambda$commit$16() {
        this.commitVacuum();
    }

    private /* synthetic */ Boolean lambda$commit$15() throws IOException {
        this.commitUpdateAndDelete();
        return true;
    }

    private /* synthetic */ Boolean lambda$commit$14() throws IOException {
        this.carbonOutputCommitter.commitJob((JobContext)this.jobContext);
        return true;
    }

    static {
        queuedTasks = new ConcurrentSkipListSet();
    }

    private static enum State {
        INSERT,
        UPDATE,
        DELETE,
        VACUUM,
        CREATE_TABLE,
        CREATE_TABLE_AS,
        DROP_TABLE,
        OTHER,
        ADD_COLUMN,
        DROP_COLUMN,
        RENAME_COLUMN;

    }
}

