/*
 * Decompiled with CFR 0.152.
 */
package io.hetu.core.plugin.carbondata;

import com.google.inject.Inject;
import io.airlift.concurrent.BoundedExecutor;
import io.airlift.json.JsonCodec;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import io.hetu.core.plugin.carbondata.CarbondataAutoVacuumThread;
import io.hetu.core.plugin.carbondata.CarbondataConfig;
import io.hetu.core.plugin.carbondata.CarbondataMetadata;
import io.hetu.core.plugin.carbondata.CarbondataSegmentInfoUtil;
import io.hetu.core.plugin.carbondata.ForCarbonVacuum;
import io.hetu.core.plugin.carbondata.impl.CarbondataTableReader;
import io.prestosql.plugin.hive.ForHive;
import io.prestosql.plugin.hive.ForHiveMetastore;
import io.prestosql.plugin.hive.ForHiveTransactionHeartbeats;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.HiveMetadata;
import io.prestosql.plugin.hive.HiveMetadataFactory;
import io.prestosql.plugin.hive.HivePartitionManager;
import io.prestosql.plugin.hive.LocationService;
import io.prestosql.plugin.hive.NodeVersion;
import io.prestosql.plugin.hive.PartitionUpdate;
import io.prestosql.plugin.hive.TypeTranslator;
import io.prestosql.plugin.hive.metastore.CachingHiveMetastore;
import io.prestosql.plugin.hive.metastore.HiveMetastore;
import io.prestosql.plugin.hive.metastore.SemiTransactionalHiveMetastore;
import io.prestosql.plugin.hive.security.AccessControlMetadataFactory;
import io.prestosql.plugin.hive.statistics.HiveStatisticsProvider;
import io.prestosql.plugin.hive.statistics.MetastoreHiveStatisticsProvider;
import io.prestosql.spi.type.TypeManager;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class CarbondataMetadataFactory
extends HiveMetadataFactory {
    private static final Logger log = Logger.get(HiveMetadataFactory.class);
    private final boolean skipDeletionForAlter;
    private final boolean skipTargetCleanupOnRollback;
    private final boolean writesToNonManagedTablesEnabled;
    private final boolean createsOfNonManagedTablesEnabled;
    private final boolean tableCreatesWithLocationAllowed;
    private final long perTransactionCacheMaximumSize;
    private final HiveMetastore metastore;
    private final HdfsEnvironment hdfsEnvironment;
    private final HivePartitionManager partitionManager;
    private final TypeManager typeManager;
    private final LocationService locationService;
    private final BoundedExecutor renameExecution;
    private final ScheduledExecutorService vacuumExecutorService;
    private final ScheduledExecutorService hiveMetastoreClientService;
    private final TypeTranslator typeTranslator;
    private final String hetuVersion;
    private final AccessControlMetadataFactory accessControlMetadataFactory;
    private final JsonCodec partitionUpdateCodec;
    private final JsonCodec segmentInfoCodec;
    private final Optional<Duration> hiveTransactionHeartbeatInterval;
    private final ScheduledExecutorService heartbeatService;
    private final CarbondataTableReader carbondataTableReader;
    private final String carbondataTableStore;
    private final long carbondataMinorVacuumSegmentCount;
    private final long carbondataMajorVacuumSegmentSize;
    private final Duration vacuumCleanupInterval;

    @Inject
    public CarbondataMetadataFactory(CarbondataConfig carbondataConfig, HiveMetastore metastore, HdfsEnvironment hdfsEnvironment, HivePartitionManager partitionManager, @ForHive ExecutorService executorService, @ForCarbonVacuum ScheduledExecutorService vacuumExecutorService, @ForHiveTransactionHeartbeats ScheduledExecutorService heartbeatService, @ForHiveMetastore ScheduledExecutorService hiveMetastoreClientService, TypeManager typeManager, LocationService locationService, JsonCodec<PartitionUpdate> partitionUpdateCodec, JsonCodec<CarbondataSegmentInfoUtil> segmentInfoCodec, TypeTranslator typeTranslator, NodeVersion nodeVersion, AccessControlMetadataFactory accessControlMetadataFactory, CarbondataTableReader carbondataTableReader) {
        this(metastore, hdfsEnvironment, partitionManager, carbondataConfig.getMaxConcurrentFileRenames(), carbondataConfig.isSkipDeletionForAlter(), carbondataConfig.isSkipTargetCleanupOnRollback(), true, carbondataConfig.getCreatesOfNonManagedTablesEnabled(), carbondataConfig.getTableCreatesWithLocationAllowed(), carbondataConfig.getPerTransactionMetastoreCacheMaximumSize(), carbondataConfig.getHiveTransactionHeartbeatInterval(), carbondataConfig.getVacuumCleanupRecheckInterval(), typeManager, locationService, partitionUpdateCodec, segmentInfoCodec, executorService, vacuumExecutorService, heartbeatService, hiveMetastoreClientService, typeTranslator, nodeVersion.toString(), accessControlMetadataFactory, carbondataTableReader, carbondataConfig.getStoreLocation(), carbondataConfig.getMajorVacuumSegSize(), carbondataConfig.getMinorVacuumSegCount(), carbondataConfig.getAutoVacuumEnable(), carbondataConfig.getMetastoreWriteBatchSize());
    }

    public CarbondataMetadataFactory(HiveMetastore metastore, HdfsEnvironment hdfsEnvironment, HivePartitionManager partitionManager, int maxConcurrentFileRenames, boolean skipDeletionForAlter, boolean skipTargetCleanupOnRollback, boolean writesToNonManagedTablesEnabled, boolean createsOfNonManagedTablesEnabled, boolean tableCreatesWithLocationAllowed, long perTransactionCacheMaximumSize, Optional<Duration> hiveTransactionHeartbeatInterval, Duration vacuumCleanupInterval, TypeManager typeManager, LocationService locationService, JsonCodec<PartitionUpdate> partitionUpdateCodec, JsonCodec<CarbondataSegmentInfoUtil> segmentInfoCodec, ExecutorService executorService, ScheduledExecutorService vacuumExecutorService, ScheduledExecutorService heartbeatService, ScheduledExecutorService hiveMetastoreClientService, TypeTranslator typeTranslator, String hetuVersion, AccessControlMetadataFactory accessControlMetadataFactory, CarbondataTableReader carbondataTableReader, String storeLocation, long majorVacuumSegSize, long minorVacuumSegCount, boolean autoVacuumEnable, int hmsWriteBatchSize) {
        super(metastore, hdfsEnvironment, partitionManager, maxConcurrentFileRenames, skipDeletionForAlter, skipTargetCleanupOnRollback, writesToNonManagedTablesEnabled, createsOfNonManagedTablesEnabled, tableCreatesWithLocationAllowed, perTransactionCacheMaximumSize, hiveTransactionHeartbeatInterval, vacuumCleanupInterval, typeManager, locationService, partitionUpdateCodec, executorService, vacuumExecutorService, heartbeatService, hiveMetastoreClientService, typeTranslator, hetuVersion, accessControlMetadataFactory, 2, 0.0, false, Optional.of(new Duration(5.0, TimeUnit.MINUTES)), hmsWriteBatchSize);
        this.skipDeletionForAlter = skipDeletionForAlter;
        this.skipTargetCleanupOnRollback = skipTargetCleanupOnRollback;
        this.writesToNonManagedTablesEnabled = writesToNonManagedTablesEnabled;
        this.createsOfNonManagedTablesEnabled = createsOfNonManagedTablesEnabled;
        this.tableCreatesWithLocationAllowed = tableCreatesWithLocationAllowed;
        this.perTransactionCacheMaximumSize = perTransactionCacheMaximumSize;
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.partitionManager = Objects.requireNonNull(partitionManager, "partitionManager is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.locationService = Objects.requireNonNull(locationService, "locationService is null");
        this.partitionUpdateCodec = Objects.requireNonNull(partitionUpdateCodec, "partitionUpdateCodec is null");
        this.segmentInfoCodec = Objects.requireNonNull(segmentInfoCodec, "segmentInfoCodec is null");
        this.typeTranslator = Objects.requireNonNull(typeTranslator, "typeTranslator is null");
        this.hetuVersion = Objects.requireNonNull(hetuVersion, "hetuVersion is null");
        this.accessControlMetadataFactory = Objects.requireNonNull(accessControlMetadataFactory, "accessControlMetadataFactory is null");
        this.renameExecution = new BoundedExecutor((Executor)executorService, maxConcurrentFileRenames);
        this.vacuumExecutorService = Objects.requireNonNull(vacuumExecutorService, "vacuumExecutorService is null");
        this.hiveMetastoreClientService = Objects.requireNonNull(hiveMetastoreClientService, "hiveMetastoreClientService is null");
        this.vacuumCleanupInterval = Objects.requireNonNull(vacuumCleanupInterval, "vacuumCleanupInterval is null");
        this.hiveTransactionHeartbeatInterval = Objects.requireNonNull(hiveTransactionHeartbeatInterval, "hiveTransactionHeartbeatInterval is null");
        this.heartbeatService = Objects.requireNonNull(heartbeatService, "heartbeatService is null");
        this.carbondataTableReader = Objects.requireNonNull(carbondataTableReader, "tableReader is null");
        this.carbondataTableStore = storeLocation;
        this.carbondataMinorVacuumSegmentCount = minorVacuumSegCount;
        this.carbondataMajorVacuumSegmentSize = majorVacuumSegSize;
        if (autoVacuumEnable) {
            CarbondataAutoVacuumThread.setAutoVacuumInfo(this.carbondataTableReader, this.hdfsEnvironment, majorVacuumSegSize, minorVacuumSegCount, vacuumExecutorService);
        }
    }

    public HiveMetadata get() {
        SemiTransactionalHiveMetastore semiTransactionalHiveMetastore = new SemiTransactionalHiveMetastore(this.hdfsEnvironment, (HiveMetastore)CachingHiveMetastore.memoizeMetastore((HiveMetastore)this.metastore, (long)this.perTransactionCacheMaximumSize), (Executor)this.renameExecution, this.vacuumExecutorService, this.vacuumCleanupInterval, this.skipDeletionForAlter, this.skipTargetCleanupOnRollback, this.hiveTransactionHeartbeatInterval, this.heartbeatService, this.hiveMetastoreClientService, this.hmsWriteBatchSize);
        return new CarbondataMetadata(semiTransactionalHiveMetastore, this.hdfsEnvironment, this.partitionManager, this.writesToNonManagedTablesEnabled, this.createsOfNonManagedTablesEnabled, this.tableCreatesWithLocationAllowed, this.typeManager, this.locationService, (JsonCodec<PartitionUpdate>)this.partitionUpdateCodec, (JsonCodec<CarbondataSegmentInfoUtil>)this.segmentInfoCodec, this.typeTranslator, this.hetuVersion, (HiveStatisticsProvider)new MetastoreHiveStatisticsProvider(semiTransactionalHiveMetastore, this.statsCache, this.samplePartitionCache), this.accessControlMetadataFactory.create(semiTransactionalHiveMetastore), this.carbondataTableReader, this.carbondataTableStore, this.carbondataMajorVacuumSegmentSize, this.carbondataMinorVacuumSegmentCount, this.vacuumExecutorService, this.hiveMetastoreClientService);
    }
}

