/*
 * Decompiled with CFR 0.152.
 */
package io.hetu.core.plugin.carbondata;

import io.hetu.core.plugin.carbondata.CarbondataHetuFilterUtil;
import io.hetu.core.plugin.carbondata.FolderAlreadyExistException;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.HiveColumnHandle;
import io.prestosql.plugin.hive.HiveWriteUtils;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.ConnectorSession;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.carbondata.core.datastore.filesystem.CarbonFile;
import org.apache.carbondata.core.datastore.filesystem.CarbonFileFilter;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.locks.CarbonLockUtil;
import org.apache.carbondata.core.locks.ICarbonLock;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.CarbonMetadata;
import org.apache.carbondata.core.metadata.SegmentFileStore;
import org.apache.carbondata.core.metadata.converter.ThriftWrapperSchemaConverterImpl;
import org.apache.carbondata.core.metadata.datatype.StructField;
import org.apache.carbondata.core.metadata.schema.PartitionInfo;
import org.apache.carbondata.core.metadata.schema.partition.PartitionType;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.CarbonTableBuilder;
import org.apache.carbondata.core.metadata.schema.table.TableSchema;
import org.apache.carbondata.core.metadata.schema.table.TableSchemaBuilder;
import org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema;
import org.apache.carbondata.core.statusmanager.SegmentStatus;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.carbondata.core.writer.ThriftWriter;
import org.apache.carbondata.format.SchemaEvolutionEntry;
import org.apache.carbondata.format.TableInfo;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.thrift.TBase;

public class CarbondataMetadataUtils {
    private CarbondataMetadataUtils() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void createMetaDataFolderSchemaFile(HdfsEnvironment hdfsEnvironment, ConnectorSession session, List<HiveColumnHandle> columnHandles, AbsoluteTableIdentifier absoluteTableIdentifier, List<String> partitionedBy, List<String> sortBy, String tablePath, Configuration initialConfiguration) {
        AtomicInteger valIndex = new AtomicInteger(0);
        TableSchemaBuilder schemaBuilder = new TableSchemaBuilder();
        ArrayList partitionStructFields = new ArrayList();
        ICarbonLock metadataLock = null;
        columnHandles.forEach(col -> {
            if (partitionedBy.contains(col.getName())) {
                partitionStructFields.add(new StructField(col.getName(), CarbondataHetuFilterUtil.spi2CarbondataTypeMapper(col)));
            } else {
                schemaBuilder.addColumn(new StructField(col.getName(), CarbondataHetuFilterUtil.spi2CarbondataTypeMapper(col)), valIndex, sortBy.contains(col.getName()), false);
            }
        });
        PartitionInfo partitionInfo = null;
        if (!partitionStructFields.isEmpty()) {
            ArrayList<ColumnSchema> partitionColumnSchemas = new ArrayList<ColumnSchema>();
            for (StructField partitionStructField : partitionStructFields) {
                partitionColumnSchemas.add(schemaBuilder.addColumn(partitionStructField, valIndex, sortBy.contains(partitionStructField.getFieldName()), false));
            }
            partitionInfo = new PartitionInfo(partitionColumnSchemas, PartitionType.NATIVE_HIVE);
        }
        schemaBuilder.tableName(absoluteTableIdentifier.getTableName());
        TableSchema schema = schemaBuilder.build();
        schema.setPartitionInfo(partitionInfo);
        schema.getTableProperties().put("sort_scope", "LOCAL_SORT");
        CarbonTableBuilder tableBuilder = new CarbonTableBuilder();
        tableBuilder.databaseName(absoluteTableIdentifier.getDatabaseName()).tableName(absoluteTableIdentifier.getTableName()).tablePath(tablePath).isTransactionalTable(true).tableSchema(schema);
        CarbonTable carbonTable = tableBuilder.build();
        org.apache.carbondata.core.metadata.schema.table.TableInfo tableInfo = carbonTable.getTableInfo();
        String schemaFilePath = CarbonTablePath.getSchemaFilePath((String)tablePath, (Configuration)initialConfiguration);
        String schemaMetadataPath = CarbonTablePath.getFolderContainingFile((String)schemaFilePath);
        CarbonMetadata.getInstance().loadTableMetadata(tableInfo);
        ThriftWrapperSchemaConverterImpl schemaConverter = new ThriftWrapperSchemaConverterImpl();
        TableInfo thriftTableInfo = schemaConverter.fromWrapperToExternalTableInfo(tableInfo, tableInfo.getDatabaseName(), tableInfo.getFactTable().getTableName());
        SchemaEvolutionEntry schemaEvolutionEntry = new SchemaEvolutionEntry(tableInfo.getLastUpdatedTime());
        thriftTableInfo.getFact_table().getSchema_evolution().getSchema_evolution_history().add(schemaEvolutionEntry);
        try {
            HdfsEnvironment.HdfsContext context = new HdfsEnvironment.HdfsContext(session, absoluteTableIdentifier.getDatabaseName(), absoluteTableIdentifier.getTableName());
            Path metadataPath = new Path(schemaMetadataPath);
            if (HiveWriteUtils.pathExists((HdfsEnvironment.HdfsContext)context, (HdfsEnvironment)hdfsEnvironment, (Path)new Path(tablePath))) throw new FolderAlreadyExistException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, "Folder is not empty");
            try {
                HiveWriteUtils.createDirectory((HdfsEnvironment.HdfsContext)context, (HdfsEnvironment)hdfsEnvironment, (Path)metadataPath);
            }
            catch (PrestoException ex) {
                throw new FolderAlreadyExistException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Folder is not empty %s", ex.getMessage()), ex);
            }
            AbsoluteTableIdentifier identifier = carbonTable.getAbsoluteTableIdentifier();
            try {
                metadataLock = CarbonLockUtil.getLockObject((AbsoluteTableIdentifier)identifier, (String)"meta.lock");
            }
            catch (RuntimeException ex) {
                throw new FolderAlreadyExistException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Error in getting lock: %s", ex.getMessage()), ex);
            }
            if (FileFactory.isFileExist((String)schemaFilePath)) {
                throw new FolderAlreadyExistException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Folder is not empty");
            }
            ThriftWriter thriftWriter = new ThriftWriter(schemaFilePath, false);
            try {
                thriftWriter.open();
                thriftWriter.write((TBase)thriftTableInfo);
                thriftWriter.close();
            }
            catch (IOException e) {
                CarbonUtil.dropDatabaseDirectory((String)tablePath);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Error while creating carbon schema file %s", e.getMessage()), (Throwable)e);
            }
            if (null == metadataLock) return;
        }
        catch (IOException | InterruptedException e) {
            try {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Error while creating carbon Metadata %s", e.getMessage()), (Throwable)e);
            }
            catch (Throwable throwable) {
                if (null == metadataLock) throw throwable;
                CarbonLockUtil.fileUnlock(metadataLock, (String)"meta.lock");
                throw throwable;
            }
        }
        CarbonLockUtil.fileUnlock((ICarbonLock)metadataLock, (String)"meta.lock");
        return;
    }

    public static void writeSegmentFile(CarbonTable carbonTable, String segmentId, String uuid) throws IOException {
        String tablePath = carbonTable.getTablePath();
        boolean supportFlatFolder = carbonTable.isSupportFlatFolder();
        String segmentPath = CarbonTablePath.getSegmentPath((String)tablePath, (String)segmentId);
        CarbonFile segmentFolder = FileFactory.getCarbonFile((String)segmentPath);
        CarbonFile[] indexFiles = segmentFolder.listFiles(new CarbonFileFilter(){

            public boolean accept(CarbonFile file) {
                return file.getName().endsWith(".carbonindex") || file.getName().endsWith(".carbonindexmerge");
            }
        });
        if (indexFiles != null && indexFiles.length > 0) {
            SegmentFileStore.SegmentFile segmentFile = new SegmentFileStore.SegmentFile();
            SegmentFileStore.FolderDetails folderDetails = new SegmentFileStore.FolderDetails();
            folderDetails.setRelative(true);
            folderDetails.setStatus(SegmentStatus.SUCCESS.getMessage());
            for (CarbonFile file : indexFiles) {
                if (file.getName().endsWith(".carbonindexmerge")) {
                    folderDetails.setMergeFileName(file.getName());
                    continue;
                }
                folderDetails.getFiles().add(file.getName());
            }
            String segmentRelativePath = "/";
            if (!supportFlatFolder) {
                segmentRelativePath = segmentPath.substring(tablePath.length());
            }
            segmentFile.getLocationMap().put(segmentRelativePath, folderDetails);
            String segmentFileFolder = CarbonTablePath.getSegmentFilesLocation((String)tablePath) + "/" + segmentId + "_" + uuid + ".tmp";
            CarbonFile carbonFile = FileFactory.getCarbonFile((String)segmentFileFolder);
            if (!carbonFile.exists()) {
                carbonFile.mkdirs();
            }
            String segmentFileName = SegmentFileStore.genSegmentFileName((String)segmentId, (String)uuid) + ".segment";
            SegmentFileStore.writeSegmentFile((SegmentFileStore.SegmentFile)segmentFile, (String)(segmentFileFolder + File.separator + segmentFileName));
        }
    }
}

