/*
 * Decompiled with CFR 0.152.
 */
package io.hetu.core.plugin.carbondata;

import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Multibinder;
import io.airlift.concurrent.Threads;
import io.airlift.configuration.ConfigBinder;
import io.airlift.event.client.EventClient;
import io.airlift.json.JsonCodecBinder;
import io.hetu.core.plugin.carbondata.CarbondataConfig;
import io.hetu.core.plugin.carbondata.CarbondataFileWriterFactory;
import io.hetu.core.plugin.carbondata.CarbondataLocationService;
import io.hetu.core.plugin.carbondata.CarbondataMetadataFactory;
import io.hetu.core.plugin.carbondata.CarbondataPageSinkProvider;
import io.hetu.core.plugin.carbondata.CarbondataPageSourceProvider;
import io.hetu.core.plugin.carbondata.CarbondataSegmentInfoUtil;
import io.hetu.core.plugin.carbondata.CarbondataSplitManager;
import io.hetu.core.plugin.carbondata.CarbondataTableProperties;
import io.hetu.core.plugin.carbondata.ForCarbonVacuum;
import io.hetu.core.plugin.carbondata.impl.CarbondataTableReader;
import io.prestosql.plugin.hive.CachingDirectoryLister;
import io.prestosql.plugin.hive.CoercionPolicy;
import io.prestosql.plugin.hive.DirectoryLister;
import io.prestosql.plugin.hive.DynamicConfigurationProvider;
import io.prestosql.plugin.hive.FileFormatDataSourceStats;
import io.prestosql.plugin.hive.GenericHiveRecordCursorProvider;
import io.prestosql.plugin.hive.HdfsConfiguration;
import io.prestosql.plugin.hive.HdfsConfigurationInitializer;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.HiveAnalyzeProperties;
import io.prestosql.plugin.hive.HiveCatalogName;
import io.prestosql.plugin.hive.HiveCoercionPolicy;
import io.prestosql.plugin.hive.HiveEventClient;
import io.prestosql.plugin.hive.HiveFileWriterFactory;
import io.prestosql.plugin.hive.HiveHdfsConfiguration;
import io.prestosql.plugin.hive.HiveMetadataFactory;
import io.prestosql.plugin.hive.HiveModule;
import io.prestosql.plugin.hive.HiveNodePartitioningProvider;
import io.prestosql.plugin.hive.HivePageSourceFactory;
import io.prestosql.plugin.hive.HivePartitionManager;
import io.prestosql.plugin.hive.HiveRecordCursorProvider;
import io.prestosql.plugin.hive.HiveSessionProperties;
import io.prestosql.plugin.hive.HiveSplitManager;
import io.prestosql.plugin.hive.HiveTransactionManager;
import io.prestosql.plugin.hive.HiveTypeTranslator;
import io.prestosql.plugin.hive.HiveWriterStats;
import io.prestosql.plugin.hive.LocationService;
import io.prestosql.plugin.hive.NamenodeStats;
import io.prestosql.plugin.hive.OrcFileWriterConfig;
import io.prestosql.plugin.hive.OrcFileWriterFactory;
import io.prestosql.plugin.hive.ParquetFileWriterConfig;
import io.prestosql.plugin.hive.PartitionUpdate;
import io.prestosql.plugin.hive.RcFileFileWriterFactory;
import io.prestosql.plugin.hive.TransactionalMetadata;
import io.prestosql.plugin.hive.TypeTranslator;
import io.prestosql.plugin.hive.orc.OrcPageSourceFactory;
import io.prestosql.plugin.hive.parquet.ParquetPageSourceFactory;
import io.prestosql.plugin.hive.rcfile.RcFilePageSourceFactory;
import io.prestosql.spi.connector.ConnectorNodePartitioningProvider;
import io.prestosql.spi.connector.ConnectorPageSinkProvider;
import io.prestosql.spi.connector.ConnectorPageSourceProvider;
import io.prestosql.spi.connector.ConnectorSplitManager;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Supplier;
import javax.inject.Singleton;
import org.weakref.jmx.ObjectNames;
import org.weakref.jmx.guice.ExportBinder;

public class CarbondataModule
extends HiveModule {
    private final String connectorId;

    public CarbondataModule(String connectorId) {
        this.connectorId = Objects.requireNonNull(connectorId, "connector id is null");
    }

    public void configure(Binder binder) {
        binder.bind(TypeTranslator.class).toInstance((Object)new HiveTypeTranslator());
        binder.bind(CoercionPolicy.class).to(HiveCoercionPolicy.class).in(Scopes.SINGLETON);
        binder.bind(HdfsConfigurationInitializer.class).in(Scopes.SINGLETON);
        Multibinder.newSetBinder((Binder)binder, DynamicConfigurationProvider.class);
        binder.bind(HdfsConfiguration.class).to(HiveHdfsConfiguration.class).in(Scopes.SINGLETON);
        binder.bind(HdfsEnvironment.class).in(Scopes.SINGLETON);
        binder.bind(DirectoryLister.class).to(CachingDirectoryLister.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(CarbondataConfig.class);
        binder.bind(HiveSessionProperties.class).in(Scopes.SINGLETON);
        binder.bind(CarbondataTableProperties.class).in(Scopes.SINGLETON);
        binder.bind(HiveAnalyzeProperties.class).in(Scopes.SINGLETON);
        binder.bind(NamenodeStats.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(NamenodeStats.class).as(ObjectNames.generatedNameOf(NamenodeStats.class, (String)this.connectorId));
        Multibinder recordCursorProviderBinder = Multibinder.newSetBinder((Binder)binder, HiveRecordCursorProvider.class);
        recordCursorProviderBinder.addBinding().to(GenericHiveRecordCursorProvider.class).in(Scopes.SINGLETON);
        binder.bind(HiveWriterStats.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(HiveWriterStats.class).as(ObjectNames.generatedNameOf(HiveWriterStats.class, (String)this.connectorId));
        Multibinder.newSetBinder((Binder)binder, EventClient.class).addBinding().to(HiveEventClient.class).in(Scopes.SINGLETON);
        binder.bind(HivePartitionManager.class).in(Scopes.SINGLETON);
        binder.bind(LocationService.class).to(CarbondataLocationService.class).in(Scopes.SINGLETON);
        binder.bind(HiveMetadataFactory.class).to(CarbondataMetadataFactory.class).in(Scopes.SINGLETON);
        binder.bind((TypeLiteral)new TypeLiteral<Supplier<TransactionalMetadata>>(){}).to(HiveMetadataFactory.class).in(Scopes.SINGLETON);
        binder.bind(HiveTransactionManager.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorSplitManager.class).to(CarbondataSplitManager.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(ConnectorSplitManager.class).as(ObjectNames.generatedNameOf(HiveSplitManager.class, (String)this.connectorId));
        binder.bind(ConnectorPageSourceProvider.class).to(CarbondataPageSourceProvider.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorPageSinkProvider.class).to(CarbondataPageSinkProvider.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorNodePartitioningProvider.class).to(HiveNodePartitioningProvider.class).in(Scopes.SINGLETON);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(PartitionUpdate.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(CarbondataSegmentInfoUtil.class);
        binder.bind(FileFormatDataSourceStats.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(FileFormatDataSourceStats.class).as(ObjectNames.generatedNameOf(FileFormatDataSourceStats.class, (String)this.connectorId));
        Multibinder pageSourceFactoryBinder = Multibinder.newSetBinder((Binder)binder, HivePageSourceFactory.class);
        pageSourceFactoryBinder.addBinding().to(OrcPageSourceFactory.class).in(Scopes.SINGLETON);
        pageSourceFactoryBinder.addBinding().to(ParquetPageSourceFactory.class).in(Scopes.SINGLETON);
        pageSourceFactoryBinder.addBinding().to(RcFilePageSourceFactory.class).in(Scopes.SINGLETON);
        Multibinder fileWriterFactoryBinder = Multibinder.newSetBinder((Binder)binder, HiveFileWriterFactory.class);
        binder.bind(OrcFileWriterFactory.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(OrcFileWriterFactory.class).as(ObjectNames.generatedNameOf(OrcFileWriterFactory.class, (String)this.connectorId));
        ConfigBinder.configBinder((Binder)binder).bindConfig(OrcFileWriterConfig.class);
        fileWriterFactoryBinder.addBinding().to(OrcFileWriterFactory.class).in(Scopes.SINGLETON);
        fileWriterFactoryBinder.addBinding().to(RcFileFileWriterFactory.class).in(Scopes.SINGLETON);
        fileWriterFactoryBinder.addBinding().to(CarbondataFileWriterFactory.class).in(Scopes.SINGLETON);
        binder.bind(CarbondataTableReader.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(ParquetFileWriterConfig.class);
    }

    @ForCarbonVacuum
    @Singleton
    @Provides
    public ScheduledExecutorService createCarbonVacuumServiceExecutor(HiveCatalogName catalogName, CarbondataConfig carbonConfig) {
        return Executors.newScheduledThreadPool(carbonConfig.getCarbondataVacuumServiceThreads(), Threads.daemonThreadsNamed((String)("carbon-vacuum-service-" + catalogName + "-%s")));
    }
}

