/*
 * Decompiled with CFR 0.152.
 */
package io.hetu.core.plugin.carbondata;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.concurrent.MoreFutures;
import io.airlift.json.JsonCodec;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.hetu.core.plugin.carbondata.CarbondataPageSource;
import io.hetu.core.plugin.carbondata.CarbondataSegmentInfoUtil;
import io.hetu.core.plugin.carbondata.CarbondataWriterFactory;
import io.hetu.core.plugin.carbondata.impl.CarbondataLocalMultiBlockSplit;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.HiveACIDWriteType;
import io.prestosql.plugin.hive.HiveBucketProperty;
import io.prestosql.plugin.hive.HiveColumnHandle;
import io.prestosql.plugin.hive.HivePageSink;
import io.prestosql.plugin.hive.HiveSplit;
import io.prestosql.plugin.hive.HiveSplitWrapper;
import io.prestosql.plugin.hive.HiveWritableTableHandle;
import io.prestosql.plugin.hive.HiveWriterFactory;
import io.prestosql.plugin.hive.PartitionUpdate;
import io.prestosql.plugin.hive.util.ConfigurationUtils;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PageIndexerFactory;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.ConnectorPageSink;
import io.prestosql.spi.connector.ConnectorPageSource;
import io.prestosql.spi.connector.ConnectorPageSourceProvider;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorSplit;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.type.TypeManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.constants.SortScopeOptions;
import org.apache.carbondata.core.datastore.block.SegmentProperties;
import org.apache.carbondata.core.datastore.block.TableBlockInfo;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.util.DataTypeConverter;
import org.apache.carbondata.core.util.DataTypeConverterImpl;
import org.apache.carbondata.core.util.ObjectSerializationUtil;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.carbondata.hadoop.CarbonInputSplit;
import org.apache.carbondata.hadoop.CarbonMultiBlockSplit;
import org.apache.carbondata.hadoop.api.CarbonTableOutputFormat;
import org.apache.carbondata.processing.loading.model.CarbonLoadModel;
import org.apache.carbondata.processing.merger.CarbonCompactionExecutor;
import org.apache.carbondata.processing.merger.CarbonCompactionUtil;
import org.apache.carbondata.processing.merger.CompactionResultSortProcessor;
import org.apache.carbondata.processing.merger.CompactionType;
import org.apache.carbondata.processing.merger.RowResultMergerProcessor;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.log4j.Logger;

public class CarbondataPageSink
extends HivePageSink
implements ConnectorPageSink {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)CarbondataPageSink.class.getName());
    private final Map<String, String> additionalConf;
    private final HdfsEnvironment hdfsEnvironment;
    private final ListeningExecutorService writeVerificationExecutor;
    private CarbondataSegmentInfoUtil segmentInfoData;
    private JsonCodec<CarbondataSegmentInfoUtil> segmentInfo;
    private boolean isCompactionCalled;
    List<TableBlockInfo> tableBlockInfoList;

    public CarbondataPageSink(CarbondataWriterFactory writerFactory, List<HiveColumnHandle> inputColumns, Optional<HiveBucketProperty> bucketProperty, PageIndexerFactory pageIndexerFactory, TypeManager typeManager, HdfsEnvironment hdfsEnvironment, int maxOpenWriters, ListeningExecutorService writeVerificationExecutor, JsonCodec<PartitionUpdate> partitionUpdateCodec, JsonCodec<CarbondataSegmentInfoUtil> segmentInfo, ConnectorSession session, HiveACIDWriteType acidWriteType, HiveWritableTableHandle handle, Map<String, String> additionalConf) {
        super((HiveWriterFactory)writerFactory, inputColumns, bucketProperty, pageIndexerFactory, typeManager, hdfsEnvironment, maxOpenWriters, writeVerificationExecutor, partitionUpdateCodec, session, acidWriteType, handle);
        this.hdfsEnvironment = hdfsEnvironment;
        this.additionalConf = ImmutableMap.copyOf(Objects.requireNonNull(additionalConf, "Additional conf cannot be null"));
        this.writeVerificationExecutor = Objects.requireNonNull(writeVerificationExecutor, "writeVerificationExecutor is null");
        this.segmentInfo = Objects.requireNonNull(segmentInfo, "segmentInfoCodec is null");
    }

    public ConnectorPageSink.VacuumResult vacuum(ConnectorPageSourceProvider pageSourceProvider, ConnectorTransactionHandle transactionHandle, ConnectorTableHandle connectorTableHandle, List<ConnectorSplit> splits) throws PrestoException {
        ArrayList hiveSplits = new ArrayList();
        splits.forEach(split -> hiveSplits.addAll(((HiveSplitWrapper)split).getSplits()));
        ArrayList inputColumns = new ArrayList(this.inputColumns);
        ConnectorPageSource pageSource = pageSourceProvider.createPageSource(transactionHandle, this.session, splits.get(0), connectorTableHandle, inputColumns);
        try {
            this.performCompaction((CarbondataPageSource)pageSource, (HiveSplit)hiveSplits.get(0));
        }
        catch (PrestoException e) {
            LOGGER.error((Object)"Error in worker for performing carbon vacuum");
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, e.getMessage());
        }
        return new ConnectorPageSink.VacuumResult(null, true);
    }

    public void performCompaction(CarbondataPageSource connectorPageSource, HiveSplit split) throws PrestoException {
        this.isCompactionCalled = true;
        HdfsEnvironment finalHdfsEnvironment = connectorPageSource.getHdfsEnvironment();
        finalHdfsEnvironment.doAs(this.session.getUser(), () -> {
            try {
                boolean mergeStatus = false;
                List<CarbonInputSplit> splitList = this.convertAndGetCarbonSplits(split);
                CarbonTable carbonTable = connectorPageSource.getCarbonTable();
                String databaseName = carbonTable.getDatabaseName();
                String factTableName = carbonTable.getTableName();
                this.tableBlockInfoList = CarbonInputSplit.createBlocks(splitList);
                Collections.sort(this.tableBlockInfoList);
                Map segmentMapping = CarbonCompactionUtil.createMappingForSegments(this.tableBlockInfoList);
                Map dataFileMetadataSegMapping = CarbonCompactionUtil.createDataFileFooterMappingForSegments(this.tableBlockInfoList, (boolean)false);
                CarbonCompactionExecutor executor = new CarbonCompactionExecutor(segmentMapping, null, carbonTable, dataFileMetadataSegMapping, false, (DataTypeConverter)new DataTypeConverterImpl());
                String mergedLoadName = split.getSchema().getProperty("mergeLoadName");
                String taskNo = split.getSchema().getProperty("taskNo");
                String encodedLoadModel = this.additionalConf.get("hetu.carbondata.states.encodedLoadModel");
                this.segmentInfoData = new CarbondataSegmentInfoUtil(mergedLoadName, segmentMapping.keySet());
                CarbonLoadModel carbonLoadModel = this.getDeserialisedLoadModel(encodedLoadModel);
                if (null == carbonLoadModel) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Error in deserializing load model");
                }
                carbonLoadModel.setTaskNo(taskNo);
                CompactionType compactionType = split.getSchema().getProperty("compactionType").equals("MAJOR") ? CompactionType.MAJOR : CompactionType.MINOR;
                String mergeNumber = mergedLoadName.substring(mergedLoadName.lastIndexOf("Segment_") + "Segment_".length());
                carbonLoadModel.setSegmentId(mergeNumber);
                Map rawResultIteratorMap = new HashMap();
                RowResultMergerProcessor processor = null;
                ArrayList maxSegmentColumnSchemaList = new ArrayList();
                CarbonCompactionUtil.updateColumnSchema((CarbonTable)carbonTable, maxSegmentColumnSchemaList);
                SegmentProperties segmentProperties = new SegmentProperties(maxSegmentColumnSchemaList);
                String baseTempPath = this.writableTableHandle.getLocationHandle().getJsonSerializableWritePath();
                String[] tempStoreLoc = CarbondataPageSink.getTempLocations(baseTempPath, taskNo, mergeNumber);
                JobConf initialConfiguration = ConfigurationUtils.toJobConf((Configuration)connectorPageSource.getHdfsEnvironment().getConfiguration(new HdfsEnvironment.HdfsContext(this.session, databaseName, factTableName), new Path(carbonTable.getSegmentPath(mergedLoadName))));
                CarbonTableOutputFormat.setLoadModel((Configuration)initialConfiguration, (CarbonLoadModel)carbonLoadModel);
                rawResultIteratorMap = executor.processTableBlocks((Configuration)initialConfiguration, null);
                if (carbonTable.getSortScope() == SortScopeOptions.SortScope.NO_SORT || ((List)rawResultIteratorMap.get("UNSORTED_IDX")).size() == 0) {
                    LOGGER.info((Object)"RowResultMergerProcessor flow is selected");
                    processor = new RowResultMergerProcessor(databaseName, factTableName, segmentProperties, tempStoreLoc, carbonLoadModel, compactionType, null);
                } else {
                    LOGGER.info((Object)"CompactionResultSortProcessor flow is selected");
                    processor = new CompactionResultSortProcessor(carbonLoadModel, carbonTable, segmentProperties, compactionType, factTableName, null);
                }
                try {
                    mergeStatus = processor.execute((List)rawResultIteratorMap.get("UNSORTED_IDX"), (List)rawResultIteratorMap.get("SORTED_IDX"));
                }
                catch (Exception e) {
                    LOGGER.error((Object)"Problem in merging");
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Carbon compaction merging didn't succeed.", (Throwable)e);
                }
                if (!mergeStatus) {
                    LOGGER.error((Object)"Carbon compaction merging failed in worker.");
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Carbon compaction merging failed in worker.");
                }
            }
            catch (IOException e) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Carbon compaction operation failed.");
            }
        });
    }

    private List<CarbonInputSplit> convertAndGetCarbonSplits(HiveSplit split) {
        CarbonMultiBlockSplit carbonInputSplit = CarbondataLocalMultiBlockSplit.convertSplit(split.getSchema().getProperty("carbonSplit"));
        return carbonInputSplit.getAllSplits();
    }

    private CarbonLoadModel getDeserialisedLoadModel(String encodedString) throws PrestoException {
        try {
            if (encodedString != null) {
                CarbonLoadModel model = (CarbonLoadModel)ObjectSerializationUtil.convertStringToObject((String)encodedString);
                return model;
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)"Error getting deserialised model");
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Error in deserializing load model", (Throwable)e);
        }
        return null;
    }

    private static String[] getTempLocations(String baseTempStorePath, String taskId, String segmentId) {
        String[] baseTmpStorePathArray = new String[]{baseTempStorePath};
        String[] localDataFolderLocArray = new String[baseTmpStorePathArray.length];
        for (int i = 0; i < baseTmpStorePathArray.length; ++i) {
            String tmpStore = baseTmpStorePathArray[i];
            String carbonDataDirectoryPath = CarbonTablePath.getSegmentPath((String)tmpStore, (String)segmentId);
            localDataFolderLocArray[i] = carbonDataDirectoryPath + File.separator + taskId;
        }
        return localDataFolderLocArray;
    }

    public CompletableFuture<Collection<Slice>> finish() {
        if (!this.isCompactionCalled) {
            return super.finish();
        }
        ListenableFuture result = (ListenableFuture)this.hdfsEnvironment.doAs(this.session.getUser(), this::doFinish);
        return MoreFutures.toCompletableFuture((ListenableFuture)result);
    }

    public long getRowsWritten() {
        if (!this.isCompactionCalled) {
            return super.getRowsWritten();
        }
        long rowCount = 0L;
        for (TableBlockInfo tableInfo : this.tableBlockInfoList) {
            rowCount += (long)tableInfo.getDetailInfo().getRowCount();
        }
        return rowCount;
    }

    private ListenableFuture<Collection<Slice>> doFinish() {
        ImmutableList.Builder dataToReturn = ImmutableList.builder();
        dataToReturn.add((Object)Slices.wrappedBuffer((byte[])this.segmentInfo.toJsonBytes((Object)this.segmentInfoData)));
        ImmutableList result = dataToReturn.build();
        ArrayList verificationTasks = new ArrayList();
        if (verificationTasks.isEmpty()) {
            return Futures.immediateFuture((Object)result);
        }
        try {
            List futures = this.writeVerificationExecutor.invokeAll(verificationTasks).stream().map(future -> (ListenableFuture)future).collect(Collectors.toList());
            return Futures.transform((ListenableFuture)Futures.allAsList(futures), arg_0 -> CarbondataPageSink.lambda$doFinish$3((List)result, arg_0), (Executor)MoreExecutors.directExecutor());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ Collection lambda$doFinish$3(List result, List input) {
        return result;
    }
}

