/*
 * Decompiled with CFR 0.152.
 */
package io.hetu.core.plugin.carbondata;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.concurrent.Threads;
import io.airlift.event.client.EventClient;
import io.airlift.json.JsonCodec;
import io.airlift.units.DataSize;
import io.hetu.core.plugin.carbondata.CarbonDeleteAsInsertTableHandle;
import io.hetu.core.plugin.carbondata.CarbondataInsertTableHandle;
import io.hetu.core.plugin.carbondata.CarbondataOutputTableHandle;
import io.hetu.core.plugin.carbondata.CarbondataPageSink;
import io.hetu.core.plugin.carbondata.CarbondataSegmentInfoUtil;
import io.hetu.core.plugin.carbondata.CarbondataUpdateTableHandle;
import io.hetu.core.plugin.carbondata.CarbondataVacuumTableHandle;
import io.hetu.core.plugin.carbondata.CarbondataWriterFactory;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.HiveACIDWriteType;
import io.prestosql.plugin.hive.HiveBucketProperty;
import io.prestosql.plugin.hive.HiveConfig;
import io.prestosql.plugin.hive.HiveFileWriterFactory;
import io.prestosql.plugin.hive.HivePageSinkProvider;
import io.prestosql.plugin.hive.HiveSessionProperties;
import io.prestosql.plugin.hive.HiveVacuumTableHandle;
import io.prestosql.plugin.hive.HiveWritableTableHandle;
import io.prestosql.plugin.hive.HiveWriterStats;
import io.prestosql.plugin.hive.LocationService;
import io.prestosql.plugin.hive.OrcFileWriterFactory;
import io.prestosql.plugin.hive.PartitionUpdate;
import io.prestosql.plugin.hive.authentication.HiveIdentity;
import io.prestosql.plugin.hive.metastore.CachingHiveMetastore;
import io.prestosql.plugin.hive.metastore.HiveMetastore;
import io.prestosql.plugin.hive.metastore.HivePageSinkMetadataProvider;
import io.prestosql.plugin.hive.metastore.SortingColumn;
import io.prestosql.spi.NodeManager;
import io.prestosql.spi.PageIndexerFactory;
import io.prestosql.spi.PageSorter;
import io.prestosql.spi.connector.ConnectorDeleteAsInsertTableHandle;
import io.prestosql.spi.connector.ConnectorInsertTableHandle;
import io.prestosql.spi.connector.ConnectorOutputTableHandle;
import io.prestosql.spi.connector.ConnectorPageSink;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.connector.ConnectorUpdateTableHandle;
import io.prestosql.spi.connector.ConnectorVacuumTableHandle;
import io.prestosql.spi.type.TypeManager;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.inject.Inject;

public class CarbondataPageSinkProvider
extends HivePageSinkProvider {
    private final Set<HiveFileWriterFactory> fileWriterFactories;
    private final HdfsEnvironment hdfsEnvironment;
    private final PageSorter pageSorter;
    private final HiveMetastore metastore;
    private final PageIndexerFactory pageIndexerFactory;
    private final TypeManager typeManager;
    private final int maxOpenPartitions;
    private final int maxOpenSortFiles;
    private final DataSize writerSortBufferSize;
    private final boolean immutablePartitions;
    private final LocationService locationService;
    private final ListeningExecutorService writeVerificationExecutor;
    private final JsonCodec<PartitionUpdate> partitionUpdateCodec;
    private final JsonCodec<CarbondataSegmentInfoUtil> carbondataSegmentInfoCodec;
    private final NodeManager nodeManager;
    private final EventClient eventClient;
    private final HiveSessionProperties hiveSessionProperties;
    private final HiveWriterStats hiveWriterStats;
    private final OrcFileWriterFactory orcFileWriterFactory;
    private final long perTransactionMetastoreCacheMaximumSize;

    @Inject
    public CarbondataPageSinkProvider(Set<HiveFileWriterFactory> fileWriterFactories, HdfsEnvironment hdfsEnvironment, PageSorter pageSorter, HiveMetastore metastore, PageIndexerFactory pageIndexerFactory, TypeManager typeManager, HiveConfig config, LocationService locationService, JsonCodec<PartitionUpdate> partitionUpdateCodec, JsonCodec<CarbondataSegmentInfoUtil> carbondataSegmentInfoCodec, NodeManager nodeManager, EventClient eventClient, HiveSessionProperties hiveSessionProperties, HiveWriterStats hiveWriterStats, OrcFileWriterFactory orcFileWriterFactory) {
        super(fileWriterFactories, hdfsEnvironment, pageSorter, metastore, pageIndexerFactory, typeManager, config, locationService, partitionUpdateCodec, nodeManager, eventClient, hiveSessionProperties, hiveWriterStats, orcFileWriterFactory);
        this.fileWriterFactories = ImmutableSet.copyOf((Collection)Objects.requireNonNull(fileWriterFactories, "fileWriterFactories is null"));
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.pageSorter = Objects.requireNonNull(pageSorter, "pageSorter is null");
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
        this.pageIndexerFactory = Objects.requireNonNull(pageIndexerFactory, "pageIndexerFactory is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.maxOpenPartitions = config.getMaxPartitionsPerWriter();
        this.maxOpenSortFiles = config.getMaxOpenSortFiles();
        this.writerSortBufferSize = Objects.requireNonNull(config.getWriterSortBufferSize(), "writerSortBufferSize is null");
        this.immutablePartitions = config.isImmutablePartitions();
        this.locationService = Objects.requireNonNull(locationService, "locationService is null");
        this.writeVerificationExecutor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(config.getWriteValidationThreads(), Threads.daemonThreadsNamed((String)"hive-write-validation-%s")));
        this.partitionUpdateCodec = Objects.requireNonNull(partitionUpdateCodec, "partitionUpdateCodec is null");
        this.carbondataSegmentInfoCodec = Objects.requireNonNull(carbondataSegmentInfoCodec, "carbondataSegmentInfoCodec is null");
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.eventClient = Objects.requireNonNull(eventClient, "eventClient is null");
        this.hiveSessionProperties = Objects.requireNonNull(hiveSessionProperties, "hiveSessionProperties is null");
        this.hiveWriterStats = Objects.requireNonNull(hiveWriterStats, "stats is null");
        this.orcFileWriterFactory = Objects.requireNonNull(orcFileWriterFactory, "orcFileWriterFactory is null");
        this.perTransactionMetastoreCacheMaximumSize = config.getPerTransactionMetastoreCacheMaximumSize();
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorInsertTableHandle tableHandle) {
        CarbondataInsertTableHandle handle = (CarbondataInsertTableHandle)tableHandle;
        if (handle.getIsOverwrite()) {
            return this.createPageSink((HiveWritableTableHandle)handle, session, HiveACIDWriteType.INSERT_OVERWRITE, (Map<String, String>)ImmutableMap.of(), handle.getAdditionalConf(), false);
        }
        return this.createPageSink((HiveWritableTableHandle)handle, session, HiveACIDWriteType.INSERT, (Map<String, String>)ImmutableMap.of(), handle.getAdditionalConf(), false);
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorUpdateTableHandle tableHandle) {
        CarbondataUpdateTableHandle handle = (CarbondataUpdateTableHandle)tableHandle;
        return this.createPageSink((HiveWritableTableHandle)handle, session, HiveACIDWriteType.UPDATE, (Map<String, String>)ImmutableMap.of(), handle.getAdditionalConf(), false);
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorDeleteAsInsertTableHandle tableHandle) {
        CarbonDeleteAsInsertTableHandle handle = (CarbonDeleteAsInsertTableHandle)tableHandle;
        return this.createPageSink((HiveWritableTableHandle)handle, session, HiveACIDWriteType.DELETE, (Map<String, String>)ImmutableMap.of(), handle.getAdditionalConf(), false);
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorOutputTableHandle tableHandle) {
        CarbondataOutputTableHandle handle = (CarbondataOutputTableHandle)tableHandle;
        return this.createPageSink((HiveWritableTableHandle)handle, session, HiveACIDWriteType.INSERT, (Map<String, String>)ImmutableMap.of(), handle.getAdditionalConf(), true);
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorVacuumTableHandle tableHandle) {
        CarbondataVacuumTableHandle vacuumTableHandle = (CarbondataVacuumTableHandle)tableHandle;
        HiveVacuumTableHandle hiveVacuumTableHandle = new HiveVacuumTableHandle(vacuumTableHandle.getSchemaName(), vacuumTableHandle.getTableName(), vacuumTableHandle.getInputColumns(), vacuumTableHandle.getPageSinkMetadata(), vacuumTableHandle.getLocationHandle(), vacuumTableHandle.getBucketProperty(), vacuumTableHandle.getTableStorageFormat(), vacuumTableHandle.getPartitionStorageFormat(), vacuumTableHandle.isFullVacuum(), vacuumTableHandle.isUnifyVacuum(), null);
        return this.createPageSink((HiveWritableTableHandle)hiveVacuumTableHandle, session, HiveACIDWriteType.VACUUM, (Map<String, String>)ImmutableMap.of(), vacuumTableHandle.getAdditionalConf(), false);
    }

    private ConnectorPageSink createPageSink(HiveWritableTableHandle handle, ConnectorSession session, HiveACIDWriteType acidWriteType, Map<String, String> additionalTableParameters, Map<String, String> additionalConf, boolean isCreateTable) {
        OptionalInt bucketCount = OptionalInt.empty();
        Object sortedBy = ImmutableList.of();
        if (handle.getBucketProperty().isPresent()) {
            bucketCount = OptionalInt.of(((HiveBucketProperty)handle.getBucketProperty().get()).getBucketCount());
            sortedBy = ((HiveBucketProperty)handle.getBucketProperty().get()).getSortedBy();
        }
        CarbondataWriterFactory writerFactory = new CarbondataWriterFactory(this.fileWriterFactories, handle.getSchemaName(), handle.getTableName(), isCreateTable, acidWriteType, handle.getInputColumns(), handle.getTableStorageFormat(), handle.getPartitionStorageFormat(), additionalTableParameters, bucketCount, (List<SortingColumn>)sortedBy, handle.getLocationHandle(), this.locationService, session.getQueryId(), new HivePageSinkMetadataProvider(handle.getPageSinkMetadata(), (HiveMetastore)CachingHiveMetastore.memoizeMetastore((HiveMetastore)this.metastore, (long)this.perTransactionMetastoreCacheMaximumSize), new HiveIdentity(session)), this.typeManager, this.hdfsEnvironment, this.pageSorter, this.writerSortBufferSize, this.maxOpenSortFiles, this.immutablePartitions, session, this.nodeManager, this.eventClient, this.hiveSessionProperties, this.hiveWriterStats, this.orcFileWriterFactory, additionalConf);
        return new CarbondataPageSink(writerFactory, handle.getInputColumns(), handle.getBucketProperty(), this.pageIndexerFactory, this.typeManager, this.hdfsEnvironment, this.maxOpenPartitions, this.writeVerificationExecutor, this.partitionUpdateCodec, this.carbondataSegmentInfoCodec, session, acidWriteType, handle, additionalConf);
    }
}

