/*
 * Decompiled with CFR 0.152.
 */
package io.hetu.core.plugin.carbondata;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import io.hetu.core.plugin.carbondata.CarbondataHetuFilterUtil;
import io.hetu.core.plugin.carbondata.CarbondataVectorBatch;
import io.hetu.core.plugin.carbondata.HetuCarbondataReadSupport;
import io.hetu.core.plugin.carbondata.HetuCarbondataVectorizedRecordReader;
import io.hetu.core.plugin.carbondata.Types;
import io.hetu.core.plugin.carbondata.impl.CarbondataLocalMultiBlockSplit;
import io.hetu.core.plugin.carbondata.readers.HetuCoreVectorBlockBuilder;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.HiveColumnHandle;
import io.prestosql.plugin.hive.HiveSplit;
import io.prestosql.plugin.hive.HiveTableHandle;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.Page;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.LazyBlock;
import io.prestosql.spi.block.LazyBlockLoader;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorPageSource;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.predicate.TupleDomain;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.carbondata.common.CarbonIterator;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.index.IndexFilter;
import org.apache.carbondata.core.keygenerator.directdictionary.DirectDictionaryGenerator;
import org.apache.carbondata.core.keygenerator.directdictionary.DirectDictionaryKeyGeneratorFactory;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.datatype.StructField;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.TableInfo;
import org.apache.carbondata.core.scan.executor.QueryExecutor;
import org.apache.carbondata.core.scan.executor.QueryExecutorFactory;
import org.apache.carbondata.core.scan.model.ProjectionDimension;
import org.apache.carbondata.core.scan.model.ProjectionMeasure;
import org.apache.carbondata.core.scan.model.QueryModel;
import org.apache.carbondata.core.scan.result.iterator.AbstractDetailQueryResultIterator;
import org.apache.carbondata.core.scan.result.vector.impl.CarbonColumnVectorImpl;
import org.apache.carbondata.core.statusmanager.FileFormat;
import org.apache.carbondata.core.util.CarbonTimeStatisticsFactory;
import org.apache.carbondata.hadoop.CarbonInputSplit;
import org.apache.carbondata.hadoop.CarbonMultiBlockSplit;
import org.apache.carbondata.hadoop.CarbonProjection;
import org.apache.carbondata.hadoop.api.CarbonTableInputFormat;
import org.apache.carbondata.hadoop.stream.StreamRecordReader;
import org.apache.carbondata.processing.loading.exception.CarbonDataLoadingException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.log4j.Logger;

public class CarbondataPageSource
implements ConnectorPageSource {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)CarbondataPageSource.class.getName());
    private final HdfsEnvironment hdfsEnvironment;
    private final String user;
    ConnectorTableHandle tableHandle;
    private HiveSplit split;
    private CarbonTable carbonTable;
    private String queryId;
    private Configuration hadoopConf;
    private FileFormat fileFormat;
    private List<ColumnHandle> columnHandles;
    private int columnCount;
    private boolean closed;
    private long sizeOfData;
    private int batchId;
    private long nanoStart;
    private long nanoEnd;
    private HetuCarbondataReadSupport readSupport;
    private HetuCarbondataVectorizedRecordReader vectorReader;
    private boolean isDirectVectorFill;
    private StreamRecordReader rowReader;
    private StructField[] fields;
    private int batchSize = 100;
    private DataType[] dataTypes;
    private boolean isFrstPage = true;
    private boolean isFullAcidTable;
    boolean hasAcidFields;

    CarbondataPageSource(CarbonTable carbonTable, String queryId, HiveSplit split, List<ColumnHandle> columnHandles, ConnectorTableHandle tableHandle, Configuration hadoopConf, boolean isDirectVectorFill, boolean isFullAcidTable, String user, HdfsEnvironment hdfsEnvironment) {
        this.carbonTable = carbonTable;
        this.queryId = queryId;
        this.split = split;
        this.columnHandles = columnHandles;
        this.hadoopConf = hadoopConf;
        this.isDirectVectorFill = isDirectVectorFill;
        this.tableHandle = tableHandle;
        this.isFullAcidTable = isFullAcidTable;
        this.hasAcidFields = false;
        this.user = user;
        this.hdfsEnvironment = hdfsEnvironment;
        this.initialize();
    }

    private void initialize() {
        CarbonMultiBlockSplit carbonInputSplit = CarbondataLocalMultiBlockSplit.convertSplit(this.split.getSchema().getProperty("carbonSplit"));
        this.fileFormat = carbonInputSplit.getFileFormat();
        if (this.fileFormat.ordinal() == FileFormat.ROW_V1.ordinal()) {
            this.initializeForRow();
        } else {
            this.initializeForColumnar();
        }
    }

    private void initializeForColumnar() {
        this.readSupport = new HetuCarbondataReadSupport();
        this.vectorReader = this.createReaderForColumnar(this.split, this.columnHandles, this.tableHandle, this.readSupport, this.hadoopConf);
    }

    private void initializeForRow() {
        QueryModel queryModel = this.createQueryModel(this.split, this.tableHandle, this.columnHandles, this.hadoopConf);
        this.rowReader = new StreamRecordReader(queryModel, false);
        List queryDimension = queryModel.getProjectionDimensions();
        List queryMeasures = queryModel.getProjectionMeasures();
        this.fields = new StructField[queryDimension.size() + queryMeasures.size()];
        for (int i = 0; i < queryDimension.size(); ++i) {
            ProjectionDimension dim = (ProjectionDimension)queryDimension.get(i);
            if (dim.getDimension().isComplex().booleanValue()) {
                this.fields[dim.getOrdinal()] = new StructField(dim.getColumnName(), dim.getDimension().getDataType());
                continue;
            }
            if (dim.getDimension().getDataType() == DataTypes.DATE) {
                DirectDictionaryGenerator generator = DirectDictionaryKeyGeneratorFactory.getDirectDictionaryGenerator((DataType)dim.getDimension().getDataType());
                this.fields[dim.getOrdinal()] = new StructField(dim.getColumnName(), generator.getReturnType());
                continue;
            }
            this.fields[dim.getOrdinal()] = new StructField(dim.getColumnName(), dim.getDimension().getDataType());
        }
        for (ProjectionMeasure msr : queryMeasures) {
            DataType dataType = msr.getMeasure().getDataType();
            if (dataType == DataTypes.BOOLEAN || dataType == DataTypes.SHORT || dataType == DataTypes.INT || dataType == DataTypes.LONG) {
                this.fields[msr.getOrdinal()] = new StructField(msr.getColumnName(), msr.getMeasure().getDataType());
                continue;
            }
            if (DataTypes.isDecimal((DataType)dataType)) {
                this.fields[msr.getOrdinal()] = new StructField(msr.getColumnName(), msr.getMeasure().getDataType());
                continue;
            }
            this.fields[msr.getOrdinal()] = new StructField(msr.getColumnName(), DataTypes.DOUBLE);
        }
        this.columnCount = this.columnHandles.size();
        this.readSupport = new HetuCarbondataReadSupport();
        this.readSupport.initialize(queryModel.getProjectionColumns(), queryModel.getTable());
        this.dataTypes = this.readSupport.getDataTypes();
    }

    public long getCompletedBytes() {
        return this.sizeOfData;
    }

    public long getReadTimeNanos() {
        return this.nanoStart > 0L ? (this.nanoEnd == 0L ? System.nanoTime() : this.nanoEnd) - this.nanoStart : 0L;
    }

    public boolean isFinished() {
        return this.closed;
    }

    public Page getNextPage() {
        return (Page)this.hdfsEnvironment.doAs(this.user, () -> {
            if (this.fileFormat.ordinal() == FileFormat.ROW_V1.ordinal()) {
                return this.getNextPageForRow();
            }
            return this.getNextPageForColumnar();
        });
    }

    private Page getNextPageForColumnar() {
        if (this.nanoStart == 0L) {
            this.nanoStart = System.nanoTime();
        }
        CarbondataVectorBatch columnarBatch = null;
        int columnBatchSize = 0;
        try {
            ++this.batchId;
            if (this.vectorReader.nextKeyValue()) {
                Object vectorBatch = this.vectorReader.getCurrentValue();
                if (vectorBatch instanceof CarbondataVectorBatch && (columnBatchSize = (columnarBatch = (CarbondataVectorBatch)vectorBatch).numRows()) == 0) {
                    this.close();
                    return null;
                }
            } else {
                this.close();
                return null;
            }
            if (columnarBatch == null) {
                return null;
            }
            Block[] blocks = new Block[this.columnHandles.size()];
            for (int column = 0; column < blocks.length; ++column) {
                blocks[column] = new LazyBlock(columnBatchSize, (LazyBlockLoader)new CarbondataBlockLoader(column));
            }
            Page page = new Page(columnBatchSize, blocks);
            return page;
        }
        catch (PrestoException e) {
            this.closeWithSuppression(e);
            throw e;
        }
        catch (RuntimeException e) {
            this.closeWithSuppression(e);
            throw new CarbonDataLoadingException("Exception when creating the Carbon data Block", (Throwable)e);
        }
    }

    private Page getNextPageForRow() {
        if (this.isFrstPage) {
            this.isFrstPage = false;
            this.initialReaderForRow();
        }
        if (this.nanoStart == 0L) {
            this.nanoStart = System.nanoTime();
        }
        int count = 0;
        try {
            Block[] blocks = new Block[this.columnCount];
            CarbonColumnVectorImpl[] columns = new CarbonColumnVectorImpl[this.columnCount];
            for (int i = 0; i < this.columnCount; ++i) {
                columns[i] = CarbondataVectorBatch.createDirectStreamReader(this.batchSize, this.dataTypes[i], this.fields[i], -1, false);
            }
            while (this.rowReader.nextKeyValue()) {
                Object[] values = (Object[])this.rowReader.getCurrentValue();
                for (int index = 0; index < this.columnCount; ++index) {
                    columns[index].putObject(count, values[index]);
                }
                if (++count != this.batchSize) continue;
                break;
            }
            if (count == 0) {
                this.close();
                return null;
            }
            for (int index = 0; index < this.columnCount; ++index) {
                blocks[index] = ((HetuCoreVectorBlockBuilder)columns[index]).buildBlock();
                this.sizeOfData += blocks[index].getSizeInBytes();
            }
            return new Page(count, blocks);
        }
        catch (PrestoException e) {
            this.closeWithSuppression(e);
            throw e;
        }
        catch (IOException | RuntimeException e) {
            this.closeWithSuppression(e);
            throw new CarbonDataLoadingException("Exception when reading the Carbon data Block", (Throwable)e);
        }
    }

    private void initialReaderForRow() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmm");
        String jobTrackerId = formatter.format(new Date());
        TaskAttemptID attemptId = new TaskAttemptID(jobTrackerId, 0, TaskType.MAP, 0, 0);
        TaskAttemptContextImpl attemptContext = new TaskAttemptContextImpl(FileFactory.getConfiguration(), attemptId);
        CarbonMultiBlockSplit carbonInputSplit = CarbondataLocalMultiBlockSplit.convertSplit(this.split.getSchema().getProperty("carbonSplit"));
        try {
            this.rowReader.initialize((InputSplit)carbonInputSplit, (TaskAttemptContext)attemptContext);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public long getSystemMemoryUsage() {
        return this.sizeOfData;
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            if (this.vectorReader != null) {
                this.vectorReader.close();
            }
            if (this.rowReader != null) {
                this.rowReader.close();
            }
            this.nanoEnd = System.nanoTime();
        }
        catch (IOException e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, (Throwable)e);
        }
    }

    private void closeWithSuppression(Throwable throwable) {
        block2: {
            Objects.requireNonNull(throwable, "throwable is null");
            try {
                this.close();
            }
            catch (RuntimeException e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
                if (throwable == e) break block2;
                throwable.addSuppressed(e);
            }
        }
    }

    private HetuCarbondataVectorizedRecordReader createReaderForColumnar(HiveSplit carbonSplit, List<? extends ColumnHandle> columns, ConnectorTableHandle tableHandle, HetuCarbondataReadSupport readSupport, Configuration conf) {
        QueryModel queryModel = this.createQueryModel(carbonSplit, tableHandle, columns, conf);
        QueryExecutor queryExecutor = QueryExecutorFactory.getQueryExecutor((QueryModel)queryModel, (Configuration)new Configuration(conf));
        try {
            CarbonIterator iterator = queryExecutor.execute(queryModel);
            readSupport.initialize(queryModel.getProjectionColumns(), queryModel.getTable());
            HetuCarbondataVectorizedRecordReader reader = new HetuCarbondataVectorizedRecordReader(queryExecutor, queryModel, (AbstractDetailQueryResultIterator)iterator, readSupport, columns);
            reader.setTaskId(Long.parseLong(carbonSplit.getSchema().getProperty("index")));
            return reader;
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Failed to create reader ", (Throwable)e);
        }
    }

    private QueryModel createQueryModel(HiveSplit carbondataSplit, ConnectorTableHandle tableHandle, List<? extends ColumnHandle> columns, Configuration conf) {
        try {
            CarbonProjection carbonProjection = this.getCarbonProjection(columns);
            conf.set("mapreduce.input.carboninputformat.segmentnumbers", "");
            String carbonTablePath = this.carbonTable.getAbsoluteTableIdentifier().getTablePath();
            CarbonTableInputFormat.setTransactionalTable((Configuration)conf, (boolean)this.carbonTable.getTableInfo().isTransactionalTable());
            CarbonTableInputFormat.setTableInfo((Configuration)conf, (TableInfo)this.carbonTable.getTableInfo());
            conf.set("mapreduce.input.fileinputformat.inputdir", carbonTablePath);
            conf.set("query.id", this.queryId);
            JobConf jobConf = new JobConf(conf);
            HiveTableHandle hiveTable = (HiveTableHandle)tableHandle;
            CarbonTableInputFormat<Object> carbonTableInputFormat = this.createInputFormat((Configuration)jobConf, this.carbonTable, new IndexFilter(this.carbonTable, CarbondataHetuFilterUtil.parseFilterExpression((TupleDomain<HiveColumnHandle>)hiveTable.getCompactEffectivePredicate())), carbonProjection);
            TaskAttemptContextImpl hadoopAttemptContext = new TaskAttemptContextImpl((Configuration)jobConf, new TaskAttemptID("", 1, TaskType.MAP, 0, 0));
            CarbonMultiBlockSplit carbonInputSplit = CarbondataLocalMultiBlockSplit.convertSplit(carbondataSplit.getSchema().getProperty("carbonSplit"));
            QueryModel queryModel = carbonTableInputFormat.createQueryModel((InputSplit)carbonInputSplit, (TaskAttemptContext)hadoopAttemptContext);
            queryModel.setQueryId(this.queryId);
            queryModel.setVectorReader(true);
            queryModel.setStatisticsRecorder(CarbonTimeStatisticsFactory.createExecutorRecorder((String)queryModel.getQueryId()));
            List tableBlockInfoList = CarbonInputSplit.createBlocks((List)carbonInputSplit.getAllSplits());
            queryModel.setTableBlockInfos(tableBlockInfoList);
            return queryModel;
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Unable to get the Query Model ", (Throwable)e);
        }
    }

    private CarbonTableInputFormat<Object> createInputFormat(Configuration conf, CarbonTable carbonTable, IndexFilter dataMapFilter, CarbonProjection projection) {
        AbsoluteTableIdentifier identifier = carbonTable.getAbsoluteTableIdentifier();
        CarbonTableInputFormat format = new CarbonTableInputFormat();
        try {
            CarbonTableInputFormat.setTablePath((Configuration)conf, (String)identifier.appendWithLocalPrefix(identifier.getTablePath()));
            CarbonTableInputFormat.setDatabaseName((Configuration)conf, (String)identifier.getCarbonTableIdentifier().getDatabaseName());
            CarbonTableInputFormat.setTableName((Configuration)conf, (String)identifier.getCarbonTableIdentifier().getTableName());
        }
        catch (RuntimeException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Unable to create the CarbonTableInputFormat", (Throwable)e);
        }
        CarbonTableInputFormat.setFilterPredicates((Configuration)conf, (IndexFilter)dataMapFilter);
        CarbonTableInputFormat.setColumnProjection((Configuration)conf, (CarbonProjection)projection);
        return format;
    }

    private CarbonProjection getCarbonProjection(List<? extends ColumnHandle> columns) {
        CarbonProjection carbonProjection = new CarbonProjection();
        ImmutableList.Builder handles = ImmutableList.builder();
        for (ColumnHandle columnHandle : columns) {
            handles.add((Object)Types.checkType(columnHandle, HiveColumnHandle.class, "handle"));
            if (((HiveColumnHandle)columnHandle).getName().equalsIgnoreCase("tupleId")) {
                this.hasAcidFields = true;
            }
            carbonProjection.addColumn(((HiveColumnHandle)columnHandle).getName());
        }
        return carbonProjection;
    }

    public CarbonTable getCarbonTable() {
        return this.carbonTable;
    }

    public HdfsEnvironment getHdfsEnvironment() {
        return this.hdfsEnvironment;
    }

    private final class CarbondataBlockLoader
    implements LazyBlockLoader<LazyBlock> {
        private final int expectedBatchId;
        private final int columnIndex;
        private boolean loaded;

        CarbondataBlockLoader(int columnIndex) {
            this.expectedBatchId = CarbondataPageSource.this.batchId;
            this.columnIndex = columnIndex;
        }

        public final void load(LazyBlock lazyBlock) {
            if (this.loaded) {
                return;
            }
            Preconditions.checkState((CarbondataPageSource.this.batchId == this.expectedBatchId ? 1 : 0) != 0);
            try {
                CarbondataPageSource.this.vectorReader.getColumnarBatch().column(this.columnIndex).loadPage();
                HetuCoreVectorBlockBuilder blockBuilder = (HetuCoreVectorBlockBuilder)CarbondataPageSource.this.vectorReader.getColumnarBatch().column(this.columnIndex);
                blockBuilder.setBatchSize(lazyBlock.getPositionCount());
                Block block = blockBuilder.buildBlock();
                CarbondataPageSource.this.sizeOfData = CarbondataPageSource.this.sizeOfData + block.getSizeInBytes();
                lazyBlock.setBlock(block);
            }
            catch (RuntimeException e) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Error in Reading Data from Carbondata ", (Throwable)e);
            }
            this.loaded = true;
        }
    }
}

