/*
 * Decompiled with CFR 0.152.
 */
package io.hetu.core.plugin.carbondata;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import io.hetu.core.plugin.carbondata.CarbondataPageSource;
import io.hetu.core.plugin.carbondata.Types;
import io.hetu.core.plugin.carbondata.impl.CarbondataTableCacheModel;
import io.hetu.core.plugin.carbondata.impl.CarbondataTableReader;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.HiveConfig;
import io.prestosql.plugin.hive.HivePageSourceFactory;
import io.prestosql.plugin.hive.HivePageSourceProvider;
import io.prestosql.plugin.hive.HiveRecordCursorProvider;
import io.prestosql.plugin.hive.HiveSplit;
import io.prestosql.plugin.hive.HiveSplitWrapper;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorPageSource;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorSplit;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.dynamicfilter.DynamicFilterSupplier;
import io.prestosql.spi.type.TypeManager;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.util.ThreadLocalSessionInfo;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.AcidUtils;

public class CarbondataPageSourceProvider
extends HivePageSourceProvider {
    private CarbondataTableReader carbonTableReader;
    private String queryId;
    private HdfsEnvironment hdfsEnvironment;

    @Inject
    public CarbondataPageSourceProvider(HiveConfig hiveConfig, HdfsEnvironment hdfsEnvironment, Set<HiveRecordCursorProvider> cursorProviders, Set<HivePageSourceFactory> pageSourceFactories, TypeManager typeManager, CarbondataTableReader carbonTableReader) {
        super(hiveConfig, hdfsEnvironment, cursorProviders, pageSourceFactories, typeManager, null, null);
        this.carbonTableReader = Objects.requireNonNull(carbonTableReader, "carbonTableReader is null");
        this.hdfsEnvironment = hdfsEnvironment;
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorSplit split, ConnectorTableHandle table, List<ColumnHandle> columns) {
        HiveSplit carbonSplit = Types.checkType(((HiveSplitWrapper)split).getSplits().get(0), HiveSplit.class, "split is not class HiveSplit");
        this.queryId = carbonSplit.getSchema().getProperty("queryId");
        if (this.queryId == null) {
            return super.createPageSource(transactionHandle, session, split, table, columns);
        }
        try {
            this.hdfsEnvironment.getFileSystem(new HdfsEnvironment.HdfsContext(session, carbonSplit.getDatabase()), new Path(carbonSplit.getSchema().getProperty("tablePath")));
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Failed to get file system: " + e.getMessage());
        }
        return (ConnectorPageSource)this.hdfsEnvironment.doAs(session.getUser(), () -> {
            Configuration configuration = this.hdfsEnvironment.getConfiguration(new HdfsEnvironment.HdfsContext(session, carbonSplit.getDatabase(), carbonSplit.getTable()), new Path(carbonSplit.getSchema().getProperty("tablePath")));
            CarbonTable carbonTable = this.getCarbonTable(carbonSplit, configuration);
            ThreadLocalSessionInfo.setConfigurationToCurrentThread((Configuration)configuration);
            boolean isFullACID = AcidUtils.isFullAcidTable((Map)Maps.fromProperties((Properties)carbonSplit.getSchema()));
            boolean isDirectVectorFill = this.carbonTableReader.config.getPushRowFilter() == null || this.carbonTableReader.config.getPushRowFilter().equalsIgnoreCase("false") || columns.stream().anyMatch(c -> c.getColumnName().equalsIgnoreCase("tupleId"));
            return new CarbondataPageSource(carbonTable, this.queryId, carbonSplit, columns, table, configuration, isDirectVectorFill, isFullACID, session.getUser(), this.hdfsEnvironment);
        });
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorSplit split, ConnectorTableHandle table, List<ColumnHandle> columns, Optional<DynamicFilterSupplier> supplier) {
        return this.createPageSource(transactionHandle, session, split, table, columns);
    }

    private CarbonTable getCarbonTable(HiveSplit carbonSplit, Configuration configuration) {
        CarbondataTableCacheModel tableCacheModel = this.carbonTableReader.getCarbonCache(new SchemaTableName(carbonSplit.getDatabase(), carbonSplit.getTable()), carbonSplit.getSchema().getProperty("tablePath"), configuration);
        Objects.requireNonNull(tableCacheModel, "tableCacheModel should not be null");
        Objects.requireNonNull(tableCacheModel.getCarbonTable(), "tableCacheModel.carbonTable should not be null");
        Objects.requireNonNull(tableCacheModel.getCarbonTable().getTableInfo(), "tableCacheModel.carbonTable.tableInfo should not be null");
        return tableCacheModel.getCarbonTable();
    }
}

