/*
 * Decompiled with CFR 0.152.
 */
package io.hetu.core.plugin.carbondata;

import com.google.common.collect.ImmutableList;
import io.hetu.core.plugin.carbondata.CarbondataConnectorFactory;
import io.prestosql.plugin.hive.HivePlugin;
import io.prestosql.plugin.hive.metastore.thrift.StaticMetastoreConfig;
import io.prestosql.spi.connector.ConnectorFactory;
import io.prestosql.spi.function.ConnectorConfig;
import io.prestosql.spi.queryeditorui.ConnectorUtil;
import io.prestosql.spi.queryeditorui.ConnectorWithProperties;
import java.util.Arrays;
import java.util.Optional;
import org.apache.carbondata.core.datastore.impl.FileFactory;

@ConnectorConfig(connectorLabel="Carbondata: Query data stored in a Carbondata warehouse", propertiesEnabled=true, catalogConfigFilesEnabled=true, globalConfigFilesEnabled=true, docLink="https://openlookeng.io/zh-cn/docs/docs/connector/carbondata.html", configLink="https://openlookeng.io/zh-cn/docs/docs/connector/carbondata.html#configuration")
public class CarbondataPlugin
extends HivePlugin {
    public CarbondataPlugin() {
        super("carbondata");
    }

    private static ClassLoader getClassLoader() {
        return FileFactory.class.getClassLoader();
    }

    public Iterable<ConnectorFactory> getConnectorFactories() {
        return ImmutableList.of((Object)((Object)new CarbondataConnectorFactory("carbondata", CarbondataPlugin.getClassLoader())));
    }

    public Optional<ConnectorWithProperties> getConnectorWithProperties() {
        ConnectorConfig connectorConfig = CarbondataPlugin.class.getAnnotation(ConnectorConfig.class);
        return ConnectorUtil.assembleConnectorProperties((ConnectorConfig)connectorConfig, Arrays.asList(StaticMetastoreConfig.class.getDeclaredMethods()));
    }
}

