/*
 * Decompiled with CFR 0.152.
 */
package io.hetu.core.plugin.carbondata;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import io.hetu.core.plugin.carbondata.CarbondataConfig;
import io.hetu.core.plugin.carbondata.CarbondataHetuCompactorUtil;
import io.hetu.core.plugin.carbondata.CarbondataHetuFilterUtil;
import io.hetu.core.plugin.carbondata.impl.CarbondataLocalInputSplit;
import io.hetu.core.plugin.carbondata.impl.CarbondataLocalMultiBlockSplit;
import io.hetu.core.plugin.carbondata.impl.CarbondataTableCacheModel;
import io.hetu.core.plugin.carbondata.impl.CarbondataTableConfig;
import io.hetu.core.plugin.carbondata.impl.CarbondataTableReader;
import io.prestosql.plugin.hive.CoercionPolicy;
import io.prestosql.plugin.hive.DirectoryLister;
import io.prestosql.plugin.hive.ForHive;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.HiveColumnHandle;
import io.prestosql.plugin.hive.HiveConfig;
import io.prestosql.plugin.hive.HivePartitionManager;
import io.prestosql.plugin.hive.HiveSplit;
import io.prestosql.plugin.hive.HiveSplitManager;
import io.prestosql.plugin.hive.HiveSplitWrapper;
import io.prestosql.plugin.hive.HiveTableHandle;
import io.prestosql.plugin.hive.HiveTransactionHandle;
import io.prestosql.plugin.hive.NamenodeStats;
import io.prestosql.plugin.hive.authentication.HiveIdentity;
import io.prestosql.plugin.hive.metastore.MetastoreUtil;
import io.prestosql.plugin.hive.metastore.SemiTransactionalHiveMetastore;
import io.prestosql.plugin.hive.metastore.Table;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.HostAddress;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.VersionEmbedder;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorSplit;
import io.prestosql.spi.connector.ConnectorSplitManager;
import io.prestosql.spi.connector.ConnectorSplitSource;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.connector.FixedSplitSource;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.connector.TableNotFoundException;
import io.prestosql.spi.dynamicfilter.DynamicFilter;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.resourcegroups.QueryType;
import io.prestosql.spi.type.TypeManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.scan.expression.Expression;
import org.apache.carbondata.core.stats.QueryStatistic;
import org.apache.carbondata.core.stats.QueryStatisticsRecorder;
import org.apache.carbondata.core.statusmanager.LoadMetadataDetails;
import org.apache.carbondata.core.util.CarbonTimeStatisticsFactory;
import org.apache.carbondata.core.util.ThreadLocalSessionInfo;
import org.apache.carbondata.hadoop.CarbonInputSplit;
import org.apache.carbondata.hive.util.HiveCarbonUtil;
import org.apache.carbondata.processing.loading.model.CarbonLoadModel;
import org.apache.carbondata.processing.merger.CarbonDataMergerUtil;
import org.apache.carbondata.processing.merger.CompactionType;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;

public class CarbondataSplitManager
extends HiveSplitManager {
    private final CarbondataTableReader carbonTableReader;
    private final Function<HiveTransactionHandle, SemiTransactionalHiveMetastore> metastoreProvider;
    private final HdfsEnvironment hdfsEnvironment;
    private final CarbondataTableConfig carbondataTableConfig;
    private final CarbondataConfig carbondataConfig;
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)CarbondataSplitManager.class.getName());

    @Inject
    public CarbondataSplitManager(HiveConfig hiveConfig, Function<HiveTransactionHandle, SemiTransactionalHiveMetastore> metastoreProvider, HivePartitionManager partitionManager, NamenodeStats namenodeStats, HdfsEnvironment hdfsEnvironment, DirectoryLister directoryLister, @ForHive ExecutorService executorService, VersionEmbedder versionEmbedder, TypeManager typeManager, CoercionPolicy coercionPolicy, CarbondataTableReader reader, CarbondataTableConfig carbondataTableConfig, CarbondataConfig carbondataConfig) {
        super(hiveConfig, metastoreProvider, partitionManager, namenodeStats, hdfsEnvironment, directoryLister, executorService, versionEmbedder, typeManager, coercionPolicy);
        this.carbonTableReader = Objects.requireNonNull(reader, "client is null");
        this.metastoreProvider = Objects.requireNonNull(metastoreProvider, "metastore is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.carbondataTableConfig = Objects.requireNonNull(carbondataTableConfig, "carbonTableConfig is null");
        this.carbondataConfig = Objects.requireNonNull(carbondataConfig, "carbondataConfig is null");
    }

    private static List<HostAddress> getHostAddresses(String[] hosts) {
        return (List)Arrays.stream(hosts).map(HostAddress::fromString).collect(ImmutableList.toImmutableList());
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorTableHandle tableHandle, ConnectorSplitManager.SplitSchedulingStrategy splitSchedulingStrategy, Supplier<List<Set<DynamicFilter>>> dynamicFilterSupplier, Optional<QueryType> queryType, Map<String, Object> queryProperties, Set<TupleDomain<ColumnMetadata>> userDefinedCachePredicates, boolean partOfReuse) {
        HiveTableHandle hiveTable = (HiveTableHandle)tableHandle;
        SchemaTableName schemaTableName = hiveTable.getSchemaTableName();
        HiveIdentity identity = new HiveIdentity(session);
        SemiTransactionalHiveMetastore metastore = this.metastoreProvider.apply((HiveTransactionHandle)transactionHandle);
        Table table = (Table)metastore.getTable(identity, schemaTableName.getSchemaName(), schemaTableName.getTableName()).orElseThrow(() -> new TableNotFoundException(schemaTableName));
        if (!table.getStorage().getStorageFormat().getInputFormat().contains("carbon")) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Carbondata connector can only read carbondata tables");
        }
        return (ConnectorSplitSource)this.hdfsEnvironment.doAs(session.getUser(), () -> {
            String location = table.getStorage().getLocation();
            String queryId = System.nanoTime() + "";
            QueryStatistic statistic = new QueryStatistic();
            QueryStatisticsRecorder statisticRecorder = CarbonTimeStatisticsFactory.createDriverRecorder();
            statistic.addStatistics("Total Time taken in block(s) allocation", System.currentTimeMillis());
            statisticRecorder.recordStatisticsForDriver(statistic, queryId);
            statistic = new QueryStatistic();
            this.carbonTableReader.setQueryId(queryId);
            TupleDomain predicate = hiveTable.getCompactEffectivePredicate();
            Configuration configuration = this.hdfsEnvironment.getConfiguration(new HdfsEnvironment.HdfsContext(session, schemaTableName.getSchemaName(), schemaTableName.getTableName()), new Path(location));
            ThreadLocalSessionInfo.setConfigurationToCurrentThread((Configuration)configuration);
            CarbondataTableCacheModel cache = this.carbonTableReader.getCarbonCache(schemaTableName, location, configuration);
            Expression filters = CarbondataHetuFilterUtil.parseFilterExpression((TupleDomain<HiveColumnHandle>)predicate);
            try {
                List<CarbondataLocalMultiBlockSplit> splits = this.carbonTableReader.getInputSplits(cache, filters, (TupleDomain<HiveColumnHandle>)predicate, configuration);
                ImmutableList.Builder cSplits = ImmutableList.builder();
                long index = 0L;
                for (CarbondataLocalMultiBlockSplit split : splits) {
                    ++index;
                    Properties properties = new Properties();
                    for (Map.Entry entry : table.getStorage().getSerdeParameters().entrySet()) {
                        properties.setProperty((String)entry.getKey(), (String)entry.getValue());
                    }
                    properties.setProperty("tablePath", cache.getCarbonTable().getTablePath());
                    properties.setProperty("carbonSplit", split.getJsonString());
                    properties.setProperty("queryId", queryId);
                    properties.setProperty("index", String.valueOf(index));
                    cSplits.add((Object)HiveSplitWrapper.wrap((HiveSplit)new HiveSplit(schemaTableName.getSchemaName(), schemaTableName.getTableName(), schemaTableName.getTableName(), cache.getCarbonTable().getTablePath(), 0L, 0L, 0L, 0L, properties, new ArrayList(), CarbondataSplitManager.getHostAddresses(split.getLocations()), OptionalInt.empty(), false, new HashMap(), Optional.empty(), false, Optional.empty(), Optional.empty(), false, (Map)ImmutableMap.of())));
                }
                statisticRecorder.logStatisticsAsTableDriver();
                statistic.addStatistics("Time taken to identify Block(s) to scan", System.currentTimeMillis());
                statisticRecorder.recordStatisticsForDriver(statistic, queryId);
                statisticRecorder.logStatisticsAsTableDriver();
                if (queryType != null && queryType.isPresent() && ((QueryType)queryType.get()).equals((Object)QueryType.VACUUM)) {
                    return this.getSplitsForCompaction(identity, transactionHandle, tableHandle, cache.getCarbonTable().getTablePath(), queryProperties, queryId, (ImmutableList.Builder<ConnectorSplit>)cSplits, configuration);
                }
                return new FixedSplitSource((Iterable)cSplits.build());
            }
            catch (IOException ex) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Failed while trying to get splits ", (Throwable)ex);
            }
        });
    }

    public ConnectorSplitSource getSplitsForCompaction(HiveIdentity identity, ConnectorTransactionHandle transactionHandle, ConnectorTableHandle tableHandle, String tablePath, Map<String, Object> queryProperties, String queryId, ImmutableList.Builder<ConnectorSplit> allSplitsForComp, Configuration configuration) throws PrestoException {
        HiveTableHandle hiveTable = (HiveTableHandle)tableHandle;
        SchemaTableName schemaTableName = hiveTable.getSchemaTableName();
        SemiTransactionalHiveMetastore metaStore = this.metastoreProvider.apply((HiveTransactionHandle)transactionHandle);
        Table table = (Table)metaStore.getTable(identity, schemaTableName.getSchemaName(), schemaTableName.getTableName()).orElseThrow(() -> new TableNotFoundException(schemaTableName));
        Properties hiveSchema = MetastoreUtil.getHiveSchema((Table)table);
        CarbonLoadModel carbonLoadModel = null;
        try {
            carbonLoadModel = HiveCarbonUtil.getCarbonLoadModel((Properties)hiveSchema, (Configuration)configuration);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Cannot create carbon load model");
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Cannot create carbon load model");
        }
        CompactionType compactionType = queryProperties.get("FULL") == Boolean.valueOf("true") ? CompactionType.MAJOR : CompactionType.MINOR;
        List<List<LoadMetadataDetails>> allGroupedSegList = CarbondataHetuCompactorUtil.identifyAndGroupSegmentsToBeMerged(carbonLoadModel, configuration, compactionType, this.carbondataConfig.getMajorVacuumSegSize(), this.carbondataConfig.getMinorVacuumSegCount());
        ImmutableList.Builder cSplits = ImmutableList.builder();
        Gson gson = new Gson();
        for (List<LoadMetadataDetails> segmentsToBeMerged : allGroupedSegList) {
            String mergedLoadName = CarbonDataMergerUtil.getMergedLoadName(segmentsToBeMerged);
            HashMap<String, List> taskIdToSplitMapping = new HashMap<String, List>();
            for (ConnectorSplit connectorSplit : allSplitsForComp.build()) {
                HiveSplit currSplit = (HiveSplit)((HiveSplitWrapper)connectorSplit).getSplits().get(0);
                CarbondataLocalMultiBlockSplit currSplits = (CarbondataLocalMultiBlockSplit)gson.fromJson(currSplit.getSchema().getProperty("carbonSplit"), CarbondataLocalMultiBlockSplit.class);
                for (CarbondataLocalInputSplit split : currSplits.getSplitList()) {
                    CarbonInputSplit carbonInputSplit = CarbondataLocalInputSplit.convertSplit(split);
                    String taskId = carbonInputSplit.taskId;
                    String segmentNo = carbonInputSplit.getSegmentId();
                    for (LoadMetadataDetails load : segmentsToBeMerged) {
                        if (!load.getLoadName().equals(segmentNo)) continue;
                        List currList = taskIdToSplitMapping.computeIfAbsent(taskId, k -> new ArrayList());
                        currList.add(split);
                    }
                }
            }
            long index = 0L;
            for (Map.Entry splitEntry : taskIdToSplitMapping.entrySet()) {
                CarbondataLocalMultiBlockSplit currSplit = new CarbondataLocalMultiBlockSplit((List)splitEntry.getValue(), (String[])((List)splitEntry.getValue()).stream().flatMap(f -> Arrays.stream(this.getLocations((CarbondataLocalInputSplit)f))).distinct().toArray(String[]::new));
                ++index;
                Properties properties = new Properties();
                for (Map.Entry entry : table.getStorage().getSerdeParameters().entrySet()) {
                    properties.setProperty((String)entry.getKey(), (String)entry.getValue());
                }
                properties.setProperty("tablePath", tablePath);
                properties.setProperty("carbonSplit", currSplit.getJsonString());
                properties.setProperty("queryId", queryId);
                properties.setProperty("index", String.valueOf(index));
                properties.setProperty("mergeLoadName", mergedLoadName);
                properties.setProperty("compactionType", compactionType.toString());
                properties.setProperty("taskNo", (String)splitEntry.getKey());
                cSplits.add((Object)HiveSplitWrapper.wrap((HiveSplit)new HiveSplit(schemaTableName.getSchemaName(), schemaTableName.getTableName(), schemaTableName.getTableName(), tablePath, 0L, 0L, 0L, 0L, properties, new ArrayList(), CarbondataSplitManager.getHostAddresses(currSplit.getLocations()), OptionalInt.empty(), false, new HashMap(), Optional.empty(), false, Optional.empty(), Optional.empty(), false, (Map)ImmutableMap.of())));
            }
        }
        LOGGER.info((Object)"Splits for compaction built and ready");
        return new FixedSplitSource((Iterable)cSplits.build());
    }

    private String[] getLocations(CarbondataLocalInputSplit carbondataLocalInputSplit) {
        return carbondataLocalInputSplit.getLocations().toArray(new String[0]);
    }
}

