/*
 * Decompiled with CFR 0.152.
 */
package io.hetu.core.plugin.carbondata;

import io.airlift.units.DataSize;
import io.prestosql.plugin.hive.BaseStorageFormat;
import java.util.Objects;
import org.apache.carbondata.hive.CarbonHiveSerDe;
import org.apache.carbondata.hive.MapredCarbonInputFormat;
import org.apache.carbondata.hive.MapredCarbonOutputFormat;

public enum CarbondataStorageFormat implements BaseStorageFormat
{
    CARBON(CarbonHiveSerDe.class.getName(), MapredCarbonInputFormat.class.getName(), MapredCarbonOutputFormat.class.getName(), new DataSize(256.0, DataSize.Unit.MEGABYTE));

    private final String serde;
    private final String inputFormat;
    private final String outputFormat;
    private final DataSize estimatedWriterSystemMemoryUsage;

    private CarbondataStorageFormat(String serde, String inputFormat, String outputFormat, DataSize estimatedWriterSystemMemoryUsage) {
        this.serde = Objects.requireNonNull(serde, "serde is null");
        this.inputFormat = Objects.requireNonNull(inputFormat, "inputFormat is null");
        this.outputFormat = Objects.requireNonNull(outputFormat, "outputFormat is null");
        this.estimatedWriterSystemMemoryUsage = Objects.requireNonNull(estimatedWriterSystemMemoryUsage, "estimatedWriterSystemMemoryUsage is null");
    }

    public String getSerDe() {
        return this.serde;
    }

    public String getInputFormat() {
        return this.inputFormat;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public DataSize getEstimatedWriterSystemMemoryUsage() {
        return this.estimatedWriterSystemMemoryUsage;
    }
}

