/*
 * Decompiled with CFR 0.152.
 */
package io.hetu.core.plugin.carbondata;

import com.google.common.collect.ImmutableList;
import io.hetu.core.plugin.carbondata.CarbondataConfig;
import io.hetu.core.plugin.carbondata.CarbondataStorageFormat;
import io.prestosql.plugin.hive.BaseStorageFormat;
import io.prestosql.plugin.hive.HiveConfig;
import io.prestosql.plugin.hive.HiveTableProperties;
import io.prestosql.plugin.hive.metastore.SortingColumn;
import io.prestosql.spi.session.PropertyMetadata;
import io.prestosql.spi.type.TypeManager;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;

public class CarbondataTableProperties
extends HiveTableProperties {
    public static final String LOCATION_PROPERTY = "location";
    public static final String STORAGE_FORMAT_PROPERTY = "format";
    public static final String PARTITIONED_BY_PROPERTY = "partitioned_by";
    public static final String SORTED_BY_PROPERTY = "sorted_by";
    private final List<PropertyMetadata<?>> tableProperties = ImmutableList.of((Object)PropertyMetadata.stringProperty((String)"location", (String)"File system location URI for the table", null, (boolean)false), (Object)PropertyMetadata.enumProperty((String)"format", (String)"Hive storage format for the table", CarbondataStorageFormat.class, (Enum)CarbondataStorageFormat.CARBON, (boolean)false));

    @Inject
    public CarbondataTableProperties(TypeManager typeManager, CarbondataConfig config) {
        super(typeManager, (HiveConfig)config);
    }

    public List<PropertyMetadata<?>> getTableProperties() {
        return this.tableProperties;
    }

    public static Optional<String> getCarbondataLocation(Map<String, Object> tableProperties) {
        return Optional.ofNullable((String)tableProperties.get(LOCATION_PROPERTY));
    }

    public static BaseStorageFormat getCarbondataStorageFormat(Map<String, Object> tableProperties) {
        return (BaseStorageFormat)tableProperties.get(STORAGE_FORMAT_PROPERTY);
    }

    public static List<String> getPartitionedBy(Map<String, Object> tableProperties) {
        List partitionedBy = (List)tableProperties.get(PARTITIONED_BY_PROPERTY);
        return partitionedBy == null ? ImmutableList.of() : ImmutableList.copyOf((Collection)partitionedBy);
    }

    protected static List<SortingColumn> getSortedBy(Map<String, Object> tableProperties) {
        List sortedBy = (List)tableProperties.get(SORTED_BY_PROPERTY);
        return sortedBy == null ? ImmutableList.of() : ImmutableList.copyOf((Collection)sortedBy);
    }

    private static SortingColumn sortingColumnFromString(String name) {
        String finalName = name;
        SortingColumn.Order order = SortingColumn.Order.ASCENDING;
        String lower = name.toUpperCase(Locale.ENGLISH);
        if (lower.endsWith(" ASC")) {
            finalName = name.substring(0, name.length() - 4).trim();
        } else if (lower.endsWith(" DESC")) {
            finalName = name.substring(0, name.length() - 5).trim();
            order = SortingColumn.Order.DESCENDING;
        }
        return new SortingColumn(finalName, order);
    }

    private static String sortingColumnToString(SortingColumn column) {
        return column.getColumnName() + (column.getOrder() == SortingColumn.Order.DESCENDING ? " DESC" : "");
    }
}

