/*
 * Decompiled with CFR 0.152.
 */
package io.hetu.core.plugin.carbondata;

import io.hetu.core.plugin.carbondata.HetuCarbondataReadSupport;
import io.hetu.core.plugin.carbondata.readers.BooleanStreamReader;
import io.hetu.core.plugin.carbondata.readers.ByteStreamReader;
import io.hetu.core.plugin.carbondata.readers.DecimalSliceStreamReader;
import io.hetu.core.plugin.carbondata.readers.DoubleStreamReader;
import io.hetu.core.plugin.carbondata.readers.FloatStreamReader;
import io.hetu.core.plugin.carbondata.readers.IntegerStreamReader;
import io.hetu.core.plugin.carbondata.readers.LongStreamReader;
import io.hetu.core.plugin.carbondata.readers.ObjectStreamReader;
import io.hetu.core.plugin.carbondata.readers.ShortStreamReader;
import io.hetu.core.plugin.carbondata.readers.SliceStreamReader;
import io.hetu.core.plugin.carbondata.readers.TimestampStreamReader;
import io.prestosql.plugin.hive.HiveColumnHandle;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.datatype.DecimalType;
import org.apache.carbondata.core.metadata.datatype.StructField;
import org.apache.carbondata.core.scan.result.vector.impl.CarbonColumnVectorImpl;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;

public class CarbondataVectorBatch {
    private static final int DEFAULT_BATCH_SIZE = 4096;
    private final int capacity;
    private final CarbonColumnVectorImpl[] columns;
    private final boolean[] filteredRows;
    private final Set<Integer> nullFilteredColumns;
    private int numRows;
    private int numRowsFiltered;

    private CarbondataVectorBatch(StructField[] schema, HetuCarbondataReadSupport readSupport, int maxRows, List<HiveColumnHandle> columnHandle) {
        this.capacity = maxRows;
        this.columns = new CarbonColumnVectorImpl[schema.length];
        this.nullFilteredColumns = new HashSet<Integer>();
        this.filteredRows = new boolean[maxRows];
        DataType[] dataTypes = readSupport.getDataTypes();
        for (int i = 0; i < schema.length; ++i) {
            boolean isCharType = columnHandle.get(i).getHiveType().getTypeInfo() instanceof CharTypeInfo;
            int maxLength = isCharType ? ((CharTypeInfo)columnHandle.get(i).getHiveType().getTypeInfo()).getLength() : -1;
            this.columns[i] = CarbondataVectorBatch.createDirectStreamReader(maxRows, dataTypes[i], schema[i], maxLength, isCharType);
        }
        this.numRowsFiltered = 0;
    }

    public static CarbondataVectorBatch allocate(StructField[] schema, HetuCarbondataReadSupport readSupport, boolean isDirectFill, List<HiveColumnHandle> columnHandle) {
        if (isDirectFill) {
            return new CarbondataVectorBatch(schema, readSupport, 32000, columnHandle);
        }
        return new CarbondataVectorBatch(schema, readSupport, 4096, columnHandle);
    }

    public static CarbonColumnVectorImpl createDirectStreamReader(int batchSize, DataType dataType, StructField field, int maxLength, boolean isCharType) {
        if (dataType == DataTypes.BOOLEAN) {
            return new BooleanStreamReader(batchSize, field.getDataType());
        }
        if (dataType == DataTypes.SHORT) {
            return new ShortStreamReader(batchSize, field.getDataType());
        }
        if (dataType == DataTypes.INT || dataType == DataTypes.DATE) {
            return new IntegerStreamReader(batchSize, field.getDataType());
        }
        if (dataType == DataTypes.TIMESTAMP) {
            return new TimestampStreamReader(batchSize, field.getDataType());
        }
        if (dataType == DataTypes.LONG) {
            return new LongStreamReader(batchSize, field.getDataType());
        }
        if (dataType == DataTypes.DOUBLE) {
            return new DoubleStreamReader(batchSize, field.getDataType());
        }
        if (dataType == DataTypes.FLOAT) {
            return new FloatStreamReader(batchSize, field.getDataType());
        }
        if (dataType == DataTypes.BYTE) {
            return new ByteStreamReader(batchSize, field.getDataType());
        }
        if (dataType == DataTypes.STRING || dataType == DataTypes.VARCHAR || dataType == DataTypes.BINARY) {
            return new SliceStreamReader(batchSize, field.getDataType(), maxLength, isCharType);
        }
        if (DataTypes.isDecimal((DataType)dataType)) {
            if (dataType instanceof DecimalType) {
                return new DecimalSliceStreamReader(batchSize, field.getDataType(), (DecimalType)dataType);
            }
            return null;
        }
        return new ObjectStreamReader(batchSize, field.getDataType());
    }

    public void reset() {
        for (int i = 0; i < this.numCols(); ++i) {
            this.columns[i].reset();
        }
        if (this.numRowsFiltered > 0) {
            Arrays.fill(this.filteredRows, false);
        }
        this.numRows = 0;
        this.numRowsFiltered = 0;
    }

    public int numCols() {
        return this.columns.length;
    }

    public void setNumRows(int numRows) {
        if (numRows > this.capacity) {
            throw new RuntimeException("Num Rows is greater than the capacity");
        }
        this.numRows = numRows;
        for (int ordinal : this.nullFilteredColumns) {
            for (int rowId = 0; rowId < numRows; ++rowId) {
                if (this.filteredRows[rowId] || !this.columns[ordinal].isNull(rowId)) continue;
                this.filteredRows[rowId] = true;
                ++this.numRowsFiltered;
            }
        }
    }

    public int numRows() {
        return this.numRows;
    }

    public int numValidRows() {
        if (this.numRowsFiltered > this.numRows) {
            throw new RuntimeException("numRowsFiltered is greater than the numRows");
        }
        return this.numRows - this.numRowsFiltered;
    }

    public CarbonColumnVectorImpl column(int ordinal) {
        return this.columns[ordinal];
    }

    public int capacity() {
        return this.capacity;
    }
}

