/*
 * Decompiled with CFR 0.152.
 */
package io.hetu.core.plugin.carbondata;

import io.airlift.event.client.EventClient;
import io.airlift.units.DataSize;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.HiveACIDWriteType;
import io.prestosql.plugin.hive.HiveColumnHandle;
import io.prestosql.plugin.hive.HiveFileWriterFactory;
import io.prestosql.plugin.hive.HiveSessionProperties;
import io.prestosql.plugin.hive.HiveStorageFormat;
import io.prestosql.plugin.hive.HiveWriter;
import io.prestosql.plugin.hive.HiveWriterFactory;
import io.prestosql.plugin.hive.HiveWriterStats;
import io.prestosql.plugin.hive.LocationHandle;
import io.prestosql.plugin.hive.LocationService;
import io.prestosql.plugin.hive.OrcFileWriterFactory;
import io.prestosql.plugin.hive.metastore.HivePageSinkMetadataProvider;
import io.prestosql.plugin.hive.metastore.SortingColumn;
import io.prestosql.spi.NodeManager;
import io.prestosql.spi.PageSorter;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.type.TypeManager;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.hive.ql.io.AcidOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.joda.time.DateTimeZone;

public class CarbondataWriterFactory
extends HiveWriterFactory {
    private final Map<String, String> additionalJobConf;

    public CarbondataWriterFactory(Set<HiveFileWriterFactory> fileWriterFactories, String schemaName, String tableName, boolean isCreateTable, HiveACIDWriteType acidWriteType, List<HiveColumnHandle> inputColumns, HiveStorageFormat tableStorageFormat, HiveStorageFormat partitionStorageFormat, Map<String, String> additionalTableParameters, OptionalInt bucketCount, List<SortingColumn> sortedBy, LocationHandle locationHandle, LocationService locationService, String queryId, HivePageSinkMetadataProvider pageSinkMetadataProvider, TypeManager typeManager, HdfsEnvironment hdfsEnvironment, PageSorter pageSorter, DataSize sortBufferSize, int maxOpenSortFiles, boolean immutablePartitions, ConnectorSession session, NodeManager nodeManager, EventClient eventClient, HiveSessionProperties hiveSessionProperties, HiveWriterStats hiveWriterStats, OrcFileWriterFactory orcFileWriterFactory, Map<String, String> additionalJobConf) {
        super(fileWriterFactories, schemaName, tableName, isCreateTable, acidWriteType, inputColumns, tableStorageFormat, partitionStorageFormat, additionalTableParameters, bucketCount, sortedBy, locationHandle, locationService, queryId, pageSinkMetadataProvider, typeManager, hdfsEnvironment, pageSorter, sortBufferSize, maxOpenSortFiles, immutablePartitions, DateTimeZone.UTC, session, nodeManager, eventClient, hiveSessionProperties, hiveWriterStats, orcFileWriterFactory);
        this.additionalJobConf = Objects.requireNonNull(additionalJobConf, "Additional JobConf is null");
    }

    private JobConf getSuperJobConf() {
        try {
            Field field = HiveWriterFactory.class.getDeclaredField("conf");
            field.setAccessible(true);
            Object value = field.get((Object)this);
            field.setAccessible(false);
            if (value == null) {
                return null;
            }
            if (JobConf.class.isAssignableFrom(value.getClass())) {
                return (JobConf)value;
            }
            throw new RuntimeException("Fields jobConf doesn't match the type!");
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Fields jobConf Not Found");
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Fields jobConf Not Found");
        }
    }

    public HiveWriter createWriter(List<String> partitionValues, OptionalInt bucketNumber, Optional<AcidOutputFormat.Options> vacuumOptions) {
        JobConf jobConf = this.getSuperJobConf();
        this.additionalJobConf.forEach((k, v) -> jobConf.set(k, v));
        return super.createWriter(partitionValues, bucketNumber, vacuumOptions);
    }

    protected void checkWriteMode(LocationService.WriteInfo writeInfo) {
    }

    protected void setAdditionalSchemaProperties(Properties schema) {
        schema.setProperty("location", this.locationService.getTableWriteInfo(this.locationHandle, false).getTargetPath().toString());
    }
}

