/*
 * Decompiled with CFR 0.152.
 */
package io.hetu.core.plugin.carbondata;

import io.hetu.core.plugin.carbondata.CarbondataColumnVectorWrapper;
import io.hetu.core.plugin.carbondata.CarbondataVectorBatch;
import io.hetu.core.plugin.carbondata.ColumnarVectorWrapperDirect;
import io.hetu.core.plugin.carbondata.HetuCarbondataReadSupport;
import io.prestosql.plugin.hive.HiveColumnHandle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.carbondata.core.keygenerator.directdictionary.DirectDictionaryGenerator;
import org.apache.carbondata.core.keygenerator.directdictionary.DirectDictionaryKeyGeneratorFactory;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.datatype.StructField;
import org.apache.carbondata.core.scan.executor.QueryExecutor;
import org.apache.carbondata.core.scan.executor.QueryExecutorFactory;
import org.apache.carbondata.core.scan.executor.exception.QueryExecutionException;
import org.apache.carbondata.core.scan.model.ProjectionDimension;
import org.apache.carbondata.core.scan.model.ProjectionMeasure;
import org.apache.carbondata.core.scan.model.QueryModel;
import org.apache.carbondata.core.scan.result.iterator.AbstractDetailQueryResultIterator;
import org.apache.carbondata.core.scan.result.vector.CarbonColumnVector;
import org.apache.carbondata.core.scan.result.vector.CarbonColumnarBatch;
import org.apache.carbondata.core.stats.QueryStatistic;
import org.apache.carbondata.core.stats.QueryStatisticsRecorder;
import org.apache.carbondata.core.stats.TaskStatistics;
import org.apache.carbondata.hadoop.AbstractRecordReader;
import org.apache.carbondata.hadoop.CarbonInputSplit;
import org.apache.carbondata.hadoop.CarbonMultiBlockSplit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

class HetuCarbondataVectorizedRecordReader
extends AbstractRecordReader<Object> {
    private int batchIdx;
    private int numBatched;
    private CarbondataVectorBatch columnarBatch;
    private CarbonColumnarBatch carbonColumnarBatch;
    private boolean returnColumnarBatch;
    private QueryModel queryModel;
    private AbstractDetailQueryResultIterator iterator;
    private QueryExecutor queryExecutor;
    private long taskId;
    private long queryStartTime;
    private HetuCarbondataReadSupport readSupport;
    private List<HiveColumnHandle> columnHandles;

    public HetuCarbondataVectorizedRecordReader(QueryExecutor queryExecutor, QueryModel queryModel, AbstractDetailQueryResultIterator iterator, HetuCarbondataReadSupport readSupport, List<HiveColumnHandle> columnHandles) {
        this.queryModel = queryModel;
        this.iterator = iterator;
        this.queryExecutor = queryExecutor;
        this.readSupport = readSupport;
        this.enableReturningBatches();
        this.queryStartTime = System.currentTimeMillis();
        this.columnHandles = columnHandles;
        this.batchIdx = 0;
        this.numBatched = 0;
    }

    public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, UnsupportedOperationException {
        List<Object> splitList;
        if (inputSplit instanceof CarbonInputSplit) {
            splitList = new ArrayList<CarbonInputSplit>(1);
            splitList.add((CarbonInputSplit)inputSplit);
        } else if (inputSplit instanceof CarbonMultiBlockSplit) {
            CarbonMultiBlockSplit multiBlockSplit = (CarbonMultiBlockSplit)inputSplit;
            splitList = multiBlockSplit.getAllSplits();
        } else {
            throw new RuntimeException("unsupported input split type: " + inputSplit);
        }
        List tableBlockInfoList = CarbonInputSplit.createBlocks(splitList);
        this.queryModel.setTableBlockInfos(tableBlockInfoList);
        this.queryModel.setVectorReader(true);
        this.queryExecutor = QueryExecutorFactory.getQueryExecutor((QueryModel)this.queryModel, (Configuration)taskAttemptContext.getConfiguration());
        this.iterator = (AbstractDetailQueryResultIterator)this.queryExecutor.execute(this.queryModel);
    }

    public void close() throws IOException {
        this.logStatistics(this.rowCount, this.queryModel.getStatisticsRecorder());
        if (this.columnarBatch != null) {
            this.columnarBatch = null;
        }
        try {
            this.queryExecutor.finish();
        }
        catch (QueryExecutionException e) {
            throw new IOException(e);
        }
        this.logStatistics(this.taskId, this.queryStartTime, this.queryModel.getStatisticsRecorder());
    }

    public boolean nextKeyValue() {
        this.resultBatch();
        if (this.returnColumnarBatch) {
            return this.nextBatch();
        }
        if (this.batchIdx >= this.numBatched && !this.nextBatch()) {
            return false;
        }
        ++this.batchIdx;
        return true;
    }

    public Object getCurrentValue() {
        if (this.returnColumnarBatch) {
            this.rowCount += this.columnarBatch.numValidRows();
            return this.columnarBatch;
        }
        return null;
    }

    public Void getCurrentKey() {
        return null;
    }

    public float getProgress() {
        return 0.0f;
    }

    private void initBatch() {
        List queryDimension = this.queryModel.getProjectionDimensions();
        List queryMeasures = this.queryModel.getProjectionMeasures();
        StructField[] fields = new StructField[queryDimension.size() + queryMeasures.size()];
        for (int i = 0; i < queryDimension.size(); ++i) {
            ProjectionDimension dim = (ProjectionDimension)queryDimension.get(i);
            if (dim.getDimension().isComplex().booleanValue()) {
                fields[dim.getOrdinal()] = new StructField(dim.getColumnName(), dim.getDimension().getDataType());
                continue;
            }
            if (dim.getDimension().getDataType() == DataTypes.DATE) {
                DirectDictionaryGenerator generator = DirectDictionaryKeyGeneratorFactory.getDirectDictionaryGenerator((DataType)dim.getDimension().getDataType());
                fields[dim.getOrdinal()] = new StructField(dim.getColumnName(), generator.getReturnType());
                continue;
            }
            fields[dim.getOrdinal()] = new StructField(dim.getColumnName(), dim.getDimension().getDataType());
        }
        for (ProjectionMeasure msr : queryMeasures) {
            fields[msr.getOrdinal()] = new StructField(msr.getColumnName(), msr.getMeasure().getDataType());
        }
        this.columnarBatch = CarbondataVectorBatch.allocate(fields, this.readSupport, this.queryModel.isDirectVectorFill(), this.columnHandles);
        CarbonColumnVector[] vectors = new CarbonColumnVector[fields.length];
        boolean[] filteredRows = new boolean[this.columnarBatch.capacity()];
        for (int i = 0; i < fields.length; ++i) {
            vectors[i] = this.queryModel.isDirectVectorFill() ? new ColumnarVectorWrapperDirect(this.columnarBatch.column(i)) : new CarbondataColumnVectorWrapper(this.columnarBatch.column(i), filteredRows);
        }
        this.carbonColumnarBatch = new CarbonColumnarBatch(vectors, this.columnarBatch.capacity(), filteredRows);
    }

    private CarbondataVectorBatch resultBatch() {
        if (this.columnarBatch == null) {
            this.initBatch();
        }
        return this.columnarBatch;
    }

    private void enableReturningBatches() {
        this.returnColumnarBatch = true;
    }

    private boolean nextBatch() {
        this.columnarBatch.reset();
        this.carbonColumnarBatch.reset();
        if (this.iterator.hasNext()) {
            this.iterator.processNextBatch(this.carbonColumnarBatch);
            int actualSize = this.carbonColumnarBatch.getActualSize();
            this.columnarBatch.setNumRows(actualSize);
            this.numBatched = actualSize;
            this.batchIdx = 0;
            return true;
        }
        return false;
    }

    public CarbondataVectorBatch getColumnarBatch() {
        return this.columnarBatch;
    }

    public void setTaskId(long taskId) {
        this.taskId = taskId;
    }

    private void logStatistics(Long taskId, Long queryStartTime, QueryStatisticsRecorder recorder) {
        if (null != recorder) {
            QueryStatistic queryStatistic = new QueryStatistic();
            queryStatistic.addFixedTimeStatistic("Total Time taken to execute the query in executor Side", System.currentTimeMillis() - queryStartTime);
            recorder.recordStatistics(queryStatistic);
            TaskStatistics statistics = recorder.statisticsForTask(taskId.longValue(), queryStartTime.longValue());
            recorder.logStatisticsForTask(statistics);
        }
    }
}

