/*
 * Decompiled with CFR 0.152.
 */
package io.hetu.core.plugin.carbondata.impl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.Gson;
import io.hetu.core.plugin.carbondata.impl.CarbondataLocalInputSplit;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.carbondata.core.statusmanager.FileFormat;
import org.apache.carbondata.hadoop.CarbonMultiBlockSplit;

public class CarbondataLocalMultiBlockSplit {
    private static final long serialVersionUID = 3520344046772190207L;
    private List<CarbondataLocalInputSplit> splitList;
    private String[] locations;
    private FileFormat fileFormat = FileFormat.COLUMNAR_V3;
    private long length;

    @JsonCreator
    public CarbondataLocalMultiBlockSplit(@JsonProperty(value="splitList") List<CarbondataLocalInputSplit> splitList, @JsonProperty(value="locations") String[] locations) {
        this.splitList = splitList;
        this.locations = locations;
        if (!splitList.isEmpty()) {
            this.fileFormat = splitList.get(0).getFileFormat();
        }
    }

    public static CarbonMultiBlockSplit convertSplit(String multiSplitJson) {
        Gson gson = new Gson();
        CarbondataLocalMultiBlockSplit carbonLocalMultiBlockSplit = (CarbondataLocalMultiBlockSplit)gson.fromJson(multiSplitJson, CarbondataLocalMultiBlockSplit.class);
        List carbonInputSplitList = carbonLocalMultiBlockSplit.getSplitList().stream().map(CarbondataLocalInputSplit::convertSplit).collect(Collectors.toList());
        CarbonMultiBlockSplit carbonMultiBlockSplit = new CarbonMultiBlockSplit(carbonInputSplitList, carbonLocalMultiBlockSplit.getLocations());
        carbonMultiBlockSplit.setFileFormat(carbonLocalMultiBlockSplit.getFileFormat());
        return carbonMultiBlockSplit;
    }

    @JsonProperty
    public long getLength() {
        return this.length;
    }

    @JsonProperty
    public String[] getLocations() {
        return this.locations;
    }

    @JsonProperty
    public List<CarbondataLocalInputSplit> getSplitList() {
        return this.splitList;
    }

    @JsonProperty
    public FileFormat getFileFormat() {
        return this.fileFormat;
    }

    public String getJsonString() {
        Gson gson = new Gson();
        return gson.toJson((Object)this);
    }
}

