/*
 * Decompiled with CFR 0.152.
 */
package io.hetu.core.plugin.carbondata.impl;

import com.google.gson.Gson;
import com.google.inject.Inject;
import io.hetu.core.plugin.carbondata.CarbondataHetuFilterUtil;
import io.hetu.core.plugin.carbondata.impl.CarbondataLocalInputSplit;
import io.hetu.core.plugin.carbondata.impl.CarbondataLocalMultiBlockSplit;
import io.hetu.core.plugin.carbondata.impl.CarbondataTableCacheModel;
import io.hetu.core.plugin.carbondata.impl.CarbondataTableConfig;
import io.prestosql.plugin.hive.HiveColumnHandle;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.predicate.TupleDomain;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.filesystem.CarbonFile;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.exception.CarbonFileException;
import org.apache.carbondata.core.index.IndexFilter;
import org.apache.carbondata.core.index.IndexStoreManager;
import org.apache.carbondata.core.indexstore.PartitionSpec;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.CarbonMetadata;
import org.apache.carbondata.core.metadata.SegmentFileStore;
import org.apache.carbondata.core.metadata.converter.ThriftWrapperSchemaConverterImpl;
import org.apache.carbondata.core.metadata.schema.PartitionInfo;
import org.apache.carbondata.core.metadata.schema.partition.PartitionType;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.reader.ThriftReader;
import org.apache.carbondata.core.scan.expression.Expression;
import org.apache.carbondata.core.statusmanager.FileFormat;
import org.apache.carbondata.core.statusmanager.LoadMetadataDetails;
import org.apache.carbondata.core.statusmanager.SegmentStatusManager;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.carbondata.format.TableInfo;
import org.apache.carbondata.hadoop.CarbonInputSplit;
import org.apache.carbondata.hadoop.api.CarbonInputFormat;
import org.apache.carbondata.hadoop.api.CarbonTableInputFormat;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.log4j.Logger;
import org.apache.thrift.TBase;

public class CarbondataTableReader {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)CarbondataTableReader.class.getName());
    public CarbondataTableConfig config;
    private AtomicReference<Map<SchemaTableName, CarbondataTableCacheModel>> carbonCache;
    private String queryId;
    private List<String> schemaNames = new ArrayList<String>();

    @Inject
    public CarbondataTableReader(CarbondataTableConfig config) {
        this.config = Objects.requireNonNull(config, "CarbonTableConfig is null");
        this.carbonCache = new AtomicReference(new ConcurrentHashMap());
        this.populateCarbonProperties();
    }

    public CarbondataTableCacheModel getCarbonCache(SchemaTableName table, String location, Configuration config) {
        this.updateSchemaTables(table, config);
        CarbondataTableCacheModel carbonTableCacheModel = this.carbonCache.get().get(table);
        if (carbonTableCacheModel == null || !carbonTableCacheModel.isValid()) {
            return this.parseCarbonMetadata(table, location, config);
        }
        return carbonTableCacheModel;
    }

    private void updateSchemaTables(SchemaTableName schemaTableName, Configuration config) {
        CarbondataTableCacheModel carbonTableCacheModel = this.carbonCache.get().get(schemaTableName);
        if (carbonTableCacheModel != null && carbonTableCacheModel.getCarbonTable().isTransactionalTable()) {
            CarbonTable carbonTable = carbonTableCacheModel.getCarbonTable();
            try {
                String schemaFilePath = CarbonTablePath.getSchemaFilePath((String)carbonTable.getTablePath());
                FileFactory.FileType fileType = FileFactory.getFileType((String)schemaFilePath);
                CarbonFile carbonFile = FileFactory.getCarbonFile((String)schemaFilePath, (Configuration)config);
                long latestTime = carbonFile.getLastModifiedTime();
                if (fileType == FileFactory.FileType.LOCAL) {
                    latestTime = Files.readAttributes(new File(schemaFilePath).toPath(), BasicFileAttributes.class, new LinkOption[0]).lastModifiedTime().toMillis();
                }
                carbonTableCacheModel.setCurrentSchemaTime(latestTime);
                if (!carbonTableCacheModel.isValid()) {
                    IndexStoreManager.getInstance().clearIndex(carbonTableCacheModel.getCarbonTable().getAbsoluteTableIdentifier());
                }
            }
            catch (IOException | CarbonFileException e) {
                this.carbonCache.get().remove(schemaTableName);
            }
        }
    }

    public void deleteTableFromCarbonCache(SchemaTableName table) {
        this.carbonCache.get().remove(table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CarbondataTableCacheModel parseCarbonMetadata(SchemaTableName table, String tablePath, Configuration config) {
        try {
            CarbondataTableCacheModel cache = this.getValidCacheBySchemaTableName(table);
            if (cache != null) {
                return cache;
            }
            Class<CarbondataTableReader> clazz = CarbondataTableReader.class;
            synchronized (CarbondataTableReader.class) {
                TableInfo tableInfo;
                CarbondataTableCacheModel cacheModel = this.getValidCacheBySchemaTableName(table);
                if (cacheModel != null) {
                    // ** MonitorExit[var5_6] (shouldn't be in output)
                    return cacheModel;
                }
                String schemaFilePath = CarbonTablePath.getSchemaFilePath((String)tablePath, (Configuration)config);
                CarbonFile schemaFile = FileFactory.getCarbonFile((String)schemaFilePath, (Configuration)config);
                boolean isTransactionalTable = schemaFile.exists();
                long modifiedTime = System.currentTimeMillis();
                if (isTransactionalTable) {
                    ThriftReader.TBaseCreator createTBase = new ThriftReader.TBaseCreator(){

                        public TBase create() {
                            return new TableInfo();
                        }
                    };
                    ThriftReader thriftReader = new ThriftReader(schemaFilePath, createTBase, config);
                    thriftReader.open();
                    tableInfo = (TableInfo)thriftReader.read();
                    thriftReader.close();
                    modifiedTime = schemaFile.getLastModifiedTime();
                    FileFactory.FileType fileType = FileFactory.getFileType((String)schemaFilePath);
                    if (fileType == FileFactory.FileType.LOCAL) {
                        modifiedTime = Files.readAttributes(new File(schemaFilePath).toPath(), BasicFileAttributes.class, new LinkOption[0]).lastModifiedTime().toMillis();
                    }
                } else {
                    tableInfo = CarbonUtil.inferSchema((String)tablePath, (String)table.getTableName(), (boolean)false, (Configuration)config);
                }
                ThriftWrapperSchemaConverterImpl schemaConverter = new ThriftWrapperSchemaConverterImpl();
                org.apache.carbondata.core.metadata.schema.table.TableInfo wrapperTableInfo = schemaConverter.fromExternalToWrapperTableInfo(tableInfo, table.getSchemaName(), table.getTableName(), tablePath);
                wrapperTableInfo.setTransactionalTable(isTransactionalTable);
                CarbonMetadata.getInstance().removeTable(wrapperTableInfo.getTableUniqueName());
                CarbonMetadata.getInstance().loadTableMetadata(wrapperTableInfo);
                CarbonTable carbonTable = Objects.requireNonNull(CarbonMetadata.getInstance().getCarbonTable(table.getSchemaName(), table.getTableName()), "carbontable is null");
                cache = new CarbondataTableCacheModel(modifiedTime, carbonTable);
                this.carbonCache.get().put(table, cache);
                cache.setCarbonTable(carbonTable);
                // ** MonitorExit[var5_6] (shouldn't be in output)
                return cache;
            }
        }
        catch (IOException ex) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Failed while reading metadata of the table: ", (Throwable)ex);
        }
    }

    private CarbondataTableCacheModel getValidCacheBySchemaTableName(SchemaTableName schemaTableName) {
        CarbondataTableCacheModel cache = this.carbonCache.get().get(schemaTableName);
        if (cache != null && cache.isValid()) {
            return cache;
        }
        return null;
    }

    public List<CarbondataLocalMultiBlockSplit> getInputSplits(CarbondataTableCacheModel tableCacheModel, Expression filters, TupleDomain<HiveColumnHandle> constraints, Configuration config) throws IOException {
        ArrayList<CarbondataLocalInputSplit> result = new ArrayList<CarbondataLocalInputSplit>();
        ArrayList<CarbondataLocalMultiBlockSplit> multiBlockSplitList = new ArrayList<CarbondataLocalMultiBlockSplit>();
        CarbonTable carbonTable = tableCacheModel.getCarbonTable();
        org.apache.carbondata.core.metadata.schema.table.TableInfo tableInfo = tableCacheModel.getCarbonTable().getTableInfo();
        config.set("mapreduce.input.carboninputformat.segmentnumbers", "");
        String carbonTablePath = carbonTable.getAbsoluteTableIdentifier().getTablePath();
        config.set("mapreduce.input.fileinputformat.inputdir", carbonTablePath);
        config.set("mapreduce.input.carboninputformat.databaseName", carbonTable.getDatabaseName());
        config.set("mapreduce.input.carboninputformat.tableName", carbonTable.getTableName());
        config.set("query.id", this.queryId);
        CarbonInputFormat.setTransactionalTable((Configuration)config, (boolean)carbonTable.isTransactionalTable());
        CarbonInputFormat.setTableInfo((Configuration)config, (org.apache.carbondata.core.metadata.schema.table.TableInfo)carbonTable.getTableInfo());
        JobConf jobConf = new JobConf(config);
        ArrayList<PartitionSpec> filteredPartitions = new ArrayList();
        PartitionInfo partitionInfo = carbonTable.getPartitionInfo();
        LoadMetadataDetails[] loadMetadataDetails = null;
        if (partitionInfo != null && partitionInfo.getPartitionType() == PartitionType.NATIVE_HIVE) {
            loadMetadataDetails = SegmentStatusManager.readTableStatusFile((String)CarbonTablePath.getTableStatusFilePath((String)carbonTable.getTablePath()));
            filteredPartitions = this.findRequiredPartitions(constraints, carbonTable, loadMetadataDetails);
        }
        try {
            CarbonTableInputFormat.setTableInfo((Configuration)config, (org.apache.carbondata.core.metadata.schema.table.TableInfo)tableInfo);
            CarbonTableInputFormat<Object> carbonTableInputFormat = this.createInputFormat((Configuration)jobConf, carbonTable.getAbsoluteTableIdentifier(), new IndexFilter(carbonTable, filters, true), filteredPartitions);
            Job job = Job.getInstance((Configuration)jobConf);
            List splits = carbonTableInputFormat.getSplits((JobContext)job);
            Gson gson = new Gson();
            if (splits != null && splits.size() > 0) {
                for (InputSplit inputSplit : splits) {
                    CarbonInputSplit carbonInputSplit = (CarbonInputSplit)inputSplit;
                    result.add(new CarbondataLocalInputSplit(carbonInputSplit.getSegmentId(), carbonInputSplit.getPath().toString(), carbonInputSplit.getStart(), carbonInputSplit.getLength(), Arrays.asList(carbonInputSplit.getLocations()), carbonInputSplit.getNumberOfBlocklets(), carbonInputSplit.getVersion().number(), carbonInputSplit.getDeleteDeltaFiles(), carbonInputSplit.getBlockletId(), gson.toJson((Object)carbonInputSplit.getDetailInfo()), carbonInputSplit.getFileFormat().ordinal()));
                }
                ArrayList<List<CarbondataLocalInputSplit>> inputSplits = new ArrayList<List<CarbondataLocalInputSplit>>(result.stream().collect(Collectors.groupingBy(carbonInput -> {
                    if (FileFormat.ROW_V1.equals((Object)carbonInput.getFileFormat())) {
                        return carbonInput.getSegmentId().concat(carbonInput.getPath()).concat(carbonInput.getStart() + "");
                    }
                    return carbonInput.getSegmentId().concat(carbonInput.getPath());
                })).values());
                for (int j = 0; j < inputSplits.size(); ++j) {
                    multiBlockSplitList.add(new CarbondataLocalMultiBlockSplit((List)inputSplits.get(j), (String[])((List)inputSplits.get(j)).stream().flatMap(f -> Arrays.stream(this.getLocations((CarbondataLocalInputSplit)f))).distinct().toArray(String[]::new)));
                }
                LOGGER.error((Object)("Size of MultiblockList   " + multiBlockSplitList.size()));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return multiBlockSplitList;
    }

    private List<PartitionSpec> findRequiredPartitions(TupleDomain<HiveColumnHandle> constraints, CarbonTable carbonTable, LoadMetadataDetails[] loadMetadataDetails) throws IOException {
        HashSet partitionSpecs = new HashSet();
        for (LoadMetadataDetails loadMetadataDetail : loadMetadataDetails) {
            SegmentFileStore segmentFileStore = null;
            segmentFileStore = new SegmentFileStore(carbonTable.getTablePath(), loadMetadataDetail.getSegmentFile());
            partitionSpecs.addAll(segmentFileStore.getPartitionSpecs());
        }
        List<String> partitionValuesFromExpression = CarbondataHetuFilterUtil.getPartitionFilters(carbonTable, constraints);
        return partitionSpecs.stream().filter(partitionSpec -> CollectionUtils.isSubCollection((Collection)partitionValuesFromExpression, (Collection)partitionSpec.getPartitions())).collect(Collectors.toList());
    }

    private CarbonTableInputFormat<Object> createInputFormat(Configuration conf, AbsoluteTableIdentifier identifier, IndexFilter dataMapFilter, List<PartitionSpec> filteredPartitions) {
        CarbonTableInputFormat format = new CarbonTableInputFormat();
        CarbonTableInputFormat.setTablePath((Configuration)conf, (String)identifier.appendWithLocalPrefix(identifier.getTablePath()));
        CarbonTableInputFormat.setFilterPredicates((Configuration)conf, (IndexFilter)dataMapFilter);
        if (filteredPartitions.size() != 0) {
            CarbonTableInputFormat.setPartitionsToPrune((Configuration)conf, filteredPartitions);
        }
        return format;
    }

    private void populateCarbonProperties() {
        this.addProperty("carbon.unsafe.working.memory.in.mb", this.config.getUnsafeMemoryInMb());
        this.addProperty("enable.unsafe.in.query.processing", this.config.getEnableUnsafeInQueryExecution());
        this.addProperty("enable.unsafe.columnpage", this.config.getEnableUnsafeColumnPage());
        this.addProperty("enable.unsafe.sort", this.config.getEnableUnsafeSort());
        this.addProperty("enable.query.statistics", this.config.getEnableQueryStatistics());
        this.addProperty("carbon.writtenby.app.name", "Hetu_Server");
    }

    private void addProperty(String propertyName, String propertyValue) {
        if (propertyValue != null) {
            CarbonProperties.getInstance().addProperty(propertyName, propertyValue);
        }
    }

    private String[] getLocations(CarbondataLocalInputSplit cis) {
        return cis.getLocations().toArray(new String[0]);
    }

    public void setQueryId(String queryId) {
        this.queryId = queryId;
    }
}

