/*
 * Decompiled with CFR 0.152.
 */
package io.hetu.core.plugin.carbondata.readers;

import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.hetu.core.plugin.carbondata.readers.HetuCoreVectorBlockBuilder;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.Decimals;
import io.prestosql.spi.type.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.scan.result.vector.impl.CarbonColumnVectorImpl;

public class DecimalSliceStreamReader
extends CarbonColumnVectorImpl
implements HetuCoreVectorBlockBuilder {
    private final char[] buffer = new char[100];
    protected int batchSize;
    protected Type type;
    protected BlockBuilder builder;

    public DecimalSliceStreamReader(int batchSize, DataType dataType, org.apache.carbondata.core.metadata.datatype.DecimalType decimalDataType) {
        super(batchSize, dataType);
        this.type = DecimalType.createDecimalType((int)decimalDataType.getPrecision(), (int)decimalDataType.getScale());
        this.batchSize = batchSize;
        this.builder = this.type.createBlockBuilder(null, batchSize);
    }

    @Override
    public Block buildBlock() {
        return this.builder.build();
    }

    @Override
    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void putDecimal(int rowId, BigDecimal value, int precision) {
        this.decimalBlockWriter(value);
    }

    public void putDecimals(int rowId, int count, BigDecimal value, int precision) {
        int id = rowId;
        for (int i = 0; i < count; ++i) {
            this.putDecimal(id++, value, precision);
        }
    }

    public void putNulls(int rowId, int count) {
        for (int i = 0; i < count; ++i) {
            this.builder.appendNull();
        }
    }

    public void putNull(int rowId) {
        this.builder.appendNull();
    }

    public void reset() {
        this.builder = this.type.createBlockBuilder(null, this.batchSize);
    }

    private void decimalBlockWriter(BigDecimal value) {
        if (Decimals.isShortDecimal((Type)this.type)) {
            long rescaledDecimal = Decimals.rescale((long)value.unscaledValue().longValue(), (int)value.scale(), (int)((DecimalType)this.type).getScale());
            this.type.writeLong(this.builder, rescaledDecimal);
        } else {
            Slice slice = this.getSlice(value, this.type);
            this.type.writeSlice(this.builder, this.parseSlice((DecimalType)this.type, slice, slice.length()));
        }
    }

    private Slice getSlice(Object value, Type type) {
        if (type instanceof DecimalType) {
            DecimalType actual = (DecimalType)type;
            BigDecimal bigDecimalValue = (BigDecimal)value;
            if (Decimals.isShortDecimal((Type)type)) {
                return Slices.utf8Slice((String)value.toString());
            }
            if (bigDecimalValue.scale() > actual.getScale()) {
                BigInteger unscaledDecimal = Decimals.rescale((BigInteger)bigDecimalValue.unscaledValue(), (int)bigDecimalValue.scale(), (int)bigDecimalValue.scale());
                Slice decimalSlice = Decimals.encodeUnscaledValue((BigInteger)unscaledDecimal);
                return Slices.utf8Slice((String)Decimals.toString((Slice)decimalSlice, (int)actual.getScale()));
            }
            BigInteger unscaledDecimal = Decimals.rescale((BigInteger)bigDecimalValue.unscaledValue(), (int)bigDecimalValue.scale(), (int)actual.getScale());
            Slice decimalSlice = Decimals.encodeUnscaledValue((BigInteger)unscaledDecimal);
            return Slices.utf8Slice((String)Decimals.toString((Slice)decimalSlice, (int)actual.getScale()));
        }
        return Slices.utf8Slice((String)value.toString());
    }

    private Slice parseSlice(DecimalType type, Slice slice, int length) {
        BigDecimal decimal = this.parseBigDecimal(type, slice, length);
        return Decimals.encodeUnscaledValue((BigInteger)decimal.unscaledValue());
    }

    private BigDecimal parseBigDecimal(DecimalType type, Slice slice, int length) {
        int offset = 0;
        Preconditions.checkArgument((length < this.buffer.length ? 1 : 0) != 0);
        for (int i = 0; i < length; ++i) {
            this.buffer[i] = (char)slice.getByte(offset + i);
        }
        BigDecimal decimal = new BigDecimal(this.buffer, 0, length);
        Preconditions.checkState((decimal.scale() <= type.getScale() ? 1 : 0) != 0, (Object)"Read decimal value scale larger than column scale");
        decimal = decimal.setScale(type.getScale(), RoundingMode.HALF_UP);
        Preconditions.checkState((decimal.precision() <= type.getPrecision() ? 1 : 0) != 0, (Object)"Read decimal precision larger than column precision");
        return decimal;
    }

    public void putObject(int rowId, Object value) {
        if (value == null) {
            this.putNull(rowId);
        } else {
            this.decimalBlockWriter((BigDecimal)value);
        }
    }
}

