/*
 * Decompiled with CFR 0.152.
 */
package io.hetu.core.plugin.carbondata.readers;

import io.hetu.core.plugin.carbondata.readers.HetuCoreVectorBlockBuilder;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.Type;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.scan.result.vector.impl.CarbonColumnVectorImpl;

public class DoubleStreamReader
extends CarbonColumnVectorImpl
implements HetuCoreVectorBlockBuilder {
    protected int batchSize;
    protected Type type = DoubleType.DOUBLE;
    protected BlockBuilder builder;

    public DoubleStreamReader(int batchSize, DataType dataType) {
        super(batchSize, dataType);
        this.batchSize = batchSize;
        this.builder = this.type.createBlockBuilder(null, batchSize);
    }

    @Override
    public Block buildBlock() {
        return this.builder.build();
    }

    @Override
    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void putDouble(int rowId, double value) {
        this.type.writeDouble(this.builder, value);
    }

    public void putDoubles(int rowId, int count, double value) {
        for (int i = 0; i < count; ++i) {
            this.type.writeDouble(this.builder, value);
        }
    }

    public void putNull(int rowId) {
        this.builder.appendNull();
    }

    public void putNulls(int rowId, int count) {
        for (int i = 0; i < count; ++i) {
            this.builder.appendNull();
        }
    }

    public void reset() {
        this.builder = this.type.createBlockBuilder(null, this.batchSize);
    }

    public void putObject(int rowId, Object value) {
        if (value == null) {
            this.putNull(rowId);
        } else {
            this.putDouble(rowId, (Double)value);
        }
    }
}

