/*
 * Decompiled with CFR 0.152.
 */
package io.hetu.core.plugin.carbondata.readers;

import io.hetu.core.plugin.carbondata.readers.HetuCoreVectorBlockBuilder;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.scan.result.vector.impl.CarbonColumnVectorImpl;

public class LongStreamReader
extends CarbonColumnVectorImpl
implements HetuCoreVectorBlockBuilder {
    protected int batchSize;
    protected Type type = BigintType.BIGINT;
    protected BlockBuilder builder;

    public LongStreamReader(int batchSize, DataType dataType) {
        super(batchSize, dataType);
        this.batchSize = batchSize;
        this.builder = this.type.createBlockBuilder(null, batchSize);
    }

    @Override
    public Block buildBlock() {
        return this.builder.build();
    }

    @Override
    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void putLong(int rowId, long value) {
        this.type.writeLong(this.builder, value);
    }

    public void putLongs(int rowId, int count, long value) {
        for (int i = 0; i < count; ++i) {
            this.type.writeLong(this.builder, value);
        }
    }

    public void putNull(int rowId) {
        this.builder.appendNull();
    }

    public void reset() {
        this.builder = this.type.createBlockBuilder(null, this.batchSize);
    }

    public void putNulls(int rowId, int count) {
        for (int i = 0; i < count; ++i) {
            this.builder.appendNull();
        }
    }

    public void putObject(int rowId, Object value) {
        if (value == null) {
            this.putNull(rowId);
        } else {
            this.putLong(rowId, (Long)value);
        }
    }
}

