/*
 * Decompiled with CFR 0.152.
 */
package io.hetu.core.plugin.carbondata.readers;

import io.hetu.core.plugin.carbondata.readers.HetuCoreVectorBlockBuilder;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.Type;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.scan.result.vector.impl.CarbonColumnVectorImpl;

public class ObjectStreamReader
extends CarbonColumnVectorImpl
implements HetuCoreVectorBlockBuilder {
    protected int batchSize;
    protected Type type = IntegerType.INTEGER;
    protected BlockBuilder builder;

    public ObjectStreamReader(int batchSize, DataType dataType) {
        super(batchSize, dataType);
        this.batchSize = batchSize;
        this.builder = this.type.createBlockBuilder(null, batchSize);
    }

    @Override
    public Block buildBlock() {
        return this.builder.build();
    }

    @Override
    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void putObject(int rowId, Object value) {
        this.type.writeObject(this.builder, value);
    }

    public void putNull(int rowId) {
        this.builder.appendNull();
    }

    public void reset() {
        this.builder = this.type.createBlockBuilder(null, this.batchSize);
    }

    public void putNulls(int rowId, int count) {
        for (int i = 0; i < count; ++i) {
            this.builder.appendNull();
        }
    }
}

