/*
 * Decompiled with CFR 0.152.
 */
package io.hetu.core.plugin.carbondata.readers;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.hetu.core.plugin.carbondata.readers.HetuCoreVectorBlockBuilder;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.block.DictionaryBlock;
import io.prestosql.spi.block.VariableWidthBlock;
import io.prestosql.spi.type.Chars;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.spi.type.Varchars;
import java.util.Optional;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.scan.result.vector.CarbonDictionary;
import org.apache.carbondata.core.scan.result.vector.impl.CarbonColumnVectorImpl;
import org.apache.carbondata.core.util.ByteUtil;

public class SliceStreamReader
extends CarbonColumnVectorImpl
implements HetuCoreVectorBlockBuilder {
    protected int batchSize;
    protected Type type = VarcharType.VARCHAR;
    protected BlockBuilder builder;
    private Block dictionaryBlock;
    private boolean isLocalDict;
    private int maxLength;
    private boolean isCharType;

    public SliceStreamReader(int batchSize, DataType dataType, int maxLength, boolean isCharType) {
        super(batchSize, dataType);
        this.batchSize = batchSize;
        this.builder = this.type.createBlockBuilder(null, batchSize);
        this.maxLength = maxLength;
        this.isCharType = isCharType;
    }

    @Override
    public Block buildBlock() {
        if (this.dictionaryBlock == null) {
            return this.builder.build();
        }
        int[] dataArray = this.isLocalDict ? (int[])((CarbonColumnVectorImpl)this.getDictionaryVector()).getDataArray() : (int[])this.getDataArray();
        return new DictionaryBlock(this.batchSize, this.dictionaryBlock, dataArray);
    }

    public void setDictionary(CarbonDictionary dictionary) {
        super.setDictionary(dictionary);
        if (dictionary == null) {
            this.dictionaryBlock = null;
            this.isLocalDict = false;
            return;
        }
        boolean[] nulls = new boolean[dictionary.getDictionarySize()];
        nulls[0] = true;
        nulls[1] = true;
        int[] dictOffsets = new int[dictionary.getDictionarySize() + 1];
        int[] truncatedDictOffsets = new int[dictionary.getDictionarySize() + 1];
        int size = 0;
        for (int i = 0; i < dictionary.getDictionarySize(); ++i) {
            dictOffsets[i] = size;
            if (dictionary.getDictionaryValue(i) == null) continue;
            size += dictionary.getDictionaryValue(i).length;
            if (this.maxLength < 0) continue;
            if (i < 2) {
                truncatedDictOffsets[i] = dictOffsets[i];
                continue;
            }
            int actualLength = dictionary.getDictionaryValue(i).length;
            int truncatedLength = this.computeTruncatedLength(Slices.wrappedBuffer((byte[])dictionary.getDictionaryValue(i)), 0, actualLength, this.maxLength, this.isCharType);
            truncatedDictOffsets[i + 1] = truncatedDictOffsets[i] + truncatedLength;
        }
        byte[] singleArrayDictValues = new byte[size];
        byte[] truncatedSingleArrayDictValues = new byte[size];
        for (int i = 0; i < dictionary.getDictionarySize(); ++i) {
            if (dictionary.getDictionaryValue(i) == null) continue;
            System.arraycopy(dictionary.getDictionaryValue(i), 0, singleArrayDictValues, dictOffsets[i], dictionary.getDictionaryValue(i).length);
            if (this.maxLength < 0) continue;
            System.arraycopy(dictionary.getDictionaryValue(i), 0, truncatedSingleArrayDictValues, truncatedDictOffsets[i], dictionary.getDictionaryValue(i).length);
        }
        if (this.maxLength < 0) {
            dictOffsets[dictOffsets.length - 1] = size;
            this.dictionaryBlock = new VariableWidthBlock(dictionary.getDictionarySize(), Slices.wrappedBuffer((byte[])singleArrayDictValues), dictOffsets, Optional.of(nulls));
        } else {
            this.dictionaryBlock = new VariableWidthBlock(dictionary.getDictionarySize(), Slices.wrappedBuffer((byte[])truncatedSingleArrayDictValues), truncatedDictOffsets, Optional.of(nulls));
        }
        this.isLocalDict = true;
    }

    @Override
    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void putByteArray(int rowId, byte[] value) {
        this.type.writeSlice(this.builder, Slices.wrappedBuffer((byte[])value));
    }

    public void putByteArray(int rowId, int offset, int length, byte[] value) {
        int truncatedLength = this.computeTruncatedLength(Slices.wrappedBuffer((byte[])value), offset, length, this.maxLength, this.isCharType);
        this.type.writeSlice(this.builder, Slices.wrappedBuffer((byte[])value), offset, truncatedLength);
    }

    public void putByteArray(int rowId, int count, byte[] value) {
        for (int i = 0; i < count; ++i) {
            this.type.writeSlice(this.builder, Slices.wrappedBuffer((byte[])value));
        }
    }

    public void putNull(int rowId) {
        if (this.dictionaryBlock == null) {
            this.builder.appendNull();
        }
    }

    public void putNulls(int rowId, int count) {
        if (this.dictionaryBlock == null) {
            for (int i = 0; i < count; ++i) {
                this.builder.appendNull();
            }
        }
    }

    public void reset() {
        this.builder = this.type.createBlockBuilder(null, this.batchSize);
    }

    public void putObject(int rowId, Object value) {
        if (value == null) {
            this.putNull(rowId);
        } else if (this.dictionaryBlock == null) {
            this.putByteArray(rowId, ByteUtil.toBytes((String)((String)value)));
        } else {
            this.putInt(rowId, (Integer)value);
        }
    }

    private int computeTruncatedLength(Slice slice, int offset, int length, int maxCodePointCount, boolean isCharType) {
        if (isCharType) {
            return Chars.byteCountWithoutTrailingSpace((Slice)slice, (int)offset, (int)length, (int)maxCodePointCount);
        }
        if (maxCodePointCount >= 0 && length > maxCodePointCount) {
            return Varchars.byteCount((Slice)slice, (int)offset, (int)length, (int)maxCodePointCount);
        }
        return length;
    }
}

