/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystem;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.common.base.Preconditions;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.EnumSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;

abstract class GoogleHadoopFileSystemBaseSpecific
extends FileSystem {
    GoogleHadoopFileSystemBaseSpecific() {
    }

    static String getPassword(Configuration config, String name) {
        char[] value;
        try {
            value = config.getPassword(name);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return value == null ? null : String.valueOf(value);
    }

    public abstract URI getGcsPath(Path var1);

    public abstract GoogleCloudStorageFileSystem getGcsFs();

    public FSDataOutputStream createNonRecursive(Path hadoopPath, FsPermission permission, EnumSet<CreateFlag> flags, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        URI gcsPath = this.getGcsPath((Path)Preconditions.checkNotNull((Object)hadoopPath, (Object)"hadoopPath must not be null"));
        URI parentGcsPath = this.getGcsFs().getParentPath(gcsPath);
        GoogleCloudStorageItemInfo parentInfo = this.getGcsFs().getFileInfo(parentGcsPath).getItemInfo();
        if (!(parentInfo.isRoot() || parentInfo.isBucket() || parentInfo.exists())) {
            throw new FileNotFoundException(String.format("Can not create '%s' file, because parent folder does not exist: %s", gcsPath, parentGcsPath));
        }
        return this.create(hadoopPath, permission, flags.contains(CreateFlag.OVERWRITE), bufferSize, replication, blockSize, progress);
    }
}

