/*
 * Decompiled with CFR 0.152.
 */
package io.hetu.core.jdbc;

import io.prestosql.jdbc.$internal.client.OkHttpUtil;
import io.prestosql.jdbc.$internal.client.SocketChannelSocketFactory;
import io.prestosql.jdbc.$internal.guava.base.MoreObjects;
import io.prestosql.jdbc.$internal.guava.base.Strings;
import io.prestosql.jdbc.$internal.okhttp3.OkHttpClient;
import io.prestosql.jdbc.PrestoDriver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OpenLooKengDriver
extends PrestoDriver {
    public static final String DRIVER_NAME = "openLooKeng JDBC Driver";
    public static final String PRODUCT_NAME = "openLooKeng";
    public static final String DRIVER_VERSION;
    public static final int DRIVER_VERSION_MAJOR;
    public static final int DRIVER_VERSION_MINOR;
    public static final String DRIVER_PRODUCT_TAG = "lk:";
    public static final String DRIVER_URL_START = "jdbc:lk:";
    private final OkHttpClient httpClient = new OkHttpClient.Builder().addInterceptor(OkHttpUtil.userAgent("openLooKeng JDBC Driver/" + DRIVER_VERSION)).socketFactory(new SocketChannelSocketFactory()).build();

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return url.startsWith(DRIVER_URL_START);
    }

    static {
        String version = Strings.nullToEmpty(OpenLooKengDriver.class.getPackage().getSpecificationVersion());
        Matcher matcher = Pattern.compile("^(\\d+)(\\.(\\d+))?($|[.-])").matcher(version);
        if (!matcher.find()) {
            DRIVER_VERSION = "unknown";
            DRIVER_VERSION_MAJOR = 0;
            DRIVER_VERSION_MINOR = 0;
        } else {
            int thirdGroup = 3;
            DRIVER_VERSION = version;
            DRIVER_VERSION_MAJOR = Integer.parseInt(matcher.group(1));
            DRIVER_VERSION_MINOR = Integer.parseInt(MoreObjects.firstNonNull(matcher.group(3), "0"));
        }
        try {
            DriverManager.registerDriver(new OpenLooKengDriver());
        }
        catch (SQLException e) {
            throw new RuntimeException("Fail to register Jdbc driver for openLooKeng.");
        }
    }
}

