/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.jdbc.$internal.client;

import io.prestosql.jdbc.;
import io.prestosql.jdbc.$internal.airlift.units.Duration;
import io.prestosql.jdbc.$internal.client.ClientSelectedRole;
import io.prestosql.jdbc.$internal.client.ClientSession;
import java.net.URI;
import java.time.ZoneId;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class DataCenterClientSession
extends ClientSession {
    private final Duration maxAnticipatedDelay;
    private final boolean compressionEnabled;
    private .TypeManager typeManager;

    private DataCenterClientSession(URI server, String user, String source, Optional<String> traceToken, Set<String> clientTags, String clientInfo, String catalog, String schema, String path, ZoneId timeZone, Locale locale, Map<String, String> resourceEstimates, Map<String, String> properties, Map<String, String> preparedStatements, Map<String, ClientSelectedRole> roles, Map<String, String> extraCredentials, String transactionId, Duration clientRequestTimeout, Duration maxAnticipatedDelay, boolean compressionEnabled, .TypeManager typeManager) {
        super(server, user, source, traceToken, clientTags, clientInfo, catalog, schema, path, timeZone, locale, resourceEstimates, properties, preparedStatements, roles, extraCredentials, transactionId, clientRequestTimeout);
        this.maxAnticipatedDelay = maxAnticipatedDelay;
        this.compressionEnabled = compressionEnabled;
        this.typeManager = typeManager;
    }

    public static Builder builder(DataCenterClientSession clientSession) {
        return new Builder(clientSession);
    }

    public static Builder builder(URI server, String user) {
        return new Builder(server, user);
    }

    public Duration getMaxAnticipatedDelay() {
        return this.maxAnticipatedDelay;
    }

    public boolean isCompressionEnabled() {
        return this.compressionEnabled;
    }

    public .TypeManager getTypeManager() {
        return this.typeManager;
    }

    public static final class Builder {
        private URI server;
        private String user;
        private String source;
        private Optional<String> traceToken;
        private Set<String> clientTags;
        private String clientInfo;
        private String catalog;
        private String schema;
        private String path;
        private ZoneId timeZone;
        private Locale locale;
        private Map<String, String> resourceEstimates;
        private Map<String, String> properties;
        private Map<String, String> preparedStatements;
        private Map<String, ClientSelectedRole> roles;
        private Map<String, String> credentials;
        private String transactionId;
        private Duration clientRequestTimeout;
        private Duration maxAnticipatedDelay;
        private boolean compressionEnabled;
        private .TypeManager typeManager;

        private Builder(URI server, String user) {
            this.server = server;
            this.user = user;
            this.traceToken = Optional.empty();
            this.clientTags = Collections.emptySet();
            this.resourceEstimates = Collections.emptyMap();
            this.properties = Collections.emptyMap();
            this.preparedStatements = Collections.emptyMap();
            this.roles = Collections.emptyMap();
            this.credentials = Collections.emptyMap();
        }

        private Builder(DataCenterClientSession clientSession) {
            Objects.requireNonNull(clientSession, "clientSession is null");
            this.server = clientSession.getServer();
            this.user = clientSession.getUser();
            this.source = clientSession.getSource();
            this.traceToken = clientSession.getTraceToken();
            this.clientTags = clientSession.getClientTags();
            this.clientInfo = clientSession.getClientInfo();
            this.catalog = clientSession.getCatalog();
            this.schema = clientSession.getSchema();
            this.path = clientSession.getPath();
            this.timeZone = clientSession.getTimeZone();
            this.locale = clientSession.getLocale();
            this.resourceEstimates = clientSession.getResourceEstimates();
            this.properties = clientSession.getProperties();
            this.preparedStatements = clientSession.getPreparedStatements();
            this.roles = clientSession.getRoles();
            this.credentials = clientSession.getExtraCredentials();
            this.transactionId = clientSession.getTransactionId();
            this.clientRequestTimeout = clientSession.getClientRequestTimeout();
            this.maxAnticipatedDelay = clientSession.getMaxAnticipatedDelay();
            this.compressionEnabled = clientSession.isCompressionEnabled();
            this.typeManager = clientSession.getTypeManager();
        }

        public Builder withCatalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public Builder withSchema(String schema) {
            this.schema = schema;
            return this;
        }

        public Builder withPath(String path) {
            this.path = path;
            return this;
        }

        public Builder withProperties(Map<String, String> properties) {
            this.properties = Objects.requireNonNull(properties, "properties is null");
            return this;
        }

        public Builder withRoles(Map<String, ClientSelectedRole> roles) {
            this.roles = roles;
            return this;
        }

        public Builder withCredentials(Map<String, String> credentials) {
            this.credentials = Objects.requireNonNull(credentials, "extraCredentials is null");
            return this;
        }

        public Builder withPreparedStatements(Map<String, String> preparedStatements) {
            this.preparedStatements = Objects.requireNonNull(preparedStatements, "preparedStatements is null");
            return this;
        }

        public Builder withTransactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public Builder withoutTransactionId() {
            this.transactionId = null;
            return this;
        }

        public Builder withMaxAnticipatedDelay(Duration delay) {
            this.maxAnticipatedDelay = delay;
            return this;
        }

        public Builder withCompression(boolean enabled) {
            this.compressionEnabled = enabled;
            return this;
        }

        public Builder withSource(String source) {
            this.source = source;
            return this;
        }

        public Builder withTimezone(ZoneId zoneId) {
            this.timeZone = zoneId;
            return this;
        }

        public Builder withLocale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public Builder withClientTimeout(Duration timeout) {
            this.clientRequestTimeout = timeout;
            return this;
        }

        public Builder withServer(URI server) {
            this.server = server;
            return this;
        }

        public Builder withUser(String user) {
            this.user = user;
            return this;
        }

        public Builder withTypeManager(.TypeManager typeManager) {
            this.typeManager = typeManager;
            return this;
        }

        public DataCenterClientSession build() {
            return new DataCenterClientSession(this.server, this.user, this.source, this.traceToken, this.clientTags, this.clientInfo, this.catalog, this.schema, this.path, this.timeZone != null ? this.timeZone : ZoneId.systemDefault(), this.locale != null ? this.locale : Locale.getDefault(), this.resourceEstimates, this.properties, this.preparedStatements, this.roles, this.credentials, this.transactionId, this.clientRequestTimeout, this.maxAnticipatedDelay, this.compressionEnabled, this.typeManager);
        }
    }
}

