/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.jdbc.$internal.client;

import io.prestosql.jdbc.;
import io.prestosql.jdbc.$internal.guava.base.MoreObjects;
import java.util.List;

@.Immutable
public class SnapshotStats {
    private final long lastCaptureSnapshotId;
    private final long totalCaptureCpuTime;
    private final long totalCaptureWallTime;
    private final long lastCaptureCpuTime;
    private final long lastCaptureWallTime;
    private final long allCaptureSize;
    private final long lastCaptureSize;
    private final List<Long> restoredSnapshotList;
    private final List<Long> capturedSnapshotList;
    private final long successRestoreCount;
    private final long totalRestoreWallTime;
    private final long totalRestoreSize;
    private final long totalRestoreCpuTime;
    private final long restoringSnapshotId;
    private final List<Long> capturingSnapshotIds;

    @.JsonCreator
    public SnapshotStats(@.JsonProperty(value="lastCaptureSnapshotId") long lastCaptureSnapshotId, @.JsonProperty(value="totalCaptureCpuTime") long totalCaptureCpuTime, @.JsonProperty(value="totalCaptureWallTime") long totalCaptureWallTime, @.JsonProperty(value="lastCaptureCpuTime") long lastCaptureCpuTime, @.JsonProperty(value="lastCaptureWallTime") long lastCaptureWallTime, @.JsonProperty(value="allCaptureSize") long allCaptureSize, @.JsonProperty(value="lastCaptureSize") long lastCaptureSize, @.JsonProperty(value="restoredSnapshotList") List<Long> restoredSnapshotList, @.JsonProperty(value="capturedSnapshotList") List<Long> capturedSnapshotList, @.JsonProperty(value="successRestoreCount") long successRestoreCount, @.JsonProperty(value="totalRestoreWallTime") long totalRestoreWallTime, @.JsonProperty(value="totalRestoreSize") long totalRestoreSize, @.JsonProperty(value="totalRestoreCpuTime") long totalRestoreCpuTime, @.JsonProperty(value="restoringSnapshotId") long restoringSnapshotId, @.JsonProperty(value="capturingSnapshotIds") List<Long> capturingSnapshotIds) {
        this.lastCaptureSnapshotId = lastCaptureSnapshotId;
        this.totalCaptureCpuTime = totalCaptureCpuTime;
        this.totalCaptureWallTime = totalCaptureWallTime;
        this.lastCaptureCpuTime = lastCaptureCpuTime;
        this.lastCaptureWallTime = lastCaptureWallTime;
        this.allCaptureSize = allCaptureSize;
        this.lastCaptureSize = lastCaptureSize;
        this.restoredSnapshotList = restoredSnapshotList;
        this.capturedSnapshotList = capturedSnapshotList;
        this.successRestoreCount = successRestoreCount;
        this.totalRestoreWallTime = totalRestoreWallTime;
        this.totalRestoreSize = totalRestoreSize;
        this.totalRestoreCpuTime = totalRestoreCpuTime;
        this.restoringSnapshotId = restoringSnapshotId;
        this.capturingSnapshotIds = capturingSnapshotIds;
    }

    @.JsonProperty
    public long getLastCaptureSnapshotId() {
        return this.lastCaptureSnapshotId;
    }

    @.JsonProperty
    public long getTotalCaptureCpuTime() {
        return this.totalCaptureCpuTime;
    }

    @.JsonProperty
    public long getTotalCaptureWallTime() {
        return this.totalCaptureWallTime;
    }

    @.JsonProperty
    public long getLastCaptureCpuTime() {
        return this.lastCaptureCpuTime;
    }

    @.JsonProperty
    public long getLastCaptureWallTime() {
        return this.lastCaptureWallTime;
    }

    @.JsonProperty
    public long getAllCaptureSize() {
        return this.allCaptureSize;
    }

    @.JsonProperty
    public long getLastCaptureSize() {
        return this.lastCaptureSize;
    }

    @.JsonProperty
    public List<Long> getRestoredSnapshotList() {
        return this.restoredSnapshotList;
    }

    @.JsonProperty
    public List<Long> getCapturedSnapshotList() {
        return this.capturedSnapshotList;
    }

    @.JsonProperty
    public List<Long> getCapturingSnapshotIds() {
        return this.capturingSnapshotIds;
    }

    @.JsonProperty
    public long getRestoringSnapshotId() {
        return this.restoringSnapshotId;
    }

    @.JsonProperty
    public long getSuccessRestoreCount() {
        return this.successRestoreCount;
    }

    @.JsonProperty
    public long getTotalRestoreWallTime() {
        return this.totalRestoreWallTime;
    }

    @.JsonProperty
    public long getTotalRestoreSize() {
        return this.totalRestoreSize;
    }

    @.JsonProperty
    public long getTotalRestoreCpuTime() {
        return this.totalRestoreCpuTime;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("lastCaptureSnapshotId", this.lastCaptureSnapshotId).add("totalCaptureCpuTime", this.totalCaptureCpuTime).add("totalCaptureWallTime", this.totalCaptureWallTime).add("lastCaptureCpuTime", this.lastCaptureCpuTime).add("lastCaptureWallTime", this.lastCaptureWallTime).add("allCaptureSize", this.allCaptureSize).add("lastCaptureSize", this.lastCaptureSize).add("restoredSnapshotList", this.restoredSnapshotList).add("capturedSnapshotList", this.capturedSnapshotList).add("successRestoreCount", this.successRestoreCount).add("totalRestoreWallTime", this.totalRestoreWallTime).add("totalRestoreSize", this.totalRestoreSize).add("totalRestoreCpuTime", this.totalRestoreCpuTime).add("restoringSnapshotId", this.restoringSnapshotId).add("capturingSnapshotIds", this.capturingSnapshotIds).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private long lastCaptureSnapshotId;
        private long totalCaptureCpuTime;
        private long totalCaptureWallTime;
        private long lastCaptureCpuTime;
        private long lastCaptureWallTime;
        private long allCaptureSize;
        private long lastCaptureSize;
        private List<Long> restoredSnapshotList;
        private List<Long> capturedSnapshotList;
        private long successRestoreCount;
        private long totalRestoreWallTime;
        private long totalRestoreSize;
        private long totalRestoreCpuTime;
        private long restoringSnapshotId;
        private List<Long> capturingSnapshotIds;

        private Builder() {
        }

        public Builder setLastCaptureSnapshotId(long lastCaptureSnapshotId) {
            this.lastCaptureSnapshotId = lastCaptureSnapshotId;
            return this;
        }

        public Builder setTotalCpuTimeMillis(long totalCaptureCpuTime) {
            this.totalCaptureCpuTime = totalCaptureCpuTime;
            return this;
        }

        public Builder setTotalWallTimeMillis(long totalCaptureWallTime) {
            this.totalCaptureWallTime = totalCaptureWallTime;
            return this;
        }

        public Builder setLastSnapshotCpuTimeMillis(long lastCaptureCpuTime) {
            this.lastCaptureCpuTime = lastCaptureCpuTime;
            return this;
        }

        public Builder setLastSnapshotWallTimeMillis(long lastCaptureWallTime) {
            this.lastCaptureWallTime = lastCaptureWallTime;
            return this;
        }

        public Builder setAllSnapshotsSizeBytes(long allCaptureSize) {
            this.allCaptureSize = allCaptureSize;
            return this;
        }

        public Builder setLastSnapshotSizeBytes(long lastCaptureSize) {
            this.lastCaptureSize = lastCaptureSize;
            return this;
        }

        public Builder setRestoringSnapshotId(long restoringSnapshotId) {
            this.restoringSnapshotId = restoringSnapshotId;
            return this;
        }

        public Builder setRestoredSnapshotList(List<Long> restoredSnapshotList) {
            this.restoredSnapshotList = restoredSnapshotList;
            return this;
        }

        public Builder setCapturedSnapshotList(List<Long> capturedSnapshotList) {
            this.capturedSnapshotList = capturedSnapshotList;
            return this;
        }

        public Builder setSuccessRestoreCount(long successRestoreCount) {
            this.successRestoreCount = successRestoreCount;
            return this;
        }

        public Builder setTotalRestoreWallTime(long totalRestoreWallTime) {
            this.totalRestoreWallTime = totalRestoreWallTime;
            return this;
        }

        public Builder setTotalRestoreSize(long totalRestoreSize) {
            this.totalRestoreSize = totalRestoreSize;
            return this;
        }

        public Builder setTotalRestoreCpuTime(long totalRestoreCpuTime) {
            this.totalRestoreCpuTime = totalRestoreCpuTime;
            return this;
        }

        public Builder setCapturingSnapshotIds(List<Long> capturingSnapshotIds) {
            this.capturingSnapshotIds = capturingSnapshotIds;
            return this;
        }

        public SnapshotStats build() {
            return new SnapshotStats(this.lastCaptureSnapshotId, this.totalCaptureCpuTime, this.totalCaptureWallTime, this.lastCaptureCpuTime, this.lastCaptureWallTime, this.allCaptureSize, this.lastCaptureSize, this.restoredSnapshotList, this.capturedSnapshotList, this.successRestoreCount, this.totalRestoreWallTime, this.totalRestoreSize, this.totalRestoreCpuTime, this.restoringSnapshotId, this.capturingSnapshotIds);
        }
    }
}

