/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.jdbc.$internal.client;

import com.sun.security.auth.module.Krb5LoginModule;
import io.prestosql.jdbc.;
import io.prestosql.jdbc.$internal.airlift.units.Duration;
import io.prestosql.jdbc.$internal.client.ClientException;
import io.prestosql.jdbc.$internal.guava.base.CharMatcher;
import io.prestosql.jdbc.$internal.guava.base.Splitter;
import io.prestosql.jdbc.$internal.guava.base.Throwables;
import io.prestosql.jdbc.$internal.guava.collect.ImmutableMap;
import io.prestosql.jdbc.$internal.okhttp3.Authenticator;
import io.prestosql.jdbc.$internal.okhttp3.Interceptor;
import io.prestosql.jdbc.$internal.okhttp3.Request;
import io.prestosql.jdbc.$internal.okhttp3.Response;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.util.Base64;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.security.auth.Subject;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class SpnegoHandler
implements Interceptor,
Authenticator {
    private static final String NEGOTIATE = "Negotiate";
    private static final Duration MIN_CREDENTIAL_LIFETIME = new Duration(60.0, TimeUnit.SECONDS);
    private static final GSSManager GSS_MANAGER = GSSManager.getInstance();
    private static final Oid SPNEGO_OID = SpnegoHandler.createOid("1.3.6.1.5.5.2");
    private static final Oid KERBEROS_OID = SpnegoHandler.createOid("1.2.840.113554.1.2.2");
    private final String servicePrincipalPattern;
    private final String remoteServiceName;
    private final boolean useCanonicalHostname;
    private final Optional<String> principal;
    private final Optional<File> keytab;
    private final Optional<File> credentialCache;
    @.GuardedBy(value="this")
    private Session clientSession;

    public SpnegoHandler(String servicePrincipalPattern, String remoteServiceName, boolean useCanonicalHostname, Optional<String> principal, Optional<File> kerberosConfig, Optional<File> keytab, Optional<File> credentialCache) {
        this.servicePrincipalPattern = Objects.requireNonNull(servicePrincipalPattern, "servicePrincipalPattern is null");
        this.remoteServiceName = Objects.requireNonNull(remoteServiceName, "remoteServiceName is null");
        this.useCanonicalHostname = useCanonicalHostname;
        this.principal = Objects.requireNonNull(principal, "principal is null");
        this.keytab = Objects.requireNonNull(keytab, "keytab is null");
        this.credentialCache = Objects.requireNonNull(credentialCache, "credentialCache is null");
        kerberosConfig.ifPresent(file -> System.setProperty("java.security.krb5.conf", file.getAbsolutePath()));
    }

    @Override
    public Response intercept(Interceptor.Chain chain) throws IOException {
        try {
            return chain.proceed(this.authenticate(chain.request()));
        }
        catch (ClientException ignored) {
            return chain.proceed(chain.request());
        }
    }

    @Override
    public Request authenticate(.Route route, Response response) {
        if (response.request().headers("Authorization").stream().anyMatch(SpnegoHandler::isNegotiate) || response.headers("WWW-Authenticate").stream().noneMatch(SpnegoHandler::isNegotiate)) {
            return null;
        }
        return this.authenticate(response.request());
    }

    private static boolean isNegotiate(String value) {
        return Splitter.on(CharMatcher.whitespace()).split(value).iterator().next().equalsIgnoreCase(NEGOTIATE);
    }

    private Request authenticate(Request request) {
        String hostName = request.url().host();
        byte[] token = this.generateToken(SpnegoHandler.makeServicePrincipal(this.servicePrincipalPattern, this.remoteServiceName, hostName, this.useCanonicalHostname));
        String credential = String.format("%s %s", NEGOTIATE, Base64.getEncoder().encodeToString(token));
        return request.newBuilder().header("Authorization", credential).build();
    }

    private byte[] generateToken(String servicePrincipal) {
        GSSContext context = null;
        try {
            Session session = this.getSession();
            context = SpnegoHandler.doAs(session.getLoginContext().getSubject(), () -> {
                GSSContext result = GSS_MANAGER.createContext(GSS_MANAGER.createName(servicePrincipal, GSSName.NT_HOSTBASED_SERVICE), SPNEGO_OID, session.getClientCredential(), Integer.MAX_VALUE);
                result.requestMutualAuth(true);
                result.requestConf(true);
                result.requestInteg(true);
                result.requestCredDeleg(false);
                return result;
            });
            byte[] token = context.initSecContext(new byte[0], 0, 0);
            if (token == null) {
                throw new LoginException("No token generated from GSS context");
            }
            byte[] byArray = token;
            return byArray;
        }
        catch (LoginException | GSSException e) {
            throw new ClientException(String.format("Kerberos error for [%s]: %s", servicePrincipal, e.getMessage()), e);
        }
        finally {
            try {
                if (context != null) {
                    context.dispose();
                }
            }
            catch (GSSException gSSException) {}
        }
    }

    private synchronized Session getSession() throws LoginException, GSSException {
        if (this.clientSession == null || this.clientSession.needsRefresh()) {
            this.clientSession = this.createSession();
        }
        return this.clientSession;
    }

    private Session createSession() throws LoginException, GSSException {
        LoginContext loginContext = new LoginContext("", null, null, new Configuration(){

            @Override
            public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                ImmutableMap.Builder<String, String> options = ImmutableMap.builder();
                options.put("refreshKrb5Config", "true");
                options.put("doNotPrompt", "true");
                options.put("useKeyTab", "true");
                if (Boolean.getBoolean("presto.client.debugKerberos")) {
                    options.put("debug", "true");
                }
                SpnegoHandler.this.keytab.ifPresent(file -> options.put("keyTab", file.getAbsolutePath()));
                SpnegoHandler.this.credentialCache.ifPresent(file -> {
                    options.put("ticketCache", file.getAbsolutePath());
                    options.put("useTicketCache", "true");
                    options.put("renewTGT", "true");
                });
                SpnegoHandler.this.principal.ifPresent(value -> options.put("principal", (String)value));
                return new AppConfigurationEntry[]{new AppConfigurationEntry(Krb5LoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options.build())};
            }
        });
        loginContext.login();
        Subject subject = loginContext.getSubject();
        Principal clientPrincipal = subject.getPrincipals().iterator().next();
        GSSCredential clientCredential = SpnegoHandler.doAs(subject, () -> GSS_MANAGER.createCredential(GSS_MANAGER.createName(clientPrincipal.getName(), GSSName.NT_USER_NAME), 0, KERBEROS_OID, 1));
        return new Session(loginContext, clientCredential);
    }

    private static String makeServicePrincipal(String servicePrincipalPattern, String serviceName, String hostName, boolean useCanonicalHostname) {
        String serviceHostName = hostName;
        if (useCanonicalHostname) {
            serviceHostName = SpnegoHandler.canonicalizeServiceHostName(hostName);
        }
        return servicePrincipalPattern.replaceAll("\\$\\{SERVICE}", serviceName).replaceAll("\\$\\{HOST}", serviceHostName.toLowerCase(Locale.US));
    }

    private static String canonicalizeServiceHostName(String hostName) {
        try {
            InetAddress address = InetAddress.getByName(hostName);
            String fullHostName = "localhost".equalsIgnoreCase(address.getHostName()) ? InetAddress.getLocalHost().getCanonicalHostName() : address.getCanonicalHostName();
            if (fullHostName.equalsIgnoreCase("localhost")) {
                throw new ClientException("Fully qualified name of localhost should not resolve to 'localhost'. System configuration error?");
            }
            return fullHostName;
        }
        catch (UnknownHostException e) {
            throw new ClientException("Failed to resolve host: " + hostName, e);
        }
    }

    private static <T> T doAs(Subject subject, GssSupplier<T> action) throws GSSException {
        try {
            return (T)Subject.doAs(subject, action::get);
        }
        catch (PrivilegedActionException e) {
            Throwable t = e.getCause();
            Throwables.throwIfInstanceOf(t, GSSException.class);
            Throwables.throwIfUnchecked(t);
            throw new RuntimeException(t);
        }
    }

    private static Oid createOid(String value) {
        try {
            return new Oid(value);
        }
        catch (GSSException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static class Session {
        private final LoginContext loginContext;
        private final GSSCredential clientCredential;

        public Session(LoginContext loginContext, GSSCredential clientCredential) {
            Objects.requireNonNull(loginContext, "loginContext is null");
            Objects.requireNonNull(clientCredential, "gssCredential is null");
            this.loginContext = loginContext;
            this.clientCredential = clientCredential;
        }

        public LoginContext getLoginContext() {
            return this.loginContext;
        }

        public GSSCredential getClientCredential() {
            return this.clientCredential;
        }

        public boolean needsRefresh() throws GSSException {
            return (double)this.clientCredential.getRemainingLifetime() < MIN_CREDENTIAL_LIFETIME.getValue(TimeUnit.SECONDS);
        }
    }

    private static interface GssSupplier<T> {
        public T get() throws GSSException;
    }
}

