/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.jdbc.$internal.client;

import io.prestosql.jdbc.;
import io.prestosql.jdbc.$internal.client.ClientException;
import io.prestosql.jdbc.$internal.client.ClientSelectedRole;
import io.prestosql.jdbc.$internal.client.JsonResponse;
import io.prestosql.jdbc.$internal.client.QueryData;
import io.prestosql.jdbc.$internal.client.QueryStatusInfo;
import io.prestosql.jdbc.$internal.client.StatementStats;
import io.prestosql.jdbc.$internal.okhttp3.Request;
import java.io.Closeable;
import java.time.ZoneId;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface StatementClient
extends Closeable {
    public String getQuery();

    public ZoneId getTimeZone();

    public boolean isRunning();

    public boolean isClientAborted();

    public boolean isClientError();

    public boolean isFinished();

    public StatementStats getStats();

    public QueryStatusInfo currentStatusInfo();

    public QueryData currentData();

    public QueryStatusInfo finalStatusInfo();

    public Optional<String> getSetCatalog();

    public Optional<String> getSetSchema();

    public Optional<String> getSetPath();

    public Map<String, String> getSetSessionProperties();

    public Set<String> getResetSessionProperties();

    public Map<String, ClientSelectedRole> getSetRoles();

    public Map<String, String> getAddedPreparedStatements();

    public Set<String> getDeallocatedPreparedStatements();

    @.Nullable
    public String getStartedTransactionId();

    public boolean isClearTransactionId();

    public boolean advance();

    public void cancelLeafStage();

    public boolean isTimeInMilliseconds();

    @Override
    public void close();

    default public <T> RuntimeException requestFailedException(String task, Request request, JsonResponse<T> response) {
        if (!response.hasValue()) {
            if (response.getStatusCode() == 401) {
                return new ClientException("Authentication failed" + Optional.ofNullable(response.getStatusMessage()).map(message -> ": " + message).orElse(""));
            }
            return new RuntimeException(String.format("Error %s at %s returned an invalid response: %s [Error: %s]", task, request.url(), response, response.getResponseBody()), response.getException());
        }
        return new RuntimeException(String.format("Error %s at %s returned HTTP %s", task, request.url(), response.getStatusCode()));
    }
}

