/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.jdbc.$internal.client.block;

import io.prestosql.jdbc.;
import io.prestosql.jdbc.$internal.airlift.slice.SliceInput;
import io.prestosql.jdbc.$internal.airlift.slice.SliceOutput;
import io.prestosql.jdbc.$internal.guava.collect.ImmutableMap;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;

public final class ExternalBlockEncodingSerde
implements .BlockEncodingSerde {
    private final Map<String, .BlockEncoding> blockEncodings;

    public ExternalBlockEncodingSerde(.TypeManager typeManager) {
        this.blockEncodings = ImmutableMap.builder().put("VARIABLE_WIDTH", new .VariableWidthBlockEncoding()).put("BYTE_ARRAY", (.VariableWidthBlockEncoding)new .ByteArrayBlockEncoding()).put("SHORT_ARRAY", (.VariableWidthBlockEncoding)new .ShortArrayBlockEncoding()).put("INT_ARRAY", (.VariableWidthBlockEncoding)new .IntArrayBlockEncoding()).put("LONG_ARRAY", (.VariableWidthBlockEncoding)new .LongArrayBlockEncoding()).put("INT128_ARRAY", (.VariableWidthBlockEncoding)new .Int128ArrayBlockEncoding()).put("DICTIONARY", (.VariableWidthBlockEncoding)new .DictionaryBlockEncoding()).put("ARRAY", (.VariableWidthBlockEncoding)new .ArrayBlockEncoding()).put("MAP", (.VariableWidthBlockEncoding)new .MapBlockEncoding(typeManager)).put("MAP_ELEMENT", (.VariableWidthBlockEncoding)new .SingleMapBlockEncoding(typeManager)).put("ROW", (.VariableWidthBlockEncoding)new .RowBlockEncoding()).put("ROW_ELEMENT", (.VariableWidthBlockEncoding)new .SingleRowBlockEncoding()).put("RLE", (.VariableWidthBlockEncoding)new .RunLengthBlockEncoding()).put("LAZY", (.VariableWidthBlockEncoding)new .LazyBlockEncoding()).build();
    }

    public .Block readBlock(SliceInput input) {
        String encodingName = ExternalBlockEncodingSerde.readLengthPrefixedString(input);
        .BlockEncoding blockEncoding = this.blockEncodings.get(encodingName);
        return blockEncoding.readBlock((.BlockEncodingSerde)this, input);
    }

    public void writeBlock(SliceOutput output, .Block inputBlock) {
        String encodingName;
        .BlockEncoding blockEncoding;
        Optional replacementBlock;
        .Block block = inputBlock;
        while ((replacementBlock = (blockEncoding = this.blockEncodings.get(encodingName = block.getEncodingName())).replacementBlockForWrite(block)).isPresent()) {
            block = (.Block)replacementBlock.get();
        }
        ExternalBlockEncodingSerde.writeLengthPrefixedString(output, encodingName);
        blockEncoding.writeBlock((.BlockEncodingSerde)this, output, block);
    }

    private static String readLengthPrefixedString(SliceInput input) {
        int length = input.readInt();
        byte[] bytes = new byte[length];
        input.readBytes(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private static void writeLengthPrefixedString(SliceOutput output, String value) {
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        output.writeInt(bytes.length);
        output.writeBytes(bytes);
    }
}

