/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.jdbc.$internal.client.util;

import io.prestosql.jdbc.$internal.airlift.json.JsonCodec;
import io.prestosql.jdbc.$internal.client.ClientCapabilities;
import io.prestosql.jdbc.$internal.client.ClientException;
import io.prestosql.jdbc.$internal.client.ClientSelectedRole;
import io.prestosql.jdbc.$internal.client.CrossRegionDynamicFilterRequest;
import io.prestosql.jdbc.$internal.client.DataCenterClientSession;
import io.prestosql.jdbc.$internal.client.DataCenterRequest;
import io.prestosql.jdbc.$internal.client.DataCenterResponseType;
import io.prestosql.jdbc.$internal.guava.base.Joiner;
import io.prestosql.jdbc.$internal.guava.base.MoreObjects;
import io.prestosql.jdbc.$internal.okhttp3.HttpUrl;
import io.prestosql.jdbc.$internal.okhttp3.MediaType;
import io.prestosql.jdbc.$internal.okhttp3.Request;
import io.prestosql.jdbc.$internal.okhttp3.RequestBody;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;

public class HttpUtil {
    private static final MediaType MEDIA_TYPE_JSON = MediaType.parse("application/json; charset=utf-8");
    private static final String ACCEPT_ENCODING_HEADER = "Accept-Encoding";
    private static final String ROOT_URL = "/v1/dc/statement/";
    private static final String DYNAMIC_FILTER_URL = "/v1/dc/filter/";
    private static final String USER_AGENT_VALUE = "DataCenterClient/" + MoreObjects.firstNonNull(HttpUtil.class.getPackage().getImplementationVersion(), "unknown");
    private static final String CLIENT_CAPABILITIES = Joiner.on(",").join((Object[])ClientCapabilities.values());
    private static final JsonCodec<DataCenterRequest> DATA_CENTER_REQUEST_CODEC = JsonCodec.jsonCodec(DataCenterRequest.class);
    private static final JsonCodec<CrossRegionDynamicFilterRequest> CRDF_REQUEST_CODEC = JsonCodec.jsonCodec(CrossRegionDynamicFilterRequest.class);

    private HttpUtil() {
    }

    public static Request buildQueryRequest(String clientId, DataCenterClientSession session, String queryId, String query) {
        HttpUrl url = HttpUrl.get(session.getServer());
        if (url == null) {
            throw new ClientException("Invalid server URL: " + session.getServer());
        }
        url = url.newBuilder().encodedPath(ROOT_URL + queryId).build();
        DataCenterRequest request = new DataCenterRequest(queryId, clientId, query, session.getMaxAnticipatedDelay(), DataCenterResponseType.HTTP_PULL);
        Request.Builder builder = HttpUtil.prepareRequest(url, session).post(RequestBody.create(MEDIA_TYPE_JSON, DATA_CENTER_REQUEST_CODEC.toJsonBytes(request)));
        if (session.getSource() != null) {
            builder.addHeader("X-Presto-Source", session.getSource());
        }
        session.getTraceToken().ifPresent(token -> builder.addHeader("X-Presto-Trace-Token", (String)token));
        if (session.getClientTags() != null && !session.getClientTags().isEmpty()) {
            builder.addHeader("X-Presto-Client-Tags", Joiner.on(",").join(session.getClientTags()));
        }
        if (session.getClientInfo() != null) {
            builder.addHeader("X-Presto-Client-Info", session.getClientInfo());
        }
        if (session.getCatalog() != null) {
            builder.addHeader("X-Presto-Catalog", session.getCatalog());
        }
        if (session.getSchema() != null) {
            builder.addHeader("X-Presto-Schema", session.getSchema());
        }
        if (session.getPath() != null) {
            builder.addHeader("X-Presto-Path", session.getPath());
        }
        builder.addHeader("X-Presto-Time-Zone", session.getTimeZone().getId());
        if (session.getLocale() != null) {
            builder.addHeader("X-Presto-Language", session.getLocale().toLanguageTag());
        }
        Map<String, String> property = session.getProperties();
        for (Map.Entry<String, String> entry : property.entrySet()) {
            builder.addHeader("X-Presto-Session", entry.getKey() + "=" + HttpUtil.urlEncode(entry.getValue()));
        }
        Map<String, String> resourceEstimates = session.getResourceEstimates();
        for (Map.Entry<String, String> entry : resourceEstimates.entrySet()) {
            builder.addHeader("X-Presto-Resource-Estimate", entry.getKey() + "=" + HttpUtil.urlEncode(entry.getValue()));
        }
        Map<String, ClientSelectedRole> map = session.getRoles();
        for (Map.Entry<String, ClientSelectedRole> entry : map.entrySet()) {
            builder.addHeader("X-Presto-Role", entry.getKey() + '=' + HttpUtil.urlEncode(entry.getValue().toString()));
        }
        Map<String, String> map2 = session.getExtraCredentials();
        for (Map.Entry<String, String> entry : map2.entrySet()) {
            builder.addHeader("X-Presto-Extra-Credential", entry.getKey() + "=" + HttpUtil.urlEncode(entry.getValue()));
        }
        Map<String, String> map3 = session.getPreparedStatements();
        for (Map.Entry<String, String> entry : map3.entrySet()) {
            builder.addHeader("X-Presto-Prepared-Statement", HttpUtil.urlEncode(entry.getKey()) + "=" + HttpUtil.urlEncode(entry.getValue()));
        }
        builder.addHeader("X-Presto-Transaction-Id", session.getTransactionId() == null ? "NONE" : session.getTransactionId());
        builder.addHeader("X-Presto-Client-Capabilities", CLIENT_CAPABILITIES);
        return builder.build();
    }

    public static Request buildDynamicFilterRequest(String clientId, DataCenterClientSession session, String queryId, Map<String, byte[]> dynamicFilters) {
        HttpUrl url = HttpUrl.get(session.getServer());
        if (url == null) {
            throw new ClientException("Invalid server URL: " + session.getServer());
        }
        url = url.newBuilder().encodedPath(DYNAMIC_FILTER_URL + queryId).build();
        CrossRegionDynamicFilterRequest request = new CrossRegionDynamicFilterRequest(queryId, clientId, dynamicFilters);
        Request.Builder builder = HttpUtil.prepareRequest(url, session).post(RequestBody.create(MEDIA_TYPE_JSON, CRDF_REQUEST_CODEC.toJsonBytes(request)));
        return builder.build();
    }

    public static Request.Builder prepareRequest(HttpUrl url, DataCenterClientSession session) {
        Request.Builder builder = new Request.Builder();
        builder.addHeader("X-Presto-User", session.getUser()).addHeader("User-Agent", USER_AGENT_VALUE);
        builder.addHeader(ACCEPT_ENCODING_HEADER, "");
        if (System.getProperty("Content-Security-Policy") != null) {
            builder.addHeader("Content-Security-Policy", System.getProperty("Content-Security-Policy"));
        } else {
            builder.addHeader("Content-Security-Policy", "object-src 'none'");
        }
        if (System.getProperty("Referrer-Policy") != null) {
            builder.addHeader("Referrer-Policy", System.getProperty("Referrer-Policy"));
        } else {
            builder.addHeader("Referrer-Policy", "strict-origin-when-cross-origin");
        }
        if (System.getProperty("X-Content-Type-Options") != null) {
            builder.addHeader("X-Content-Type-Options", System.getProperty("X-Content-Type-Options"));
        } else {
            builder.addHeader("X-Content-Type-Options", "nosniff");
        }
        if (System.getProperty("X-Frame-Options") != null) {
            builder.addHeader("X-Frame-Options", System.getProperty("X-Frame-Options"));
        } else {
            builder.addHeader("X-Frame-Options", "deny");
        }
        if (System.getProperty("X-Permitted-Cross-Domain-Policies") != null) {
            builder.addHeader("X-Permitted-Cross-Domain-Policies", System.getProperty("X-Permitted-Cross-Domain-Policies"));
        } else {
            builder.addHeader("X-Permitted-Cross-Domain-Policies", "master-only");
        }
        if (System.getProperty("X-XSS-Protection") != null) {
            builder.addHeader("X-XSS-Protection", System.getProperty("X-XSS-Protection"));
        } else {
            builder.addHeader("X-XSS-Protection", "1; mode=block");
        }
        return builder.url(url);
    }

    private static String urlEncode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }
}

