/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.jdbc.$internal.client.util;

import io.prestosql.jdbc.;
import io.prestosql.jdbc.$internal.guava.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TypeUtil {
    private static final Pattern DESCRIBE_TYPE_PATTERN = Pattern.compile("(?<type>[a-zA-Z1-9 _]+)");
    private static final Map<String, .ParametricType> PARAMETRIC_TYPE_MAP = new ImmutableMap.Builder<String, .DecimalParametricType>().put(.DecimalParametricType.DECIMAL.getName(), .DecimalParametricType.DECIMAL).put(.CharParametricType.CHAR.getName(), (.DecimalParametricType).CharParametricType.CHAR).put(.VarcharParametricType.VARCHAR.getName(), (.DecimalParametricType).VarcharParametricType.VARCHAR).put(.ArrayParametricType.ARRAY.getName(), (.DecimalParametricType).ArrayParametricType.ARRAY).put(.MapParametricType.MAP.getName(), (.DecimalParametricType).MapParametricType.MAP).put(.RowParametricType.ROW.getName(), (.DecimalParametricType).RowParametricType.ROW).build();

    private TypeUtil() {
    }

    private static .Type typeMapping(String type) {
        switch (type) {
            case "bigint": {
                return .BigintType.BIGINT;
            }
            case "integer": {
                return .IntegerType.INTEGER;
            }
            case "smallint": {
                return .SmallintType.SMALLINT;
            }
            case "tinyint": {
                return .TinyintType.TINYINT;
            }
            case "boolean": {
                return .BooleanType.BOOLEAN;
            }
            case "date": {
                return .DateType.DATE;
            }
            case "real": {
                return .RealType.REAL;
            }
            case "double": {
                return .DoubleType.DOUBLE;
            }
            case "HyperLogLog": {
                return .HyperLogLogType.HYPER_LOG_LOG;
            }
            case "P4HyperLogLog": {
                return .P4HyperLogLogType.P4_HYPER_LOG_LOG;
            }
            case "timestamp": {
                return .TimestampType.TIMESTAMP;
            }
            case "timestamp with time zone": {
                return .TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE;
            }
            case "time": {
                return .TimeType.TIME;
            }
            case "time with time zone": {
                return .TimeWithTimeZoneType.TIME_WITH_TIME_ZONE;
            }
            case "varbinary": {
                return .VarbinaryType.VARBINARY;
            }
            case "unknown": {
                return .UnknownType.UNKNOWN;
            }
        }
        return null;
    }

    private static .Type parametricType(.TypeManager typeManager, .TypeSignature typeSignature) {
        String typeName = typeSignature.getBase().toLowerCase(Locale.ENGLISH);
        .ParametricType parametricType = PARAMETRIC_TYPE_MAP.get(typeName);
        if (parametricType != null) {
            ArrayList<.TypeParameter> parameters = new ArrayList<.TypeParameter>();
            for (.TypeSignatureParameter parameter : typeSignature.getParameters()) {
                .TypeParameter typeParameter = .TypeParameter.of((.TypeSignatureParameter)parameter, (.TypeManager)typeManager);
                parameters.add(typeParameter);
            }
            return parametricType.createType(typeManager, parameters);
        }
        return null;
    }

    public static .Type parseType(.TypeManager typeManager, String typeName) {
        .Type hetuType = null;
        Matcher matcher = DESCRIBE_TYPE_PATTERN.matcher(typeName);
        if (matcher.matches()) {
            String type = matcher.group("type");
            hetuType = TypeUtil.typeMapping(type);
        }
        if (hetuType == null) {
            .TypeSignature typeSignature = .TypeSignature.parseTypeSignature((String)typeName);
            hetuType = TypeUtil.parametricType(typeManager, typeSignature);
        }
        if (hetuType == null) {
            throw new IllegalArgumentException("Type " + typeName + " is not supported");
        }
        return hetuType;
    }
}

