/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.jdbc.$internal.jol.info;

import io.prestosql.jdbc.$internal.jol.info.ClassData;
import io.prestosql.jdbc.$internal.jol.info.FieldLayout;
import io.prestosql.jdbc.$internal.jol.layouters.CurrentLayouter;
import io.prestosql.jdbc.$internal.jol.layouters.Layouter;
import io.prestosql.jdbc.$internal.jol.util.VMSupport;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.SortedSet;

public class ClassLayout {
    private final ClassData classData;
    private final SortedSet<FieldLayout> fields;
    private final int headerSize;
    private final int size;

    public static ClassLayout parseClass(Class<?> klass) {
        return ClassLayout.parseClass(klass, new CurrentLayouter());
    }

    public static ClassLayout parseClass(Class<?> klass, Layouter layouter) {
        return layouter.layout(ClassData.parseClass(klass));
    }

    public ClassLayout(ClassData classData, SortedSet<FieldLayout> fields, int headerSize, int instanceSize, boolean check) {
        this.classData = classData;
        this.fields = fields;
        this.headerSize = headerSize;
        this.size = instanceSize;
        if (check) {
            this.checkInvariants();
        }
    }

    private void checkInvariants() {
        long lastOffset = 0L;
        for (FieldLayout f : this.fields) {
            if (f.offset() % f.size() != 0) {
                throw new IllegalStateException("Field " + f + " is not aligned");
            }
            if (f.offset() + f.size() > this.instanceSize()) {
                throw new IllegalStateException("Field " + f + " is overflowing the object of size " + this.instanceSize());
            }
            if ((long)f.offset() < lastOffset) {
                throw new IllegalStateException("Field " + f + " overlaps with the previous field");
            }
            lastOffset = f.offset() + f.size();
        }
    }

    public SortedSet<FieldLayout> fields() {
        return this.fields;
    }

    public int instanceSize() {
        return this.size;
    }

    public int headerSize() {
        return this.headerSize;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (FieldLayout f : this.fields()) {
            sb.append(f).append("\n");
        }
        sb.append("size = ").append(this.size).append("\n");
        return sb.toString();
    }

    public String toPrintable() {
        return this.toPrintable(null);
    }

    public String toPrintable(Object instance) {
        int n;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        int maxTypeLen = 5;
        for (FieldLayout fieldLayout : this.fields()) {
            maxTypeLen = Math.max(fieldLayout.typeClass().length(), maxTypeLen);
        }
        int maxDescrLen = 30;
        for (FieldLayout f : this.fields()) {
            maxDescrLen = Math.max((f.hostClass() + "" + f.name()).length(), maxDescrLen);
        }
        pw.println(this.classData.name() + " object internals:");
        pw.printf(" %6s %5s %" + maxTypeLen + "s %-" + maxDescrLen + "s %s%n", "OFFSET", "SIZE", "TYPE", "DESCRIPTION", "VALUE");
        if (instance != null) {
            for (long i = 0L; i < (long)this.headerSize(); i += 4L) {
                pw.printf(" %6d %5d %" + maxTypeLen + "s %-" + maxDescrLen + "s %s%n", i, 4, "", "(object header)", ClassLayout.toHex(VMSupport.U.getByte(instance, i + 0L) & 0xFF) + " " + ClassLayout.toHex(VMSupport.U.getByte(instance, i + 1L) & 0xFF) + " " + ClassLayout.toHex(VMSupport.U.getByte(instance, i + 2L) & 0xFF) + " " + ClassLayout.toHex(VMSupport.U.getByte(instance, i + 3L) & 0xFF) + " " + "(" + ClassLayout.toBinary(VMSupport.U.getByte(instance, i + 0L) & 0xFF) + " " + ClassLayout.toBinary(VMSupport.U.getByte(instance, i + 1L) & 0xFF) + " " + ClassLayout.toBinary(VMSupport.U.getByte(instance, i + 2L) & 0xFF) + " " + ClassLayout.toBinary(VMSupport.U.getByte(instance, i + 3L) & 0xFF) + ")");
            }
        } else {
            pw.printf(" %6d %5d %" + maxTypeLen + "s %-" + maxDescrLen + "s %s%n", 0, this.headerSize(), "", "(object header)", "N/A");
        }
        int n2 = this.headerSize();
        int interLoss = 0;
        int exterLoss = 0;
        for (FieldLayout f : this.fields()) {
            if (f.offset() > n) {
                pw.printf(" %6d %5d %" + maxTypeLen + "s %-" + maxDescrLen + "s %s%n", n, f.offset() - n, "", "(alignment/padding gap)", "N/A");
                interLoss += f.offset() - n;
            }
            pw.printf(" %6d %5d %" + maxTypeLen + "s %-" + maxDescrLen + "s %s%n", f.offset(), f.size(), f.typeClass(), f.hostClass() + "." + f.name(), instance != null ? f.safeValue(instance) : "N/A");
            n = f.offset() + f.size();
        }
        VMSupport.SizeInfo info = VMSupport.tryExactObjectSize(instance, this);
        if (info.instanceSize() != n) {
            exterLoss = info.instanceSize() - n;
            pw.printf(" %6d %5s %" + maxTypeLen + "s %s%n", n, exterLoss, "", "(loss due to the next object alignment)");
        }
        if (info.exactSize()) {
            pw.printf("Instance size: %d bytes (reported by VM agent)%n", info.instanceSize());
        } else if (instance != null) {
            pw.printf("Instance size: %d bytes (estimated, add this JAR via -javaagent: to get accurate result)%n", info.instanceSize());
        } else {
            pw.printf("Instance size: %d bytes (estimated, the sample instance is not available)%n", info.instanceSize());
        }
        pw.printf("Space losses: %d bytes internal + %d bytes external = %d bytes total%n", interLoss, exterLoss, interLoss + exterLoss);
        pw.close();
        return sw.toString();
    }

    private static String toBinary(int x) {
        String s = Integer.toBinaryString(x);
        int deficit = 8 - s.length();
        for (int c = 0; c < deficit; ++c) {
            s = "0" + s;
        }
        return s.substring(0, 4) + " " + s.substring(4);
    }

    private static String toHex(int x) {
        String s = Integer.toHexString(x);
        int deficit = 2 - s.length();
        for (int c = 0; c < deficit; ++c) {
            s = "0" + s;
        }
        return s;
    }
}

