/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.jdbc.$internal.jol.layouters;

import io.prestosql.jdbc.$internal.jol.datamodel.DataModel;
import io.prestosql.jdbc.$internal.jol.info.ClassData;
import io.prestosql.jdbc.$internal.jol.info.ClassLayout;
import io.prestosql.jdbc.$internal.jol.info.FieldData;
import io.prestosql.jdbc.$internal.jol.info.FieldLayout;
import io.prestosql.jdbc.$internal.jol.layouters.Layouter;
import java.util.TreeSet;

public class RawLayouter
implements Layouter {
    private final DataModel model;

    public RawLayouter(DataModel model) {
        this.model = model;
    }

    @Override
    public ClassLayout layout(ClassData data) {
        TreeSet<FieldLayout> result = new TreeSet<FieldLayout>();
        if (data.isArray()) {
            int base = this.model.headerSize() + this.model.sizeOf("int");
            int scale = this.model.sizeOf(data.arrayComponentType());
            int instanceSize = base + data.arrayLength() * scale;
            result.add(new FieldLayout(FieldData.create(data.arrayClass(), "length", "int"), this.model.headerSize(), this.model.sizeOf("int")));
            result.add(new FieldLayout(FieldData.create(data.arrayClass(), "<elements>", data.arrayComponentType()), base, scale * data.arrayLength()));
            return new ClassLayout(data, result, this.model.headerSize(), instanceSize, false);
        }
        int offset = this.model.headerSize();
        for (FieldData f : data.fields()) {
            int size = this.model.sizeOf(f.typeClass());
            result.add(new FieldLayout(f, offset, size));
            offset += size;
        }
        if (result.isEmpty()) {
            return new ClassLayout(data, result, this.model.headerSize(), this.model.headerSize(), false);
        }
        FieldLayout f = (FieldLayout)result.last();
        return new ClassLayout(data, result, this.model.headerSize(), f.offset() + f.size(), false);
    }

    public String toString() {
        return "Raw data (" + this.model + ")";
    }
}

