/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.jdbc;

import io.prestosql.jdbc.$internal.guava.base.CharMatcher;
import io.prestosql.jdbc.$internal.guava.base.Preconditions;
import io.prestosql.jdbc.$internal.guava.base.Splitter;
import io.prestosql.jdbc.$internal.guava.collect.ImmutableMap;
import io.prestosql.jdbc.$internal.guava.collect.ImmutableSet;
import io.prestosql.jdbc.$internal.guava.net.HostAndPort;
import io.prestosql.jdbc.AbstractConnectionProperty;
import io.prestosql.jdbc.ConnectionProperty;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

final class ConnectionProperties {
    public static final ConnectionProperty<String> USER = new User();
    public static final ConnectionProperty<String> PASSWORD = new Password();
    public static final ConnectionProperty<HostAndPort> SOCKS_PROXY = new SocksProxy();
    public static final ConnectionProperty<HostAndPort> HTTP_PROXY = new HttpProxy();
    public static final ConnectionProperty<String> APPLICATION_NAME_PREFIX = new ApplicationNamePrefix();
    public static final ConnectionProperty<Boolean> SSL = new Ssl();
    public static final ConnectionProperty<String> SSL_KEY_STORE_PATH = new SslKeyStorePath();
    public static final ConnectionProperty<String> SSL_KEY_STORE_PASSWORD = new SslKeyStorePassword();
    public static final ConnectionProperty<String> SSL_TRUST_STORE_PATH = new SslTrustStorePath();
    public static final ConnectionProperty<String> SSL_TRUST_STORE_PASSWORD = new SslTrustStorePassword();
    public static final ConnectionProperty<String> KERBEROS_SERVICE_PRINCIPAL_PATTERN = new KerberosServicePrincipalPattern();
    public static final ConnectionProperty<String> KERBEROS_REMOTE_SERVICE_NAME = new KerberosRemoteServiceName();
    public static final ConnectionProperty<Boolean> KERBEROS_USE_CANONICAL_HOSTNAME = new KerberosUseCanonicalHostname();
    public static final ConnectionProperty<String> KERBEROS_PRINCIPAL = new KerberosPrincipal();
    public static final ConnectionProperty<File> KERBEROS_CONFIG_PATH = new KerberosConfigPath();
    public static final ConnectionProperty<File> KERBEROS_KEYTAB_PATH = new KerberosKeytabPath();
    public static final ConnectionProperty<File> KERBEROS_CREDENTIAL_CACHE_PATH = new KerberosCredentialCachePath();
    public static final ConnectionProperty<String> ACCESS_TOKEN = new AccessToken();
    public static final ConnectionProperty<Map<String, String>> EXTRA_CREDENTIALS = new ExtraCredentials();
    private static final Set<ConnectionProperty<?>> ALL_PROPERTIES = ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add(USER)).add(PASSWORD)).add(SOCKS_PROXY)).add(HTTP_PROXY)).add(APPLICATION_NAME_PREFIX)).add(SSL)).add(SSL_KEY_STORE_PATH)).add(SSL_KEY_STORE_PASSWORD)).add(SSL_TRUST_STORE_PATH)).add(SSL_TRUST_STORE_PASSWORD)).add(KERBEROS_REMOTE_SERVICE_NAME)).add(KERBEROS_SERVICE_PRINCIPAL_PATTERN)).add(KERBEROS_USE_CANONICAL_HOSTNAME)).add(KERBEROS_PRINCIPAL)).add(KERBEROS_CONFIG_PATH)).add(KERBEROS_KEYTAB_PATH)).add(KERBEROS_CREDENTIAL_CACHE_PATH)).add(ACCESS_TOKEN)).add(EXTRA_CREDENTIALS)).build();
    private static final Map<String, ConnectionProperty<?>> KEY_LOOKUP = Collections.unmodifiableMap(ALL_PROPERTIES.stream().collect(Collectors.toMap(ConnectionProperty::getKey, Function.identity())));
    private static final Map<String, String> DEFAULTS;

    private ConnectionProperties() {
    }

    public static ConnectionProperty<?> forKey(String propertiesKey) {
        return KEY_LOOKUP.get(propertiesKey);
    }

    public static Set<ConnectionProperty<?>> allProperties() {
        return ALL_PROPERTIES;
    }

    public static Map<String, String> getDefaults() {
        return DEFAULTS;
    }

    private static Predicate<Properties> isKerberosEnabled() {
        return AbstractConnectionProperty.checkedPredicate(properties -> KERBEROS_REMOTE_SERVICE_NAME.getValue((Properties)properties).isPresent());
    }

    static {
        ImmutableMap.Builder defaults = ImmutableMap.builder();
        for (ConnectionProperty<?> property : ALL_PROPERTIES) {
            property.getDefault().ifPresent(value -> defaults.put(property.getKey(), value));
        }
        DEFAULTS = defaults.build();
    }

    private static class ExtraCredentials
    extends AbstractConnectionProperty<Map<String, String>> {
        private static final CharMatcher PRINTABLE_ASCII = CharMatcher.inRange('!', '~');

        public ExtraCredentials() {
            super("extraCredentials", NOT_REQUIRED, ALLOWED, ExtraCredentials::parseExtraCredentials);
        }

        public static Map<String, String> parseExtraCredentials(String extraCredentialString) {
            return Splitter.on(';').splitToList(extraCredentialString).stream().map(ExtraCredentials::parseSingleCredential).collect(ImmutableMap.toImmutableMap(entry -> (String)entry.get(0), entry -> (String)entry.get(1)));
        }

        public static List<String> parseSingleCredential(String credential) {
            List<String> nameValue = Splitter.on(':').splitToList(credential);
            Preconditions.checkArgument(nameValue.size() == 2, "Malformed credential: %s", (Object)credential);
            String name = nameValue.get(0);
            String value = nameValue.get(1);
            Preconditions.checkArgument(!name.isEmpty(), "Credential name is empty");
            Preconditions.checkArgument(!value.isEmpty(), "Credential value is empty");
            Preconditions.checkArgument(PRINTABLE_ASCII.matchesAllOf(name), "Credential name contains spaces or is not printable ASCII: %s", (Object)name);
            Preconditions.checkArgument(PRINTABLE_ASCII.matchesAllOf(value), "Credential value contains spaces or is not printable ASCII: %s", (Object)name);
            return nameValue;
        }
    }

    private static class AccessToken
    extends AbstractConnectionProperty<String> {
        public AccessToken() {
            super("accessToken", NOT_REQUIRED, ALLOWED, STRING_CONVERTER);
        }
    }

    private static class KerberosCredentialCachePath
    extends AbstractConnectionProperty<File> {
        public KerberosCredentialCachePath() {
            super("KerberosCredentialCachePath", NOT_REQUIRED, ConnectionProperties.isKerberosEnabled(), FILE_CONVERTER);
        }
    }

    private static class KerberosKeytabPath
    extends AbstractConnectionProperty<File> {
        public KerberosKeytabPath() {
            super("KerberosKeytabPath", NOT_REQUIRED, ConnectionProperties.isKerberosEnabled(), FILE_CONVERTER);
        }
    }

    private static class KerberosConfigPath
    extends AbstractConnectionProperty<File> {
        public KerberosConfigPath() {
            super("KerberosConfigPath", NOT_REQUIRED, ConnectionProperties.isKerberosEnabled(), FILE_CONVERTER);
        }
    }

    private static class KerberosUseCanonicalHostname
    extends AbstractConnectionProperty<Boolean> {
        public KerberosUseCanonicalHostname() {
            super("KerberosUseCanonicalHostname", Optional.of("true"), ConnectionProperties.isKerberosEnabled(), ALLOWED, BOOLEAN_CONVERTER);
        }
    }

    private static class KerberosPrincipal
    extends AbstractConnectionProperty<String> {
        public KerberosPrincipal() {
            super("KerberosPrincipal", NOT_REQUIRED, ConnectionProperties.isKerberosEnabled(), STRING_CONVERTER);
        }
    }

    private static class KerberosServicePrincipalPattern
    extends AbstractConnectionProperty<String> {
        public KerberosServicePrincipalPattern() {
            super("KerberosServicePrincipalPattern", Optional.of("${SERVICE}@${HOST}"), ConnectionProperties.isKerberosEnabled(), ALLOWED, STRING_CONVERTER);
        }
    }

    private static class KerberosRemoteServiceName
    extends AbstractConnectionProperty<String> {
        public KerberosRemoteServiceName() {
            super("KerberosRemoteServiceName", NOT_REQUIRED, ALLOWED, STRING_CONVERTER);
        }
    }

    private static class SslTrustStorePassword
    extends AbstractConnectionProperty<String> {
        private static final Predicate<Properties> IF_TRUST_STORE = SslTrustStorePassword.checkedPredicate(properties -> SSL_TRUST_STORE_PATH.getValue((Properties)properties).isPresent());

        public SslTrustStorePassword() {
            super("SSLTrustStorePassword", NOT_REQUIRED, IF_TRUST_STORE, STRING_CONVERTER);
        }
    }

    private static class SslTrustStorePath
    extends AbstractConnectionProperty<String> {
        private static final Predicate<Properties> IF_SSL_ENABLED = SslTrustStorePath.checkedPredicate(properties -> SSL.getValue((Properties)properties).orElse(false));

        public SslTrustStorePath() {
            super("SSLTrustStorePath", NOT_REQUIRED, IF_SSL_ENABLED, STRING_CONVERTER);
        }
    }

    private static class SslKeyStorePassword
    extends AbstractConnectionProperty<String> {
        private static final Predicate<Properties> IF_KEY_STORE = SslKeyStorePassword.checkedPredicate(properties -> SSL_KEY_STORE_PATH.getValue((Properties)properties).isPresent());

        public SslKeyStorePassword() {
            super("SSLKeyStorePassword", NOT_REQUIRED, IF_KEY_STORE, STRING_CONVERTER);
        }
    }

    private static class SslKeyStorePath
    extends AbstractConnectionProperty<String> {
        private static final Predicate<Properties> IF_SSL_ENABLED = SslKeyStorePath.checkedPredicate(properties -> SSL.getValue((Properties)properties).orElse(false));

        public SslKeyStorePath() {
            super("SSLKeyStorePath", NOT_REQUIRED, IF_SSL_ENABLED, STRING_CONVERTER);
        }
    }

    private static class Ssl
    extends AbstractConnectionProperty<Boolean> {
        public Ssl() {
            super("SSL", NOT_REQUIRED, ALLOWED, BOOLEAN_CONVERTER);
        }
    }

    private static class ApplicationNamePrefix
    extends AbstractConnectionProperty<String> {
        public ApplicationNamePrefix() {
            super("applicationNamePrefix", NOT_REQUIRED, ALLOWED, STRING_CONVERTER);
        }
    }

    private static class HttpProxy
    extends AbstractConnectionProperty<HostAndPort> {
        private static final Predicate<Properties> NO_SOCKS_PROXY = HttpProxy.checkedPredicate(properties -> !SOCKS_PROXY.getValue((Properties)properties).isPresent());

        public HttpProxy() {
            super("httpProxy", NOT_REQUIRED, NO_SOCKS_PROXY, HostAndPort::fromString);
        }
    }

    private static class SocksProxy
    extends AbstractConnectionProperty<HostAndPort> {
        private static final Predicate<Properties> NO_HTTP_PROXY = SocksProxy.checkedPredicate(properties -> !HTTP_PROXY.getValue((Properties)properties).isPresent());

        public SocksProxy() {
            super("socksProxy", NOT_REQUIRED, NO_HTTP_PROXY, HostAndPort::fromString);
        }
    }

    private static class Password
    extends AbstractConnectionProperty<String> {
        public Password() {
            super("password", NOT_REQUIRED, ALLOWED, STRING_CONVERTER);
        }
    }

    private static class User
    extends AbstractConnectionProperty<String> {
        public User() {
            super("user", REQUIRED, ALLOWED, NON_EMPTY_STRING_CONVERTER);
        }
    }
}

